/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;

public class BeanPropertyMap
implements Serializable,
Iterable<SettableBeanProperty> {
    private static final long serialVersionUID = 2L;
    protected final boolean _caseInsensitive;
    private int _hashMask;
    private int _size;
    private int _spillCount;
    private Object[] _hashArea;
    private final SettableBeanProperty[] _propsInOrder;
    private final Map<String, List<PropertyName>> _aliasDefs;
    private final Map<String, String> _aliasMapping;
    private final Locale _locale;

    public BeanPropertyMap(boolean bl, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, Locale locale) {
        this._caseInsensitive = bl;
        this._propsInOrder = collection.toArray(new SettableBeanProperty[collection.size()]);
        this._aliasDefs = map;
        this._locale = locale;
        this._aliasMapping = this._buildAliasMapping(map, bl, locale);
        this.init(collection);
    }

    @Deprecated
    public BeanPropertyMap(boolean bl, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map) {
        this(bl, collection, map, Locale.getDefault());
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, int n, int n2) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this._locale = beanPropertyMap._locale;
        this._hashMask = beanPropertyMap._hashMask;
        this._size = beanPropertyMap._size;
        this._spillCount = beanPropertyMap._spillCount;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._hashArea = Arrays.copyOf(beanPropertyMap._hashArea, beanPropertyMap._hashArea.length);
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, beanPropertyMap._propsInOrder.length);
        this._hashArea[n] = settableBeanProperty;
        this._propsInOrder[n2] = settableBeanProperty;
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, String string, int n) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this._locale = beanPropertyMap._locale;
        this._hashMask = beanPropertyMap._hashMask;
        this._size = beanPropertyMap._size;
        this._spillCount = beanPropertyMap._spillCount;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._hashArea = Arrays.copyOf(beanPropertyMap._hashArea, beanPropertyMap._hashArea.length);
        int n2 = beanPropertyMap._propsInOrder.length;
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, n2 + 1);
        this._propsInOrder[n2] = settableBeanProperty;
        int n3 = this._hashMask + 1;
        int n4 = n << 1;
        if (this._hashArea[n4] != null && this._hashArea[n4 = n3 + (n >> 1) << 1] != null) {
            n4 = (n3 + (n3 >> 1) << 1) + this._spillCount;
            this._spillCount += 2;
            if (n4 >= this._hashArea.length) {
                this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length + 4);
            }
        }
        this._hashArea[n4] = string;
        this._hashArea[n4 + 1] = settableBeanProperty;
    }

    protected BeanPropertyMap(BeanPropertyMap beanPropertyMap, boolean bl) {
        this._caseInsensitive = bl;
        this._locale = beanPropertyMap._locale;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, beanPropertyMap._propsInOrder.length);
        this.init(Arrays.asList(this._propsInOrder));
    }

    public BeanPropertyMap withCaseInsensitivity(boolean bl) {
        if (this._caseInsensitive == bl) {
            return this;
        }
        return new BeanPropertyMap(this, bl);
    }

    protected void init(Collection<SettableBeanProperty> collection) {
        this._size = collection.size();
        int n = BeanPropertyMap.findSize(this._size);
        this._hashMask = n - 1;
        int n2 = (n + (n >> 1)) * 2;
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        for (SettableBeanProperty settableBeanProperty : collection) {
            if (settableBeanProperty == null) continue;
            String string = this.getPropertyName(settableBeanProperty);
            int n4 = this._hashCode(string);
            int n5 = n4 << 1;
            if (objectArray[n5] != null && objectArray[n5 = n + (n4 >> 1) << 1] != null) {
                n5 = (n + (n >> 1) << 1) + n3;
                n3 += 2;
                if (n5 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n5] = string;
            objectArray[n5 + 1] = settableBeanProperty;
        }
        this._hashArea = objectArray;
        this._spillCount = n3;
    }

    private static final int findSize(int n) {
        int n2;
        if (n <= 5) {
            return 8;
        }
        if (n <= 12) {
            return 16;
        }
        int n3 = n + (n >> 2);
        for (n2 = 32; n2 < n3; n2 += n2) {
        }
        return n2;
    }

    public static BeanPropertyMap construct(MapperConfig<?> mapperConfig, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, boolean bl) {
        return new BeanPropertyMap(bl, collection, map, mapperConfig.getLocale());
    }

    @Deprecated
    public static BeanPropertyMap construct(MapperConfig<?> mapperConfig, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map) {
        return new BeanPropertyMap(mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES), collection, map, mapperConfig.getLocale());
    }

    @Deprecated
    public static BeanPropertyMap construct(Collection<SettableBeanProperty> collection, boolean bl, Map<String, List<PropertyName>> map) {
        return new BeanPropertyMap(bl, collection, map);
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n;
        String string = this.getPropertyName(settableBeanProperty);
        int n2 = this._hashArea.length;
        for (n = 1; n < n2; n += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[n];
            if (settableBeanProperty2 == null || !settableBeanProperty2.getName().equals(string)) continue;
            return new BeanPropertyMap(this, settableBeanProperty, n, this._findFromOrdered(settableBeanProperty2));
        }
        n = this._hashCode(string);
        return new BeanPropertyMap(this, settableBeanProperty, string, n);
    }

    public BeanPropertyMap assignIndexes() {
        int n = 0;
        int n2 = this._hashArea.length;
        for (int i = 1; i < n2; i += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty == null) continue;
            settableBeanProperty.assignIndex(n++);
        }
        return this;
    }

    public BeanPropertyMap renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        int n = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n);
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i];
            if (settableBeanProperty == null) {
                arrayList.add(settableBeanProperty);
                continue;
            }
            arrayList.add(this._rename(settableBeanProperty, nameTransformer));
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList, this._aliasDefs, this._locale);
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection) {
        return this.withoutProperties(collection, null);
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection, Collection<String> collection2) {
        if ((collection == null || collection.isEmpty()) && collection2 == null) {
            return this;
        }
        int n = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n);
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i];
            if (settableBeanProperty == null || IgnorePropertiesUtil.shouldIgnore(settableBeanProperty.getName(), collection, collection2)) continue;
            arrayList.add(settableBeanProperty);
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList, this._aliasDefs, this._locale);
    }

    public void replace(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        int n = 1;
        int n2 = this._hashArea.length;
        while (true) {
            if (n >= n2) {
                throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't replace");
            }
            if (this._hashArea[n] == settableBeanProperty) break;
            n += 2;
        }
        this._hashArea[n] = settableBeanProperty2;
        this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty)] = settableBeanProperty2;
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this._size);
        String string = this.getPropertyName(settableBeanProperty);
        boolean bl = false;
        int n = this._hashArea.length;
        for (int i = 1; i < n; i += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty2 == null) continue;
            if (!bl && (bl = string.equals(this._hashArea[i - 1]))) {
                this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty2)] = null;
                continue;
            }
            arrayList.add(settableBeanProperty2);
        }
        if (!bl) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't remove");
        }
        this.init(arrayList);
    }

    public int size() {
        return this._size;
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    public boolean hasAliases() {
        return !this._aliasDefs.isEmpty();
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return this._properties().iterator();
    }

    private List<SettableBeanProperty> _properties() {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this._size);
        int n = this._hashArea.length;
        for (int i = 1; i < n; i += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty == null) continue;
            arrayList.add(settableBeanProperty);
        }
        return arrayList;
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        return this._propsInOrder;
    }

    protected final String getPropertyName(SettableBeanProperty settableBeanProperty) {
        return this._caseInsensitive ? settableBeanProperty.getName().toLowerCase(this._locale) : settableBeanProperty.getName();
    }

    public SettableBeanProperty find(int n) {
        int n2 = this._hashArea.length;
        for (int i = 1; i < n2; i += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty == null || n != settableBeanProperty.getPropertyIndex()) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public SettableBeanProperty find(String string) {
        int n;
        int n2;
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("Cannot pass null property name");
        }
        if (this._caseInsensitive) {
            string = string.toLowerCase(this._locale);
        }
        if ((object = this._hashArea[n2 = (n = string.hashCode() & this._hashMask) << 1]) == string || string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n2 + 1];
        }
        return this._find2(string, n, object);
    }

    private final SettableBeanProperty _find2(String string, int n, Object object) {
        if (object == null) {
            return this._findWithAlias(this._aliasMapping.get(string));
        }
        int n2 = this._hashMask + 1;
        int n3 = n2 + (n >> 1) << 1;
        object = this._hashArea[n3];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        if (object != null) {
            int n4;
            int n5 = n4 + this._spillCount;
            for (n4 = n2 + (n2 >> 1) << 1; n4 < n5; n4 += 2) {
                object = this._hashArea[n4];
                if (object != string && !string.equals(object)) continue;
                return (SettableBeanProperty)this._hashArea[n4 + 1];
            }
        }
        return this._findWithAlias(this._aliasMapping.get(string));
    }

    private SettableBeanProperty _findWithAlias(String string) {
        if (string == null) {
            return null;
        }
        int n = this._hashCode(string);
        int n2 = n << 1;
        Object object = this._hashArea[n2];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n2 + 1];
        }
        if (object == null) {
            return null;
        }
        return this._find2ViaAlias(string, n, object);
    }

    private SettableBeanProperty _find2ViaAlias(String string, int n, Object object) {
        int n2 = this._hashMask + 1;
        int n3 = n2 + (n >> 1) << 1;
        object = this._hashArea[n3];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        if (object != null) {
            int n4;
            int n5 = n4 + this._spillCount;
            for (n4 = n2 + (n2 >> 1) << 1; n4 < n5; n4 += 2) {
                object = this._hashArea[n4];
                if (object != string && !string.equals(object)) continue;
                return (SettableBeanProperty)this._hashArea[n4 + 1];
            }
        }
        return null;
    }

    public boolean findDeserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException {
        SettableBeanProperty settableBeanProperty = this.find(string);
        if (settableBeanProperty == null) {
            return false;
        }
        try {
            settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, object, string, deserializationContext);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Properties=[");
        int n = 0;
        for (SettableBeanProperty settableBeanProperty : this) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(settableBeanProperty.getName());
            stringBuilder.append('(');
            stringBuilder.append(settableBeanProperty.getType());
            stringBuilder.append(')');
        }
        stringBuilder.append(']');
        if (!this._aliasDefs.isEmpty()) {
            stringBuilder.append("(aliases: ");
            stringBuilder.append(this._aliasDefs);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    protected SettableBeanProperty _rename(SettableBeanProperty settableBeanProperty, NameTransformer nameTransformer) {
        JsonDeserializer<Object> jsonDeserializer;
        if (settableBeanProperty == null) {
            return settableBeanProperty;
        }
        String string = nameTransformer.transform(settableBeanProperty.getName());
        JsonDeserializer<Object> jsonDeserializer2 = (settableBeanProperty = settableBeanProperty.withSimpleName(string)).getValueDeserializer();
        if (jsonDeserializer2 != null && (jsonDeserializer = jsonDeserializer2.unwrappingDeserializer(nameTransformer)) != jsonDeserializer2) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        }
        return settableBeanProperty;
    }

    protected void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    private final int _findFromOrdered(SettableBeanProperty settableBeanProperty) {
        int n = this._propsInOrder.length;
        for (int i = 0; i < n; ++i) {
            if (this._propsInOrder[i] != settableBeanProperty) continue;
            return i;
        }
        throw new IllegalStateException("Illegal state: property '" + settableBeanProperty.getName() + "' missing from _propsInOrder");
    }

    private final int _hashCode(String string) {
        return string.hashCode() & this._hashMask;
    }

    private Map<String, String> _buildAliasMapping(Map<String, List<PropertyName>> map, boolean bl, Locale locale) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<PropertyName>> entry : map.entrySet()) {
            String string = entry.getKey();
            if (bl) {
                string = string.toLowerCase(locale);
            }
            for (PropertyName propertyName : entry.getValue()) {
                String string2 = propertyName.getSimpleName();
                if (bl) {
                    string2 = string2.toLowerCase(locale);
                }
                hashMap.put(string2, string);
            }
        }
        return hashMap;
    }
}

