/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    private static final int SER_FEATURE_DEFAULTS = SerializationConfig.collectFeatureDefaults(SerializationFeature.class);
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _serFeatures;
    protected final int _generatorFeatures;
    protected final int _generatorFeaturesToChange;
    protected final int _formatWriteFeatures;
    protected final int _formatWriteFeaturesToChange;

    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = SER_FEATURE_DEFAULTS;
        this._filterProvider = null;
        this._defaultPrettyPrinter = DEFAULT_PRETTY_PRINTER;
        this._generatorFeatures = 0;
        this._generatorFeaturesToChange = 0;
        this._formatWriteFeatures = 0;
        this._formatWriteFeaturesToChange = 0;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(serializationConfig, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    @Deprecated
    protected SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        this(serializationConfig, serializationConfig._subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
    }

    private SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver) {
        super(serializationConfig, subtypeResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, long l, int n, int n2, int n3, int n4, int n5) {
        super(serializationConfig, l);
        this._serFeatures = n;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = n2;
        this._generatorFeaturesToChange = n3;
        this._formatWriteFeatures = n4;
        this._formatWriteFeaturesToChange = n5;
    }

    private SerializationConfig(SerializationConfig serializationConfig, BaseSettings baseSettings) {
        super(serializationConfig, baseSettings);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, FilterProvider filterProvider) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, Class<?> clazz) {
        super(serializationConfig, clazz);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig serializationConfig, PropertyName propertyName) {
        super(serializationConfig, propertyName);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, ContextAttributes contextAttributes) {
        super(serializationConfig, contextAttributes);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(serializationConfig, simpleMixInResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    protected SerializationConfig(SerializationConfig serializationConfig, PrettyPrinter prettyPrinter) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = prettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    @Override
    protected final SerializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new SerializationConfig(this, baseSettings);
    }

    @Override
    protected final SerializationConfig _withMapperFeatures(long l) {
        return new SerializationConfig(this, l, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    @Override
    public SerializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new SerializationConfig(this, propertyName);
    }

    @Override
    public SerializationConfig with(SubtypeResolver subtypeResolver) {
        return subtypeResolver == this._subtypeResolver ? this : new SerializationConfig(this, subtypeResolver);
    }

    @Override
    public SerializationConfig withView(Class<?> clazz) {
        return this._view == clazz ? this : new SerializationConfig(this, clazz);
    }

    @Override
    public SerializationConfig with(ContextAttributes contextAttributes) {
        return contextAttributes == this._attributes ? this : new SerializationConfig(this, contextAttributes);
    }

    @Override
    public SerializationConfig with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = (SerializationConfig)super.with(dateFormat);
        if (dateFormat == null) {
            return serializationConfig.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return serializationConfig.without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public SerializationConfig with(SerializationFeature serializationFeature) {
        int n = this._serFeatures | serializationFeature.getMask();
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures | serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n |= serializationFeature2.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withFeatures(SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n |= serializationFeature.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature) {
        int n = this._serFeatures & ~serializationFeature.getMask();
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures & ~serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n &= ~serializationFeature2.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        int n = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n &= ~serializationFeature.getMask();
        }
        return n == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(JsonGenerator.Feature feature) {
        int n = this._generatorFeatures | feature.getMask();
        int n2 = this._generatorFeaturesToChange | feature.getMask();
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withFeatures(JsonGenerator.Feature ... featureArray) {
        int n = this._generatorFeatures;
        int n2 = this._generatorFeaturesToChange;
        for (JsonGenerator.Feature feature : featureArray) {
            int n3 = feature.getMask();
            n |= n3;
            n2 |= n3;
        }
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(JsonGenerator.Feature feature) {
        int n = this._generatorFeatures & ~feature.getMask();
        int n2 = this._generatorFeaturesToChange | feature.getMask();
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig withoutFeatures(JsonGenerator.Feature ... featureArray) {
        int n = this._generatorFeatures;
        int n2 = this._generatorFeaturesToChange;
        for (JsonGenerator.Feature feature : featureArray) {
            int n3 = feature.getMask();
            n &= ~n3;
            n2 |= n3;
        }
        return this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonWriteFeature) {
            return this._withJsonWriteFeatures(formatFeature);
        }
        int n = this._formatWriteFeatures | formatFeature.getMask();
        int n2 = this._formatWriteFeaturesToChange | formatFeature.getMask();
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig withFeatures(FormatFeature ... formatFeatureArray) {
        if (formatFeatureArray.length > 0 && formatFeatureArray[0] instanceof JsonWriteFeature) {
            return this._withJsonWriteFeatures(formatFeatureArray);
        }
        int n = this._formatWriteFeatures;
        int n2 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n3 = formatFeature.getMask();
            n |= n3;
            n2 |= n3;
        }
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig without(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonWriteFeature) {
            return this._withoutJsonWriteFeatures(formatFeature);
        }
        int n = this._formatWriteFeatures & ~formatFeature.getMask();
        int n2 = this._formatWriteFeaturesToChange | formatFeature.getMask();
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    public SerializationConfig withoutFeatures(FormatFeature ... formatFeatureArray) {
        if (formatFeatureArray.length > 0 && formatFeatureArray[0] instanceof JsonWriteFeature) {
            return this._withoutJsonWriteFeatures(formatFeatureArray);
        }
        int n = this._formatWriteFeatures;
        int n2 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n3 = formatFeature.getMask();
            n &= ~n3;
            n2 |= n3;
        }
        return this._formatWriteFeatures == n && this._formatWriteFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, n, n2);
    }

    private SerializationConfig _withJsonWriteFeatures(FormatFeature ... formatFeatureArray) {
        int n = this._generatorFeatures;
        int n2 = this._generatorFeaturesToChange;
        int n3 = this._formatWriteFeatures;
        int n4 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            JsonGenerator.Feature feature;
            int n5 = formatFeature.getMask();
            n3 |= n5;
            n4 |= n5;
            if (!(formatFeature instanceof JsonWriteFeature) || (feature = ((JsonWriteFeature)formatFeature).mappedFeature()) == null) continue;
            int n6 = feature.getMask();
            n |= n6;
            n2 |= n6;
        }
        return this._formatWriteFeatures == n3 && this._formatWriteFeaturesToChange == n4 && this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, n3, n4);
    }

    private SerializationConfig _withoutJsonWriteFeatures(FormatFeature ... formatFeatureArray) {
        int n = this._generatorFeatures;
        int n2 = this._generatorFeaturesToChange;
        int n3 = this._formatWriteFeatures;
        int n4 = this._formatWriteFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            JsonGenerator.Feature feature;
            int n5 = formatFeature.getMask();
            n3 &= ~n5;
            n4 |= n5;
            if (!(formatFeature instanceof JsonWriteFeature) || (feature = ((JsonWriteFeature)formatFeature).mappedFeature()) == null) continue;
            int n6 = feature.getMask();
            n &= ~n6;
            n2 |= n6;
        }
        return this._formatWriteFeatures == n3 && this._formatWriteFeaturesToChange == n4 && this._generatorFeatures == n && this._generatorFeaturesToChange == n2 ? this : new SerializationConfig(this, this._mapperFeatures, this._serFeatures, n, n2, n3, n4);
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        return filterProvider == this._filterProvider ? this : new SerializationConfig(this, filterProvider);
    }

    @Deprecated
    public SerializationConfig withPropertyInclusion(JsonInclude.Value value) {
        this._configOverrides.setDefaultInclusion(value);
        return this;
    }

    public SerializationConfig withDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this._defaultPrettyPrinter == prettyPrinter ? this : new SerializationConfig(this, prettyPrinter);
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        PrettyPrinter prettyPrinter = this._defaultPrettyPrinter;
        if (prettyPrinter instanceof Instantiatable) {
            prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
        }
        return prettyPrinter;
    }

    public void initialize(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter;
        if (SerializationFeature.INDENT_OUTPUT.enabledIn(this._serFeatures) && jsonGenerator.getPrettyPrinter() == null && (prettyPrinter = this.constructDefaultPrettyPrinter()) != null) {
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        }
        boolean bl = SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._serFeatures);
        int n = this._generatorFeaturesToChange;
        if (n != 0 || bl) {
            int n2 = this._generatorFeatures;
            if (bl) {
                int n3 = JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.getMask();
                n2 |= n3;
                n |= n3;
            }
            jsonGenerator.overrideStdFeatures(n2, n);
        }
        if (this._formatWriteFeaturesToChange != 0) {
            jsonGenerator.overrideFormatFeatures(this._formatWriteFeatures, this._formatWriteFeaturesToChange);
        }
    }

    @Deprecated
    public JsonInclude.Include getSerializationInclusion() {
        JsonInclude.Include include = this.getDefaultPropertyInclusion().getValueInclusion();
        return include == JsonInclude.Include.USE_DEFAULTS ? JsonInclude.Include.ALWAYS : include;
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return (this._serFeatures & serializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature, JsonFactory jsonFactory) {
        int n = feature.getMask();
        if ((this._generatorFeaturesToChange & n) != 0) {
            return (this._generatorFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int n) {
        return (this._serFeatures & n) == n;
    }

    public final int getSerializationFeatures() {
        return this._serFeatures;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter getDefaultPrettyPrinter() {
        return this._defaultPrettyPrinter;
    }

    public BeanDescription introspect(JavaType javaType) {
        return this.getClassIntrospector().forSerialization(this, javaType, this);
    }
}

