/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public abstract class PropertyNamingStrategies
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new LowerCamelCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy UPPER_SNAKE_CASE = new UpperSnakeCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    public static final PropertyNamingStrategy LOWER_DOT_CASE = new LowerDotCaseStrategy();

    public static class LowerDotCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return this.translateLowerCaseWithSeparator(string, '.');
        }
    }

    public static class KebabCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return this.translateLowerCaseWithSeparator(string, '-');
        }
    }

    public static class LowerCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return string.toLowerCase();
        }
    }

    public static class UpperCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            char c;
            if (string == null || string.isEmpty()) {
                return string;
            }
            char c2 = string.charAt(0);
            if (c2 == (c = Character.toUpperCase(c2))) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, c);
            return stringBuilder.toString();
        }
    }

    public static class LowerCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return string;
        }
    }

    public static class UpperSnakeCaseStrategy
    extends SnakeCaseStrategy {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            String string2 = super.translate(string);
            if (string2 == null) {
                return null;
            }
            return super.translate(string).toUpperCase();
        }
    }

    public static class SnakeCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n * 2);
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (i <= 0 && c == '_') continue;
                if (Character.isUpperCase(c)) {
                    if (!bl && n2 > 0 && stringBuilder.charAt(n2 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n2;
                    }
                    c = Character.toLowerCase(c);
                    bl = true;
                } else {
                    bl = false;
                }
                stringBuilder.append(c);
                ++n2;
            }
            return n2 > 0 ? stringBuilder.toString() : string;
        }
    }

    public static abstract class NamingBase
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = 2L;

        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);

        protected String translateLowerCaseWithSeparator(String string, char c) {
            if (string == null) {
                return string;
            }
            int n = string.length();
            if (n == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(n + (n >> 1));
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c2 = string.charAt(i);
                char c3 = Character.toLowerCase(c2);
                if (c3 == c2) {
                    if (n2 > 1) {
                        stringBuilder.insert(stringBuilder.length() - 1, c);
                    }
                    n2 = 0;
                } else {
                    if (n2 == 0 && i > 0) {
                        stringBuilder.append(c);
                    }
                    ++n2;
                }
                stringBuilder.append(c3);
            }
            return stringBuilder.toString();
        }
    }
}

