/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import java.util.concurrent.atomic.AtomicReferenceArray;

public class BufferRecycler {
    public static final int BYTE_READ_IO_BUFFER = 0;
    public static final int BYTE_WRITE_ENCODING_BUFFER = 1;
    public static final int BYTE_WRITE_CONCAT_BUFFER = 2;
    public static final int BYTE_BASE64_CODEC_BUFFER = 3;
    public static final int CHAR_TOKEN_BUFFER = 0;
    public static final int CHAR_CONCAT_BUFFER = 1;
    public static final int CHAR_TEXT_BUFFER = 2;
    public static final int CHAR_NAME_COPY_BUFFER = 3;
    private static final int[] BYTE_BUFFER_LENGTHS = new int[]{8000, 8000, 2000, 2000};
    private static final int[] CHAR_BUFFER_LENGTHS = new int[]{4000, 4000, 200, 200};
    protected final AtomicReferenceArray<byte[]> _byteBuffers;
    protected final AtomicReferenceArray<char[]> _charBuffers;

    public BufferRecycler() {
        this(4, 4);
    }

    protected BufferRecycler(int n, int n2) {
        this._byteBuffers = new AtomicReferenceArray(n);
        this._charBuffers = new AtomicReferenceArray(n2);
    }

    public final byte[] allocByteBuffer(int n) {
        return this.allocByteBuffer(n, 0);
    }

    public byte[] allocByteBuffer(int n, int n2) {
        byte[] byArray;
        int n3 = this.byteBufferLength(n);
        if (n2 < n3) {
            n2 = n3;
        }
        if ((byArray = (byte[])this._byteBuffers.getAndSet(n, null)) == null || byArray.length < n2) {
            byArray = this.balloc(n2);
        }
        return byArray;
    }

    public void releaseByteBuffer(int n, byte[] byArray) {
        this._byteBuffers.set(n, byArray);
    }

    public final char[] allocCharBuffer(int n) {
        return this.allocCharBuffer(n, 0);
    }

    public char[] allocCharBuffer(int n, int n2) {
        char[] cArray;
        int n3 = this.charBufferLength(n);
        if (n2 < n3) {
            n2 = n3;
        }
        if ((cArray = (char[])this._charBuffers.getAndSet(n, null)) == null || cArray.length < n2) {
            cArray = this.calloc(n2);
        }
        return cArray;
    }

    public void releaseCharBuffer(int n, char[] cArray) {
        this._charBuffers.set(n, cArray);
    }

    protected int byteBufferLength(int n) {
        return BYTE_BUFFER_LENGTHS[n];
    }

    protected int charBufferLength(int n) {
        return CHAR_BUFFER_LENGTHS[n];
    }

    protected byte[] balloc(int n) {
        return new byte[n];
    }

    protected char[] calloc(int n) {
        return new char[n];
    }
}

