/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 150;
    protected final CharsToNameCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;
    protected final int _seed;
    protected final int _flags;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _hashShared;
    protected BitSet _overflows;

    private CharsToNameCanonicalizer(int n) {
        this._parent = null;
        this._seed = n;
        this._canonicalize = true;
        this._flags = -1;
        this._hashShared = false;
        this._longestCollisionList = 0;
        this._tableInfo = new AtomicReference<TableInfo>(TableInfo.createInitial(64));
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, int n, int n2, TableInfo tableInfo) {
        this._parent = charsToNameCanonicalizer;
        this._seed = n2;
        this._tableInfo = null;
        this._flags = n;
        this._canonicalize = JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n);
        this._symbols = tableInfo.symbols;
        this._buckets = tableInfo.buckets;
        this._size = tableInfo.size;
        this._longestCollisionList = tableInfo.longestCollisionList;
        int n3 = this._symbols.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n3);
        this._indexMask = n3 - 1;
        this._hashShared = true;
    }

    private static int _thresholdSize(int n) {
        return n - (n >> 2);
    }

    public static CharsToNameCanonicalizer createRoot() {
        long l = System.currentTimeMillis();
        int n = (int)l + (int)(l >>> 32) | 1;
        return CharsToNameCanonicalizer.createRoot(n);
    }

    protected static CharsToNameCanonicalizer createRoot(int n) {
        return new CharsToNameCanonicalizer(n);
    }

    public CharsToNameCanonicalizer makeChild(int n) {
        return new CharsToNameCanonicalizer(this, n, this._seed, this._tableInfo.get());
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(new TableInfo(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(TableInfo tableInfo) {
        int n = tableInfo.size;
        TableInfo tableInfo2 = this._tableInfo.get();
        if (n == tableInfo2.size) {
            return;
        }
        if (n > 12000) {
            tableInfo = TableInfo.createInitial(64);
        }
        this._tableInfo.compareAndSet(tableInfo2, tableInfo);
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().size;
        }
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return !this._hashShared;
    }

    public int hashSeed() {
        return this._seed;
    }

    public int collisionCount() {
        int n = 0;
        for (Bucket bucket : this._buckets) {
            if (bucket == null) continue;
            n += bucket.length;
        }
        return n;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public String findSymbol(char[] cArray, int n, int n2, int n3) {
        if (n2 < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n, n2);
        }
        int n4 = this._hashToIndex(n3);
        String string = this._symbols[n4];
        if (string != null) {
            Bucket bucket;
            if (string.length() == n2) {
                int n5 = 0;
                while (string.charAt(n5) == cArray[n + n5]) {
                    if (++n5 != n2) continue;
                    return string;
                }
            }
            if ((bucket = this._buckets[n4 >> 1]) != null) {
                string = bucket.has(cArray, n, n2);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n, n2, bucket.next);
                if (string != null) {
                    return string;
                }
            }
        }
        return this._addSymbol(cArray, n, n2, n3, n4);
    }

    private String _findSymbol2(char[] cArray, int n, int n2, Bucket bucket) {
        while (bucket != null) {
            String string = bucket.has(cArray, n, n2);
            if (string != null) {
                return string;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private String _addSymbol(char[] cArray, int n, int n2, int n3, int n4) {
        if (this._hashShared) {
            this.copyArrays();
            this._hashShared = false;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n4 = this._hashToIndex(this.calcHash(cArray, n, n2));
        }
        String string = new String(cArray, n, n2);
        if (JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            string = InternCache.instance.intern(string);
        }
        ++this._size;
        if (this._symbols[n4] == null) {
            this._symbols[n4] = string;
        } else {
            int n5 = n4 >> 1;
            Bucket bucket = new Bucket(string, this._buckets[n5]);
            int n6 = bucket.length;
            if (n6 > 150) {
                this._handleSpillOverflow(n5, bucket, n4);
            } else {
                this._buckets[n5] = bucket;
                this._longestCollisionList = Math.max(n6, this._longestCollisionList);
            }
        }
        return string;
    }

    private void _handleSpillOverflow(int n, Bucket bucket, int n2) {
        if (this._overflows == null) {
            this._overflows = new BitSet();
            this._overflows.set(n);
        } else if (this._overflows.get(n)) {
            if (JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this._reportTooManyCollisions(150);
            }
            this._canonicalize = false;
        } else {
            this._overflows.set(n);
        }
        this._symbols[n2] = bucket.symbol;
        this._buckets[n] = null;
        this._size -= bucket.length;
        this._longestCollisionList = -1;
    }

    public int _hashToIndex(int n) {
        n += n >>> 15;
        n ^= n << 7;
        n += n >>> 3;
        return n & this._indexMask;
    }

    public int calcHash(char[] cArray, int n, int n2) {
        int n3 = this._seed;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = n3 * 33 + cArray[i];
        }
        return n3 == 0 ? 1 : n3;
    }

    public int calcHash(String string) {
        int n = string.length();
        int n2 = this._seed;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 33 + string.charAt(i);
        }
        return n2 == 0 ? 1 : n2;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        this._symbols = Arrays.copyOf(stringArray, stringArray.length);
        Bucket[] bucketArray = this._buckets;
        this._buckets = Arrays.copyOf(bucketArray, bucketArray.length);
    }

    private void rehash() {
        int n;
        int n2 = this._symbols.length;
        int n3 = n2 + n2;
        if (n3 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new Bucket[32];
            this._indexMask = 63;
            this._hashShared = false;
            return;
        }
        String[] stringArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new String[n3];
        this._buckets = new Bucket[n3 >> 1];
        this._indexMask = n3 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n3);
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            Bucket bucket;
            String string = stringArray[n];
            if (string == null) continue;
            ++n4;
            int n6 = this._hashToIndex(this.calcHash(string));
            if (this._symbols[n6] == null) {
                this._symbols[n6] = string;
                continue;
            }
            int n7 = n6 >> 1;
            this._buckets[n7] = bucket = new Bucket(string, this._buckets[n7]);
            n5 = Math.max(n5, bucket.length);
        }
        n = n2 >> 1;
        for (int i = 0; i < n; ++i) {
            Bucket bucket = bucketArray[i];
            while (bucket != null) {
                ++n4;
                String string = bucket.symbol;
                int n8 = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n8] == null) {
                    this._symbols[n8] = string;
                } else {
                    Bucket bucket2;
                    int n9 = n8 >> 1;
                    this._buckets[n9] = bucket2 = new Bucket(string, this._buckets[n9]);
                    n5 = Math.max(n5, bucket2.length);
                }
                bucket = bucket.next;
            }
        }
        this._longestCollisionList = n5;
        this._overflows = null;
        if (n4 != this._size) {
            throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", this._size, n4));
        }
    }

    protected void _reportTooManyCollisions(int n) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n + " -- suspect a DoS attack based on hash collisions");
    }

    protected void verifyInternalConsistency() {
        int n;
        int n2 = 0;
        for (String string : this._symbols) {
            if (string == null) continue;
            ++n2;
        }
        int n3 = n >> 1;
        for (int i = 0; i < n3; ++i) {
            Bucket bucket = this._buckets[i];
            while (bucket != null) {
                ++n2;
                bucket = bucket.next;
            }
        }
        if (n2 != this._size) {
            throw new IllegalStateException(String.format("Internal error: expected internal size %d vs calculated count %d", this._size, n2));
        }
    }

    private static final class TableInfo {
        final int size;
        final int longestCollisionList;
        final String[] symbols;
        final Bucket[] buckets;

        public TableInfo(int n, int n2, String[] stringArray, Bucket[] bucketArray) {
            this.size = n;
            this.longestCollisionList = n2;
            this.symbols = stringArray;
            this.buckets = bucketArray;
        }

        public TableInfo(CharsToNameCanonicalizer charsToNameCanonicalizer) {
            this.size = charsToNameCanonicalizer._size;
            this.longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
            this.symbols = charsToNameCanonicalizer._symbols;
            this.buckets = charsToNameCanonicalizer._buckets;
        }

        public static TableInfo createInitial(int n) {
            return new TableInfo(0, 0, new String[n], new Bucket[n >> 1]);
        }
    }

    static final class Bucket {
        public final String symbol;
        public final Bucket next;
        public final int length;

        public Bucket(String string, Bucket bucket) {
            this.symbol = string;
            this.next = bucket;
            this.length = bucket == null ? 1 : bucket.length + 1;
        }

        public String has(char[] cArray, int n, int n2) {
            if (this.symbol.length() != n2) {
                return null;
            }
            int n3 = 0;
            do {
                if (this.symbol.charAt(n3) == cArray[n + n3]) continue;
                return null;
            } while (++n3 < n2);
            return this.symbol;
        }
    }
}

