/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json.async;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.async.NonBlockingJsonParserBase;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.io.OutputStream;

public class NonBlockingJsonParser
extends NonBlockingJsonParserBase
implements ByteArrayFeeder {
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected byte[] _inputBuffer = NO_BYTES;
    protected int _origBufferLen;

    public NonBlockingJsonParser(IOContext iOContext, int n, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n, byteQuadsCanonicalizer);
    }

    @Override
    public ByteArrayFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    @Override
    public void feedInput(byte[] byArray, int n, int n2) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", this._inputEnd - this._inputPtr);
        }
        if (n2 < n) {
            this._reportError("Input end (%d) may not be before start (%d)", n2, n);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart = n - (this._inputEnd - this._currInputRowStart);
        this._currBufferStart = n;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n2;
        this._origBufferLen = n2 - n;
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream2) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n > 0) {
            outputStream2.write(this._inputBuffer, this._inputPtr, n);
        }
        return n;
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        VersionUtil.throwInternal();
        return ' ';
    }

    @Override
    public JsonToken nextToken() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            if (this._closed) {
                return null;
            }
            if (this._endOfInput) {
                if (this._currToken == JsonToken.NOT_AVAILABLE) {
                    return this._finishTokenWithEOF();
                }
                return this._eofAsNextToken();
            }
            return JsonToken.NOT_AVAILABLE;
        }
        if (this._currToken == JsonToken.NOT_AVAILABLE) {
            return this._finishToken();
        }
        this._numTypesValid = 0;
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        int n = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (this._majorState) {
            case 0: {
                return this._startDocument(n);
            }
            case 1: {
                return this._startValue(n);
            }
            case 2: {
                return this._startFieldName(n);
            }
            case 3: {
                return this._startFieldNameAfterComma(n);
            }
            case 4: {
                return this._startValueExpectColon(n);
            }
            case 5: {
                return this._startValue(n);
            }
            case 6: {
                return this._startValueExpectComma(n);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected final JsonToken _finishToken() throws IOException {
        switch (this._minorState) {
            case 1: {
                return this._finishBOM(this._pending32);
            }
            case 4: {
                return this._startFieldName(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 5: {
                return this._startFieldNameAfterComma(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 7: {
                return this._parseEscapedName(this._quadLength, this._pending32, this._pendingBytes);
            }
            case 8: {
                return this._finishFieldWithEscape();
            }
            case 9: {
                return this._finishAposName(this._quadLength, this._pending32, this._pendingBytes);
            }
            case 10: {
                return this._finishUnquotedName(this._quadLength, this._pending32, this._pendingBytes);
            }
            case 12: {
                return this._startValue(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 15: {
                return this._startValueAfterComma(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 13: {
                return this._startValueExpectComma(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 14: {
                return this._startValueExpectColon(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 16: {
                return this._finishKeywordToken("null", this._pending32, JsonToken.VALUE_NULL);
            }
            case 17: {
                return this._finishKeywordToken("true", this._pending32, JsonToken.VALUE_TRUE);
            }
            case 18: {
                return this._finishKeywordToken("false", this._pending32, JsonToken.VALUE_FALSE);
            }
            case 19: {
                return this._finishNonStdToken(this._nonStdTokenType, this._pending32);
            }
            case 23: {
                return this._finishNumberMinus(this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 24: {
                return this._finishNumberLeadingZeroes();
            }
            case 25: {
                return this._finishNumberLeadingNegZeroes();
            }
            case 26: {
                return this._finishNumberIntegralPart(this._textBuffer.getBufferWithoutReset(), this._textBuffer.getCurrentSegmentSize());
            }
            case 30: {
                return this._finishFloatFraction();
            }
            case 31: {
                return this._finishFloatExponent(true, this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 32: {
                return this._finishFloatExponent(false, this._inputBuffer[this._inputPtr++] & 0xFF);
            }
            case 40: {
                return this._finishRegularString();
            }
            case 42: {
                this._textBuffer.append((char)this._decodeUTF8_2(this._pending32, this._inputBuffer[this._inputPtr++]));
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 43: {
                if (!this._decodeSplitUTF8_3(this._pending32, this._pendingBytes, this._inputBuffer[this._inputPtr++])) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 44: {
                if (!this._decodeSplitUTF8_4(this._pending32, this._pendingBytes, this._inputBuffer[this._inputPtr++])) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 41: {
                int n = this._decodeSplitEscaped(this._quoted32, this._quotedDigits);
                if (n < 0) {
                    return JsonToken.NOT_AVAILABLE;
                }
                this._textBuffer.append((char)n);
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 45: {
                return this._finishAposString();
            }
            case 50: {
                return this._finishErrorToken();
            }
            case 51: {
                return this._startSlashComment(this._pending32);
            }
            case 52: {
                return this._finishCComment(this._pending32, true);
            }
            case 53: {
                return this._finishCComment(this._pending32, false);
            }
            case 54: {
                return this._finishCppComment(this._pending32);
            }
            case 55: {
                return this._finishHashComment(this._pending32);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected final JsonToken _finishTokenWithEOF() throws IOException {
        JsonToken jsonToken = this._currToken;
        switch (this._minorState) {
            case 3: {
                return this._eofAsNextToken();
            }
            case 12: {
                return this._eofAsNextToken();
            }
            case 16: {
                return this._finishKeywordTokenWithEOF("null", this._pending32, JsonToken.VALUE_NULL);
            }
            case 17: {
                return this._finishKeywordTokenWithEOF("true", this._pending32, JsonToken.VALUE_TRUE);
            }
            case 18: {
                return this._finishKeywordTokenWithEOF("false", this._pending32, JsonToken.VALUE_FALSE);
            }
            case 19: {
                return this._finishNonStdTokenWithEOF(this._nonStdTokenType, this._pending32);
            }
            case 50: {
                return this._finishErrorTokenWithEOF();
            }
            case 24: 
            case 25: {
                return this._valueCompleteInt(0, "0");
            }
            case 26: {
                int n = this._textBuffer.getCurrentSegmentSize();
                if (this._numberNegative) {
                    --n;
                }
                this._intLength = n;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            case 30: {
                this._expLength = 0;
            }
            case 32: {
                return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
            }
            case 31: {
                this._reportInvalidEOF(": was expecting fraction after exponent marker", JsonToken.VALUE_NUMBER_FLOAT);
            }
            case 52: 
            case 53: {
                this._reportInvalidEOF(": was expecting closing '*/' for comment", JsonToken.NOT_AVAILABLE);
            }
            case 54: 
            case 55: {
                return this._eofAsNextToken();
            }
        }
        this._reportInvalidEOF(": was expecting rest of token (internal state: " + this._minorState + ")", this._currToken);
        return jsonToken;
    }

    private final JsonToken _startDocument(int n) throws IOException {
        if ((n &= 0xFF) == 239 && this._minorState != 1) {
            return this._finishBOM(1);
        }
        while (n <= 32) {
            if (n != 32) {
                if (n == 10) {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                } else if (n == 13) {
                    ++this._currInputRowAlt;
                    this._currInputRowStart = this._inputPtr;
                } else if (n != 9) {
                    this._throwInvalidSpace(n);
                }
            }
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 3;
                if (this._closed) {
                    return null;
                }
                if (this._endOfInput) {
                    return this._eofAsNextToken();
                }
                return JsonToken.NOT_AVAILABLE;
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        return this._startValue(n);
    }

    private final JsonToken _finishBOM(int n) throws IOException {
        while (this._inputPtr < this._inputEnd) {
            int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (n) {
                case 3: {
                    this._currInputProcessed -= 3L;
                    return this._startDocument(n2);
                }
                case 2: {
                    if (n2 == 191) break;
                    this._reportError("Unexpected byte 0x%02x following 0xEF 0xBB; should get 0xBF as third byte of UTF-8 BOM", n2);
                    break;
                }
                case 1: {
                    if (n2 == 187) break;
                    this._reportError("Unexpected byte 0x%02x following 0xEF; should get 0xBB as second byte UTF-8 BOM", n2);
                }
            }
            ++n;
        }
        this._pending32 = n;
        this._minorState = 1;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startFieldName(int n) throws IOException {
        String string;
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 4;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n != 34) {
            if (n == 125) {
                return this._closeObjectScope();
            }
            return this._handleOddName(n);
        }
        if (this._inputPtr + 13 <= this._inputEnd && (string = this._fastParseName()) != null) {
            return this._fieldComplete(string);
        }
        return this._parseEscapedName(0, 0, 0);
    }

    private final JsonToken _startFieldNameAfterComma(int n) throws IOException {
        String string;
        int n2;
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 5;
            return this._currToken;
        }
        if (n != 44) {
            if (n == 125) {
                return this._closeObjectScope();
            }
            if (n == 35) {
                return this._finishHashComment(5);
            }
            if (n == 47) {
                return this._startSlashComment(5);
            }
            this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        if ((n2 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 4;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n = this._inputBuffer[n2];
        this._inputPtr = n2 + 1;
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 4;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n != 34) {
            if (n == 125 && (this._features & FEAT_MASK_TRAILING_COMMA) != 0) {
                return this._closeObjectScope();
            }
            return this._handleOddName(n);
        }
        if (this._inputPtr + 13 <= this._inputEnd && (string = this._fastParseName()) != null) {
            return this._fieldComplete(string);
        }
        return this._parseEscapedName(0, 0, 0);
    }

    private final JsonToken _startValue(int n) throws IOException {
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 12;
            return this._currToken;
        }
        this._updateTokenLocation();
        this._parsingContext.expectComma();
        if (n == 34) {
            return this._startString();
        }
        switch (n) {
            case 35: {
                return this._finishHashComment(12);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(12);
            }
            case 46: {
                if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) break;
                return this._startFloatThatStartsWithPeriod();
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 93: {
                return this._closeArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 125: {
                return this._closeObjectScope();
            }
        }
        return this._startUnexpectedValue(false, n);
    }

    private final JsonToken _startValueExpectComma(int n) throws IOException {
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 13;
            return this._currToken;
        }
        if (n != 44) {
            if (n == 93) {
                return this._closeArrayScope();
            }
            if (n == 125) {
                return this._closeObjectScope();
            }
            if (n == 47) {
                return this._startSlashComment(13);
            }
            if (n == 35) {
                return this._finishHashComment(13);
            }
            this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        this._parsingContext.expectComma();
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._minorState = 15;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n = this._inputBuffer[n2];
        this._inputPtr = n2 + 1;
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 15;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n == 34) {
            return this._startString();
        }
        switch (n) {
            case 35: {
                return this._finishHashComment(15);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(15);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 93: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) break;
                return this._closeArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 125: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) break;
                return this._closeObjectScope();
            }
        }
        return this._startUnexpectedValue(true, n);
    }

    private final JsonToken _startValueExpectColon(int n) throws IOException {
        int n2;
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 14;
            return this._currToken;
        }
        if (n != 58) {
            if (n == 47) {
                return this._startSlashComment(14);
            }
            if (n == 35) {
                return this._finishHashComment(14);
            }
            this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
        }
        if ((n2 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 12;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n = this._inputBuffer[n2];
        this._inputPtr = n2 + 1;
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 12;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n == 34) {
            return this._startString();
        }
        switch (n) {
            case 35: {
                return this._finishHashComment(12);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(12);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
        }
        return this._startUnexpectedValue(false, n);
    }

    private final JsonToken _startValueAfterComma(int n) throws IOException {
        if (n <= 32 && (n = this._skipWS(n)) <= 0) {
            this._minorState = 15;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n == 34) {
            return this._startString();
        }
        switch (n) {
            case 35: {
                return this._finishHashComment(15);
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 47: {
                return this._startSlashComment(15);
            }
            case 48: {
                return this._startNumberLeadingZero();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this._startPositiveNumber(n);
            }
            case 102: {
                return this._startFalseToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 93: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) break;
                return this._closeArrayScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 125: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) break;
                return this._closeObjectScope();
            }
        }
        return this._startUnexpectedValue(true, n);
    }

    protected JsonToken _startUnexpectedValue(boolean bl, int n) throws IOException {
        switch (n) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                    --this._inputPtr;
                    return this._valueComplete(JsonToken.VALUE_NULL);
                }
            }
            case 125: {
                break;
            }
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._startAposString();
            }
            case 43: {
                return this._finishNonStdToken(2, 1);
            }
            case 78: {
                return this._finishNonStdToken(0, 1);
            }
            case 73: {
                return this._finishNonStdToken(1, 1);
            }
        }
        this._reportUnexpectedChar(n, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    private final int _skipWS(int n) throws IOException {
        do {
            if (n != 32) {
                if (n == 10) {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                } else if (n == 13) {
                    ++this._currInputRowAlt;
                    this._currInputRowStart = this._inputPtr;
                } else if (n != 9) {
                    this._throwInvalidSpace(n);
                }
            }
            if (this._inputPtr < this._inputEnd) continue;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return 0;
        } while ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32);
        return n;
    }

    private final JsonToken _startSlashComment(int n) throws IOException {
        byte by;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd) {
            this._pending32 = n;
            this._minorState = 51;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        if ((by = this._inputBuffer[this._inputPtr++]) == 42) {
            return this._finishCComment(n, false);
        }
        if (by == 47) {
            return this._finishCppComment(n);
        }
        this._reportUnexpectedChar(by & 0xFF, "was expecting either '*' or '/' for a comment");
        return null;
    }

    private final JsonToken _finishHashComment(int n) throws IOException {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            this._reportUnexpectedChar(35, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_YAML_COMMENTS' not enabled for parser)");
        }
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 55;
                this._pending32 = n;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) >= 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n2 == 13) {
                ++this._currInputRowAlt;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._startAfterComment(n);
    }

    private final JsonToken _finishCppComment(int n) throws IOException {
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 54;
                this._pending32 = n;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) >= 32) continue;
            if (n2 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n2 == 13) {
                ++this._currInputRowAlt;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        return this._startAfterComment(n);
    }

    private final JsonToken _finishCComment(int n, boolean bl) throws IOException {
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = bl ? 52 : 53;
                this._pending32 = n;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 32) {
                if (n2 == 10) {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                } else if (n2 == 13) {
                    ++this._currInputRowAlt;
                    this._currInputRowStart = this._inputPtr;
                } else if (n2 != 9) {
                    this._throwInvalidSpace(n2);
                }
            } else {
                if (n2 == 42) {
                    bl = true;
                    continue;
                }
                if (n2 == 47 && bl) break;
            }
            bl = false;
        }
        return this._startAfterComment(n);
    }

    private final JsonToken _startAfterComment(int n) throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = n;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (n) {
            case 4: {
                return this._startFieldName(n2);
            }
            case 5: {
                return this._startFieldNameAfterComma(n2);
            }
            case 12: {
                return this._startValue(n2);
            }
            case 13: {
                return this._startValueExpectComma(n2);
            }
            case 14: {
                return this._startValueExpectColon(n2);
            }
            case 15: {
                return this._startValueAfterComma(n2);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    protected JsonToken _startFalseToken() throws IOException {
        int n;
        byte[] byArray;
        int n2 = this._inputPtr;
        if (n2 + 4 < this._inputEnd && (byArray = this._inputBuffer)[n2++] == 97 && byArray[n2++] == 108 && byArray[n2++] == 115 && byArray[n2++] == 101 && ((n = byArray[n2] & 0xFF) < 48 || n == 93 || n == 125)) {
            this._inputPtr = n2;
            return this._valueComplete(JsonToken.VALUE_FALSE);
        }
        this._minorState = 18;
        return this._finishKeywordToken("false", 1, JsonToken.VALUE_FALSE);
    }

    protected JsonToken _startTrueToken() throws IOException {
        int n;
        byte[] byArray;
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n2++] == 114 && byArray[n2++] == 117 && byArray[n2++] == 101 && ((n = byArray[n2] & 0xFF) < 48 || n == 93 || n == 125)) {
            this._inputPtr = n2;
            return this._valueComplete(JsonToken.VALUE_TRUE);
        }
        this._minorState = 17;
        return this._finishKeywordToken("true", 1, JsonToken.VALUE_TRUE);
    }

    protected JsonToken _startNullToken() throws IOException {
        int n;
        byte[] byArray;
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n2++] == 117 && byArray[n2++] == 108 && byArray[n2++] == 108 && ((n = byArray[n2] & 0xFF) < 48 || n == 93 || n == 125)) {
            this._inputPtr = n2;
            return this._valueComplete(JsonToken.VALUE_NULL);
        }
        this._minorState = 16;
        return this._finishKeywordToken("null", 1, JsonToken.VALUE_NULL);
    }

    protected JsonToken _finishKeywordToken(String string, int n, JsonToken jsonToken) throws IOException {
        int n2 = string.length();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._pending32 = n;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            byte by = this._inputBuffer[this._inputPtr];
            if (n == n2) {
                if (by >= 48 && by != 93 && by != 125) break;
                return this._valueComplete(jsonToken);
            }
            if (by != string.charAt(n)) break;
            ++n;
            ++this._inputPtr;
        }
        this._minorState = 50;
        this._textBuffer.resetWithCopy(string, 0, n);
        return this._finishErrorToken();
    }

    protected JsonToken _finishKeywordTokenWithEOF(String string, int n, JsonToken jsonToken) throws IOException {
        if (n == string.length()) {
            this._currToken = jsonToken;
            return this._currToken;
        }
        this._textBuffer.resetWithCopy(string, 0, n);
        return this._finishErrorTokenWithEOF();
    }

    protected JsonToken _finishNonStdToken(int n, int n2) throws IOException {
        String string = this._nonStdToken(n);
        int n3 = string.length();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._nonStdTokenType = n;
                this._pending32 = n2;
                this._minorState = 19;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            byte by = this._inputBuffer[this._inputPtr];
            if (n2 == n3) {
                if (by >= 48 && by != 93 && by != 125) break;
                return this._valueNonStdNumberComplete(n);
            }
            if (by != string.charAt(n2)) break;
            ++n2;
            ++this._inputPtr;
        }
        this._minorState = 50;
        this._textBuffer.resetWithCopy(string, 0, n2);
        return this._finishErrorToken();
    }

    protected JsonToken _finishNonStdTokenWithEOF(int n, int n2) throws IOException {
        String string = this._nonStdToken(n);
        if (n2 == string.length()) {
            return this._valueNonStdNumberComplete(n);
        }
        this._textBuffer.resetWithCopy(string, 0, n2);
        return this._finishErrorTokenWithEOF();
    }

    protected JsonToken _finishErrorToken() throws IOException {
        while (this._inputPtr < this._inputEnd) {
            byte by;
            char c;
            if (Character.isJavaIdentifierPart(c = (char)(by = this._inputBuffer[this._inputPtr++]))) {
                this._textBuffer.append(c);
                if (this._textBuffer.size() < 256) continue;
            }
            return this._reportErrorToken(this._textBuffer.contentsAsString());
        }
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    protected JsonToken _finishErrorTokenWithEOF() throws IOException {
        return this._reportErrorToken(this._textBuffer.contentsAsString());
    }

    protected JsonToken _reportErrorToken(String string) throws IOException {
        this._reportError("Unrecognized token '%s': was expecting %s", this._textBuffer.contentsAsString(), this._validJsonTokenList());
        return JsonToken.NOT_AVAILABLE;
    }

    protected JsonToken _startFloatThatStartsWithPeriod() throws IOException {
        this._numberNegative = false;
        this._intLength = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        return this._startFloat(cArray, 0, 46);
    }

    protected JsonToken _startPositiveNumber(int n) throws IOException {
        this._numberNegative = false;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = (char)n;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(1);
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n2 = 1;
        n = this._inputBuffer[this._inputPtr] & 0xFF;
        while (true) {
            if (n < 48) {
                if (n != 46) break;
                this._intLength = n2;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n);
            }
            if (n > 57) {
                if (n != 101 && n != 69) break;
                this._intLength = n2;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n);
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = (char)n;
            if (++this._inputPtr >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            n = this._inputBuffer[this._inputPtr] & 0xFF;
        }
        this._intLength = n2;
        this._textBuffer.setCurrentLength(n2);
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    protected JsonToken _startNegativeNumber() throws IOException {
        int n;
        this._numberNegative = true;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 23;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 48) {
            if (n == 48) {
                return this._finishNumberLeadingNegZeroes();
            }
            this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        } else if (n > 57) {
            if (n == 73) {
                return this._finishNonStdToken(3, 2);
            }
            this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = 45;
        cArray[1] = (char)n;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(2);
            this._intLength = 1;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        n = this._inputBuffer[this._inputPtr];
        int n2 = 2;
        while (true) {
            if (n < 48) {
                if (n != 46) break;
                this._intLength = n2 - 1;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n);
            }
            if (n > 57) {
                if (n != 101 && n != 69) break;
                this._intLength = n2 - 1;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n);
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = (char)n;
            if (++this._inputPtr >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            n = this._inputBuffer[this._inputPtr] & 0xFF;
        }
        this._intLength = n2 - 1;
        this._textBuffer.setCurrentLength(n2);
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    protected JsonToken _startNumberLeadingZero() throws IOException {
        int n;
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._minorState = 24;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        if ((n = this._inputBuffer[n2++] & 0xFF) < 48) {
            if (n == 46) {
                this._inputPtr = n2;
                this._intLength = 1;
                char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                cArray[0] = 48;
                return this._startFloat(cArray, 1, n);
            }
        } else if (n > 57) {
            if (n == 101 || n == 69) {
                this._inputPtr = n2;
                this._intLength = 1;
                char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                cArray[0] = 48;
                return this._startFloat(cArray, 1, n);
            }
            if (n != 93 && n != 125) {
                this.reportUnexpectedNumberChar(n, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
            }
        } else {
            return this._finishNumberLeadingZeroes();
        }
        return this._valueCompleteInt(0, "0");
    }

    protected JsonToken _finishNumberMinus(int n) throws IOException {
        if (n <= 48) {
            if (n == 48) {
                return this._finishNumberLeadingNegZeroes();
            }
            this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        } else if (n > 57) {
            if (n == 73) {
                return this._finishNonStdToken(3, 2);
            }
            this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        cArray[0] = 45;
        cArray[1] = (char)n;
        this._intLength = 1;
        return this._finishNumberIntegralPart(cArray, 2);
    }

    protected JsonToken _finishNumberLeadingZeroes() throws IOException {
        block7: {
            int n;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 24;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 48) {
                    if (n == 46) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 1, n);
                    }
                    break block7;
                }
                if (n > 57) {
                    if (n == 101 || n == 69) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 1, n);
                    }
                    if (n != 93 && n != 125) {
                        this.reportUnexpectedNumberChar(n, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                    }
                    break block7;
                }
                if ((this._features & FEAT_MASK_LEADING_ZEROS) != 0) continue;
                this.reportInvalidNumber("Leading zeroes not allowed");
            } while (n == 48);
            char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
            cArray[0] = (char)n;
            this._intLength = 1;
            return this._finishNumberIntegralPart(cArray, 1);
        }
        --this._inputPtr;
        return this._valueCompleteInt(0, "0");
    }

    protected JsonToken _finishNumberLeadingNegZeroes() throws IOException {
        block7: {
            int n;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 25;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 48) {
                    if (n == 46) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 45;
                        cArray[1] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 2, n);
                    }
                    break block7;
                }
                if (n > 57) {
                    if (n == 101 || n == 69) {
                        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                        cArray[0] = 45;
                        cArray[1] = 48;
                        this._intLength = 1;
                        return this._startFloat(cArray, 2, n);
                    }
                    if (n != 93 && n != 125) {
                        this.reportUnexpectedNumberChar(n, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                    }
                    break block7;
                }
                if ((this._features & FEAT_MASK_LEADING_ZEROS) != 0) continue;
                this.reportInvalidNumber("Leading zeroes not allowed");
            } while (n == 48);
            char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
            cArray[0] = 45;
            cArray[1] = (char)n;
            this._intLength = 1;
            return this._finishNumberIntegralPart(cArray, 2);
        }
        --this._inputPtr;
        return this._valueCompleteInt(0, "0");
    }

    protected JsonToken _finishNumberIntegralPart(char[] cArray, int n) throws IOException {
        int n2;
        int n3 = n2 = this._numberNegative ? -1 : 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n4 = this._inputBuffer[this._inputPtr] & 0xFF;
            if (n4 < 48) {
                if (n4 != 46) break;
                this._intLength = n + n2;
                ++this._inputPtr;
                return this._startFloat(cArray, n, n4);
            }
            if (n4 > 57) {
                if (n4 != 101 && n4 != 69) break;
                this._intLength = n + n2;
                ++this._inputPtr;
                return this._startFloat(cArray, n, n4);
            }
            ++this._inputPtr;
            if (n >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n++] = (char)n4;
        }
        this._intLength = n + n2;
        this._textBuffer.setCurrentLength(n);
        return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
    }

    protected JsonToken _startFloat(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 == 46) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n++] = 46;
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n);
                    this._minorState = 30;
                    this._fractLength = n3;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                if ((n2 = this._inputBuffer[this._inputPtr++]) < 48 || n2 > 57) {
                    n2 &= 0xFF;
                    if (n3 != 0) break;
                    this.reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
                    break;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n++] = (char)n2;
                ++n3;
            }
        }
        this._fractLength = n3;
        int n4 = 0;
        if (n2 == 101 || n2 == 69) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n++] = (char)n2;
            if (this._inputPtr >= this._inputEnd) {
                this._textBuffer.setCurrentLength(n);
                this._minorState = 31;
                this._expLength = 0;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 45 || n2 == 43) {
                if (n >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n);
                    this._minorState = 32;
                    this._expLength = 0;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                n2 = this._inputBuffer[this._inputPtr++];
            }
            while (n2 >= 48 && n2 <= 57) {
                ++n4;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n);
                    this._minorState = 32;
                    this._expLength = n4;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                n2 = this._inputBuffer[this._inputPtr++];
            }
            n2 &= 0xFF;
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n);
        this._expLength = n4;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected JsonToken _finishFloatFraction() throws IOException {
        byte by;
        int n = this._fractLength;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while ((by = this._inputBuffer[this._inputPtr++]) >= 48 && by <= 57) {
            ++n;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = (char)by;
            if (this._inputPtr < this._inputEnd) continue;
            this._textBuffer.setCurrentLength(n2);
            this._fractLength = n;
            return JsonToken.NOT_AVAILABLE;
        }
        if (n == 0) {
            this.reportUnexpectedNumberChar(by, "Decimal point not followed by a digit");
        }
        this._fractLength = n;
        this._textBuffer.setCurrentLength(n2);
        if (by == 101 || by == 69) {
            this._textBuffer.append((char)by);
            this._expLength = 0;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 31;
                return JsonToken.NOT_AVAILABLE;
            }
            this._minorState = 32;
            return this._finishFloatExponent(true, this._inputBuffer[this._inputPtr++] & 0xFF);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        this._expLength = 0;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected JsonToken _finishFloatExponent(boolean bl, int n) throws IOException {
        if (bl) {
            this._minorState = 32;
            if (n == 45 || n == 43) {
                this._textBuffer.append((char)n);
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 32;
                    this._expLength = 0;
                    return JsonToken.NOT_AVAILABLE;
                }
                n = this._inputBuffer[this._inputPtr++];
            }
        }
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int n3 = this._expLength;
        while (n >= 48 && n <= 57) {
            ++n3;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n2++] = (char)n;
            if (this._inputPtr >= this._inputEnd) {
                this._textBuffer.setCurrentLength(n2);
                this._expLength = n3;
                return JsonToken.NOT_AVAILABLE;
            }
            n = this._inputBuffer[this._inputPtr++];
        }
        n &= 0xFF;
        if (n3 == 0) {
            this.reportUnexpectedNumberChar(n, "Exponent indicator not followed by a digit");
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        this._expLength = n3;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    private final String _fastParseName() throws IOException {
        int n;
        byte[] byArray = this._inputBuffer;
        int[] nArray = _icLatin1;
        int n2 = this._inputPtr;
        if (nArray[n = byArray[n2++] & 0xFF] == 0) {
            int n3;
            if (nArray[n3 = byArray[n2++] & 0xFF] == 0) {
                int n4 = n << 8 | n3;
                if (nArray[n3 = byArray[n2++] & 0xFF] == 0) {
                    n4 = n4 << 8 | n3;
                    if (nArray[n3 = byArray[n2++] & 0xFF] == 0) {
                        n4 = n4 << 8 | n3;
                        if (nArray[n3 = byArray[n2++] & 0xFF] == 0) {
                            this._quad1 = n4;
                            return this._parseMediumName(n2, n3);
                        }
                        if (n3 == 34) {
                            this._inputPtr = n2;
                            return this._findName(n4, 4);
                        }
                        return null;
                    }
                    if (n3 == 34) {
                        this._inputPtr = n2;
                        return this._findName(n4, 3);
                    }
                    return null;
                }
                if (n3 == 34) {
                    this._inputPtr = n2;
                    return this._findName(n4, 2);
                }
                return null;
            }
            if (n3 == 34) {
                this._inputPtr = n2;
                return this._findName(n, 1);
            }
            return null;
        }
        if (n == 34) {
            this._inputPtr = n2;
            return "";
        }
        return null;
    }

    private final String _parseMediumName(int n, int n2) throws IOException {
        int n3;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[n++] & 0xFF] == 0) {
            n2 = n2 << 8 | n3;
            if (nArray[n3 = byArray[n++] & 0xFF] == 0) {
                n2 = n2 << 8 | n3;
                if (nArray[n3 = byArray[n++] & 0xFF] == 0) {
                    n2 = n2 << 8 | n3;
                    if (nArray[n3 = byArray[n++] & 0xFF] == 0) {
                        return this._parseMediumName2(n, n3, n2);
                    }
                    if (n3 == 34) {
                        this._inputPtr = n;
                        return this._findName(this._quad1, n2, 4);
                    }
                    return null;
                }
                if (n3 == 34) {
                    this._inputPtr = n;
                    return this._findName(this._quad1, n2, 3);
                }
                return null;
            }
            if (n3 == 34) {
                this._inputPtr = n;
                return this._findName(this._quad1, n2, 2);
            }
            return null;
        }
        if (n3 == 34) {
            this._inputPtr = n;
            return this._findName(this._quad1, n2, 1);
        }
        return null;
    }

    private final String _parseMediumName2(int n, int n2, int n3) throws IOException {
        int n4;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n4 = byArray[n++] & 0xFF] != 0) {
            if (n4 == 34) {
                this._inputPtr = n;
                return this._findName(this._quad1, n3, n2, 1);
            }
            return null;
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[n++] & 0xFF] != 0) {
            if (n4 == 34) {
                this._inputPtr = n;
                return this._findName(this._quad1, n3, n2, 2);
            }
            return null;
        }
        n2 = n2 << 8 | n4;
        if (nArray[n4 = byArray[n++] & 0xFF] != 0) {
            if (n4 == 34) {
                this._inputPtr = n;
                return this._findName(this._quad1, n3, n2, 3);
            }
            return null;
        }
        n2 = n2 << 8 | n4;
        if ((n4 = byArray[n++] & 0xFF) == 34) {
            this._inputPtr = n;
            return this._findName(this._quad1, n3, n2, 4);
        }
        return null;
    }

    private final JsonToken _parseEscapedName(int n, int n2, int n3) throws IOException {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = _icLatin1;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n;
                this._pending32 = n2;
                this._pendingBytes = n3;
                this._minorState = 7;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (nArray2[n4 = this._inputBuffer[this._inputPtr++] & 0xFF] == 0) {
                if (n3 < 4) {
                    ++n3;
                    n2 = n2 << 8 | n4;
                    continue;
                }
                if (n >= nArray.length) {
                    this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n++] = n2;
                n2 = n4;
                n3 = 1;
                continue;
            }
            if (n4 == 34) break;
            if (n4 != 92) {
                this._throwUnquotedSpace(n4, "name");
            } else {
                n4 = this._decodeCharEscape();
                if (n4 < 0) {
                    this._minorState = 8;
                    this._minorStateAfterSplit = 7;
                    this._quadLength = n;
                    this._pending32 = n2;
                    this._pendingBytes = n3;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
            }
            if (n >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            if (n4 > 127) {
                if (n3 >= 4) {
                    nArray[n++] = n2;
                    n2 = 0;
                    n3 = 0;
                }
                if (n4 < 2048) {
                    n2 = n2 << 8 | (0xC0 | n4 >> 6);
                    ++n3;
                } else {
                    n2 = n2 << 8 | (0xE0 | n4 >> 12);
                    if (++n3 >= 4) {
                        nArray[n++] = n2;
                        n2 = 0;
                        n3 = 0;
                    }
                    n2 = n2 << 8 | (0x80 | n4 >> 6 & 0x3F);
                    ++n3;
                }
                n4 = 0x80 | n4 & 0x3F;
            }
            if (n3 < 4) {
                ++n3;
                n2 = n2 << 8 | n4;
                continue;
            }
            nArray[n++] = n2;
            n2 = n4;
            n3 = 1;
        }
        if (n3 > 0) {
            if (n >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n++] = NonBlockingJsonParser._padLastQuad(n2, n3);
        } else if (n == 0) {
            return this._fieldComplete("");
        }
        String string = this._symbols.findName(nArray, n);
        if (string == null) {
            string = this._addName(nArray, n, n3);
        }
        return this._fieldComplete(string);
    }

    private JsonToken _handleOddName(int n) throws IOException {
        int[] nArray;
        switch (n) {
            case 35: {
                if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) break;
                return this._finishHashComment(4);
            }
            case 47: {
                return this._startSlashComment(4);
            }
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._finishAposName(0, 0, 0);
            }
            case 93: {
                return this._closeArrayScope();
            }
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            char c = (char)n;
            this._reportUnexpectedChar(c, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n] != 0) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        return this._finishUnquotedName(0, n, 1);
    }

    private JsonToken _finishUnquotedName(int n, int n2, int n3) throws IOException {
        String string;
        int[] nArray = this._quadBuffer;
        int[] nArray2 = CharTypes.getInputCodeUtf8JsNames();
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n;
                this._pending32 = n2;
                this._pendingBytes = n3;
                this._minorState = 10;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n4 = this._inputBuffer[this._inputPtr] & 0xFF;
            if (nArray2[n4] != 0) break;
            ++this._inputPtr;
            if (n3 < 4) {
                ++n3;
                n2 = n2 << 8 | n4;
                continue;
            }
            if (n >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n++] = n2;
            n2 = n4;
            n3 = 1;
        }
        if (n3 > 0) {
            if (n >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n++] = n2;
        }
        if ((string = this._symbols.findName(nArray, n)) == null) {
            string = this._addName(nArray, n, n3);
        }
        return this._fieldComplete(string);
    }

    private JsonToken _finishAposName(int n, int n2, int n3) throws IOException {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = _icLatin1;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n;
                this._pending32 = n2;
                this._pendingBytes = n3;
                this._minorState = 9;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) break;
            if (n4 != 34 && nArray2[n4] != 0) {
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeCharEscape();
                    if (n4 < 0) {
                        this._minorState = 8;
                        this._minorStateAfterSplit = 9;
                        this._quadLength = n;
                        this._pending32 = n2;
                        this._pendingBytes = n3;
                        this._currToken = JsonToken.NOT_AVAILABLE;
                        return this._currToken;
                    }
                }
                if (n4 > 127) {
                    if (n3 >= 4) {
                        if (n >= nArray.length) {
                            this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n++] = n2;
                        n2 = 0;
                        n3 = 0;
                    }
                    if (n4 < 2048) {
                        n2 = n2 << 8 | (0xC0 | n4 >> 6);
                        ++n3;
                    } else {
                        n2 = n2 << 8 | (0xE0 | n4 >> 12);
                        if (++n3 >= 4) {
                            if (n >= nArray.length) {
                                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n++] = n2;
                            n2 = 0;
                            n3 = 0;
                        }
                        n2 = n2 << 8 | (0x80 | n4 >> 6 & 0x3F);
                        ++n3;
                    }
                    n4 = 0x80 | n4 & 0x3F;
                }
            }
            if (n3 < 4) {
                ++n3;
                n2 = n2 << 8 | n4;
                continue;
            }
            if (n >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n++] = n2;
            n2 = n4;
            n3 = 1;
        }
        if (n3 > 0) {
            if (n >= nArray.length) {
                this._quadBuffer = nArray = NonBlockingJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n++] = NonBlockingJsonParser._padLastQuad(n2, n3);
        } else if (n == 0) {
            return this._fieldComplete("");
        }
        String string = this._symbols.findName(nArray, n);
        if (string == null) {
            string = this._addName(nArray, n, n3);
        }
        return this._fieldComplete(string);
    }

    protected final JsonToken _finishFieldWithEscape() throws IOException {
        int n = this._decodeSplitEscaped(this._quoted32, this._quotedDigits);
        if (n < 0) {
            this._minorState = 8;
            return JsonToken.NOT_AVAILABLE;
        }
        if (this._quadLength >= this._quadBuffer.length) {
            this._quadBuffer = NonBlockingJsonParser.growArrayBy(this._quadBuffer, 32);
        }
        int n2 = this._pending32;
        int n3 = this._pendingBytes;
        if (n > 127) {
            if (n3 >= 4) {
                this._quadBuffer[this._quadLength++] = n2;
                n2 = 0;
                n3 = 0;
            }
            if (n < 2048) {
                n2 = n2 << 8 | (0xC0 | n >> 6);
                ++n3;
            } else {
                n2 = n2 << 8 | (0xE0 | n >> 12);
                if (++n3 >= 4) {
                    this._quadBuffer[this._quadLength++] = n2;
                    n2 = 0;
                    n3 = 0;
                }
                n2 = n2 << 8 | (0x80 | n >> 6 & 0x3F);
                ++n3;
            }
            n = 0x80 | n & 0x3F;
        }
        if (n3 < 4) {
            ++n3;
            n2 = n2 << 8 | n;
        } else {
            this._quadBuffer[this._quadLength++] = n2;
            n2 = n;
            n3 = 1;
        }
        if (this._minorStateAfterSplit == 9) {
            return this._finishAposName(this._quadLength, n2, n3);
        }
        return this._parseEscapedName(this._quadLength, n2, n3);
    }

    private int _decodeSplitEscaped(int n, int n2) throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._quoted32 = n;
            this._quotedDigits = n2;
            return -1;
        }
        int n3 = this._inputBuffer[this._inputPtr++];
        if (n2 == -1) {
            switch (n3) {
                case 98: {
                    return 8;
                }
                case 116: {
                    return 9;
                }
                case 110: {
                    return 10;
                }
                case 102: {
                    return 12;
                }
                case 114: {
                    return 13;
                }
                case 34: 
                case 47: 
                case 92: {
                    return n3;
                }
                case 117: {
                    break;
                }
                default: {
                    char c = (char)n3;
                    return this._handleUnrecognizedCharacterEscape(c);
                }
            }
            if (this._inputPtr >= this._inputEnd) {
                this._quotedDigits = 0;
                this._quoted32 = 0;
                return -1;
            }
            n3 = this._inputBuffer[this._inputPtr++];
            n2 = 0;
        }
        n3 &= 0xFF;
        while (true) {
            int n4;
            if ((n4 = CharTypes.charToHex(n3)) < 0) {
                this._reportUnexpectedChar(n3 & 0xFF, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n4;
            if (++n2 == 4) {
                return n;
            }
            if (this._inputPtr >= this._inputEnd) {
                this._quotedDigits = n2;
                this._quoted32 = n;
                return -1;
            }
            n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
    }

    protected JsonToken _startString() throws IOException {
        int n;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = Math.min(this._inputEnd, n + cArray.length);
        byte[] byArray = this._inputBuffer;
        for (n = this._inputPtr; n < n3; ++n) {
            int n4 = byArray[n] & 0xFF;
            if (nArray[n4] != 0) {
                if (n4 != 34) break;
                this._inputPtr = n + 1;
                this._textBuffer.setCurrentLength(n2);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            cArray[n2++] = (char)n4;
        }
        this._textBuffer.setCurrentLength(n2);
        this._inputPtr = n;
        return this._finishRegularString();
    }

    private final JsonToken _finishRegularString() throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n = this._textBuffer.getCurrentSegmentSize();
        int n2 = this._inputPtr;
        int n3 = this._inputEnd - 5;
        block6: while (true) {
            int n4;
            if (n2 >= this._inputEnd) {
                this._inputPtr = n2;
                this._minorState = 40;
                this._textBuffer.setCurrentLength(n);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            int n5 = Math.min(this._inputEnd, n2 + (cArray.length - n));
            while (true) {
                if (n2 >= n5) continue block6;
                if (nArray[n4 = byArray[n2++] & 0xFF] != 0) break;
                cArray[n++] = (char)n4;
            }
            if (n4 == 34) {
                this._inputPtr = n2;
                this._textBuffer.setCurrentLength(n);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            if (n2 >= n3) {
                this._inputPtr = n2;
                this._textBuffer.setCurrentLength(n);
                if (!this._decodeSplitMultiByte(n4, nArray[n4], n2 < this._inputEnd)) {
                    this._minorStateAfterSplit = 40;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                cArray = this._textBuffer.getBufferWithoutReset();
                n = this._textBuffer.getCurrentSegmentSize();
                n2 = this._inputPtr;
                continue;
            }
            switch (nArray[n4]) {
                case 1: {
                    this._inputPtr = n2;
                    n4 = this._decodeFastCharEscape();
                    n2 = this._inputPtr;
                    break;
                }
                case 2: {
                    n4 = this._decodeUTF8_2(n4, this._inputBuffer[n2++]);
                    break;
                }
                case 3: {
                    n4 = this._decodeUTF8_3(n4, this._inputBuffer[n2++], this._inputBuffer[n2++]);
                    break;
                }
                case 4: {
                    n4 = this._decodeUTF8_4(n4, this._inputBuffer[n2++], this._inputBuffer[n2++], this._inputBuffer[n2++]);
                    cArray[n++] = (char)(0xD800 | n4 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n4 = 0xDC00 | n4 & 0x3FF;
                    break;
                }
                default: {
                    if (n4 < 32) {
                        this._throwUnquotedSpace(n4, "string value");
                        break;
                    }
                    this._reportInvalidChar(n4);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n4;
        }
    }

    protected JsonToken _startAposString() throws IOException {
        int n;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = Math.min(this._inputEnd, n + cArray.length);
        byte[] byArray = this._inputBuffer;
        for (n = this._inputPtr; n < n3; ++n) {
            int n4 = byArray[n] & 0xFF;
            if (n4 == 39) {
                this._inputPtr = n + 1;
                this._textBuffer.setCurrentLength(n2);
                return this._valueComplete(JsonToken.VALUE_STRING);
            }
            if (nArray[n4] != 0) break;
            cArray[n2++] = (char)n4;
        }
        this._textBuffer.setCurrentLength(n2);
        this._inputPtr = n;
        return this._finishAposString();
    }

    private final JsonToken _finishAposString() throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n = this._textBuffer.getCurrentSegmentSize();
        int n2 = this._inputPtr;
        int n3 = this._inputEnd - 5;
        block6: while (true) {
            int n4;
            if (n2 >= this._inputEnd) {
                this._inputPtr = n2;
                this._minorState = 45;
                this._textBuffer.setCurrentLength(n);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            int n5 = Math.min(this._inputEnd, n2 + (cArray.length - n));
            while (true) {
                if (n2 >= n5) continue block6;
                if (nArray[n4 = byArray[n2++] & 0xFF] != 0 && n4 != 34) break;
                if (n4 == 39) {
                    this._inputPtr = n2;
                    this._textBuffer.setCurrentLength(n);
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                cArray[n++] = (char)n4;
            }
            if (n2 >= n3) {
                this._inputPtr = n2;
                this._textBuffer.setCurrentLength(n);
                if (!this._decodeSplitMultiByte(n4, nArray[n4], n2 < this._inputEnd)) {
                    this._minorStateAfterSplit = 45;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                cArray = this._textBuffer.getBufferWithoutReset();
                n = this._textBuffer.getCurrentSegmentSize();
                n2 = this._inputPtr;
                continue;
            }
            switch (nArray[n4]) {
                case 1: {
                    this._inputPtr = n2;
                    n4 = this._decodeFastCharEscape();
                    n2 = this._inputPtr;
                    break;
                }
                case 2: {
                    n4 = this._decodeUTF8_2(n4, this._inputBuffer[n2++]);
                    break;
                }
                case 3: {
                    n4 = this._decodeUTF8_3(n4, this._inputBuffer[n2++], this._inputBuffer[n2++]);
                    break;
                }
                case 4: {
                    n4 = this._decodeUTF8_4(n4, this._inputBuffer[n2++], this._inputBuffer[n2++], this._inputBuffer[n2++]);
                    cArray[n++] = (char)(0xD800 | n4 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n4 = 0xDC00 | n4 & 0x3FF;
                    break;
                }
                default: {
                    if (n4 < 32) {
                        this._throwUnquotedSpace(n4, "string value");
                        break;
                    }
                    this._reportInvalidChar(n4);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n4;
        }
    }

    private final boolean _decodeSplitMultiByte(int n, int n2, boolean bl) throws IOException {
        switch (n2) {
            case 1: {
                n = this._decodeSplitEscaped(0, -1);
                if (n < 0) {
                    this._minorState = 41;
                    return false;
                }
                this._textBuffer.append((char)n);
                return true;
            }
            case 2: {
                if (bl) {
                    n = this._decodeUTF8_2(n, this._inputBuffer[this._inputPtr++]);
                    this._textBuffer.append((char)n);
                    return true;
                }
                this._minorState = 42;
                this._pending32 = n;
                return false;
            }
            case 3: {
                n &= 0xF;
                if (bl) {
                    return this._decodeSplitUTF8_3(n, 1, this._inputBuffer[this._inputPtr++]);
                }
                this._minorState = 43;
                this._pending32 = n;
                this._pendingBytes = 1;
                return false;
            }
            case 4: {
                n &= 7;
                if (bl) {
                    return this._decodeSplitUTF8_4(n, 1, this._inputBuffer[this._inputPtr++]);
                }
                this._pending32 = n;
                this._pendingBytes = 1;
                this._minorState = 44;
                return false;
            }
        }
        if (n < 32) {
            this._throwUnquotedSpace(n, "string value");
        } else {
            this._reportInvalidChar(n);
        }
        this._textBuffer.append((char)n);
        return true;
    }

    private final boolean _decodeSplitUTF8_3(int n, int n2, int n3) throws IOException {
        if (n2 == 1) {
            if ((n3 & 0xC0) != 128) {
                this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
            }
            n = n << 6 | n3 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 43;
                this._pending32 = n;
                this._pendingBytes = 2;
                return false;
            }
            n3 = this._inputBuffer[this._inputPtr++];
        }
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        this._textBuffer.append((char)(n << 6 | n3 & 0x3F));
        return true;
    }

    private final boolean _decodeSplitUTF8_4(int n, int n2, int n3) throws IOException {
        if (n2 == 1) {
            if ((n3 & 0xC0) != 128) {
                this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
            }
            n = n << 6 | n3 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 44;
                this._pending32 = n;
                this._pendingBytes = 2;
                return false;
            }
            n2 = 2;
            n3 = this._inputBuffer[this._inputPtr++];
        }
        if (n2 == 2) {
            if ((n3 & 0xC0) != 128) {
                this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
            }
            n = n << 6 | n3 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 44;
                this._pending32 = n;
                this._pendingBytes = 3;
                return false;
            }
            n3 = this._inputBuffer[this._inputPtr++];
        }
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        int n4 = (n << 6 | n3 & 0x3F) - 65536;
        this._textBuffer.append((char)(0xD800 | n4 >> 10));
        n4 = 0xDC00 | n4 & 0x3FF;
        this._textBuffer.append((char)n4);
        return true;
    }

    private final int _decodeCharEscape() throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 5) {
            return this._decodeSplitEscaped(0, -1);
        }
        return this._decodeFastCharEscape();
    }

    private final int _decodeFastCharEscape() throws IOException {
        int n;
        byte by = this._inputBuffer[this._inputPtr++];
        switch (by) {
            case 98: {
                return 8;
            }
            case 116: {
                return 9;
            }
            case 110: {
                return 10;
            }
            case 102: {
                return 12;
            }
            case 114: {
                return 13;
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by;
            }
            case 117: {
                break;
            }
            default: {
                char c = (char)by;
                return this._handleUnrecognizedCharacterEscape(c);
            }
        }
        byte by2 = this._inputBuffer[this._inputPtr++];
        int n2 = n = CharTypes.charToHex(by2);
        if (n >= 0 && (n = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) >= 0) {
            n2 = n2 << 4 | n;
            if ((n = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) >= 0) {
                n2 = n2 << 4 | n;
                if ((n = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) >= 0) {
                    return n2 << 4 | n;
                }
            }
        }
        this._reportUnexpectedChar(by2 & 0xFF, "expected a hex-digit for character escape sequence");
        return -1;
    }

    private final int _decodeUTF8_2(int n, int n2) throws IOException {
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | n2 & 0x3F;
    }

    private final int _decodeUTF8_3(int n, int n2, int n3) throws IOException {
        n &= 0xF;
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n = n << 6 | n2 & 0x3F;
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        return n << 6 | n3 & 0x3F;
    }

    private final int _decodeUTF8_4(int n, int n2, int n3, int n4) throws IOException {
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | n2 & 0x3F;
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF, this._inputPtr);
        }
        n = n << 6 | n3 & 0x3F;
        if ((n4 & 0xC0) != 128) {
            this._reportInvalidOther(n4 & 0xFF, this._inputPtr);
        }
        return (n << 6 | n4 & 0x3F) - 65536;
    }
}

