/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.util.Arrays;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars();
    private static final byte[] HB = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    static final int MIN_CHAR_BUFFER_SIZE = 16;
    static final int MAX_CHAR_BUFFER_SIZE = 32000;
    static final int MIN_BYTE_BUFFER_SIZE = 24;
    static final int MAX_BYTE_BUFFER_SIZE = 32000;
    private static final JsonStringEncoder instance = new JsonStringEncoder();

    public static JsonStringEncoder getInstance() {
        return instance;
    }

    public char[] quoteAsString(String string) {
        int n = string.length();
        char[] cArray = new char[JsonStringEncoder._initialCharBufSize(n)];
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        TextBuffer textBuffer = null;
        int n4 = 0;
        char[] cArray2 = null;
        block0: while (n3 < n) {
            int n5;
            int n6;
            char c;
            while ((c = string.charAt(n3)) >= n2 || nArray[c] == 0) {
                if (n4 >= cArray.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(cArray);
                    }
                    cArray = textBuffer.finishCurrentSegment();
                    n4 = 0;
                }
                cArray[n4++] = c;
                if (++n3 < n) continue;
                break block0;
            }
            if (cArray2 == null) {
                cArray2 = this._qbuf();
            }
            int n7 = n6 = (n5 = nArray[c = string.charAt(n3++)]) < 0 ? this._appendNumeric(c, cArray2) : this._appendNamed(n5, cArray2);
            if (n4 + n6 > cArray.length) {
                int n8 = cArray.length - n4;
                if (n8 > 0) {
                    System.arraycopy(cArray2, 0, cArray, n4, n8);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(cArray);
                }
                cArray = textBuffer.finishCurrentSegment();
                int n9 = n6 - n8;
                System.arraycopy(cArray2, n8, cArray, 0, n9);
                n4 = n9;
                continue;
            }
            System.arraycopy(cArray2, 0, cArray, n4, n6);
            n4 += n6;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(cArray, 0, n4);
        }
        textBuffer.setCurrentLength(n4);
        return textBuffer.contentsAsArray();
    }

    public char[] quoteAsString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return this.quoteAsString((String)charSequence);
        }
        TextBuffer textBuffer = null;
        int n = charSequence.length();
        char[] cArray = new char[JsonStringEncoder._initialCharBufSize(n)];
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        char[] cArray2 = null;
        block0: while (n3 < n) {
            int n5;
            int n6;
            char c;
            while ((c = charSequence.charAt(n3)) >= n2 || nArray[c] == 0) {
                if (n4 >= cArray.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(cArray);
                    }
                    cArray = textBuffer.finishCurrentSegment();
                    n4 = 0;
                }
                cArray[n4++] = c;
                if (++n3 < n) continue;
                break block0;
            }
            if (cArray2 == null) {
                cArray2 = this._qbuf();
            }
            int n7 = n6 = (n5 = nArray[c = charSequence.charAt(n3++)]) < 0 ? this._appendNumeric(c, cArray2) : this._appendNamed(n5, cArray2);
            if (n4 + n6 > cArray.length) {
                int n8 = cArray.length - n4;
                if (n8 > 0) {
                    System.arraycopy(cArray2, 0, cArray, n4, n8);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(cArray);
                }
                cArray = textBuffer.finishCurrentSegment();
                int n9 = n6 - n8;
                System.arraycopy(cArray2, n8, cArray, 0, n9);
                n4 = n9;
                continue;
            }
            System.arraycopy(cArray2, 0, cArray, n4, n6);
            n4 += n6;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(cArray, 0, n4);
        }
        textBuffer.setCurrentLength(n4);
        return textBuffer.contentsAsArray();
    }

    public void quoteAsString(CharSequence charSequence, StringBuilder stringBuilder) {
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n = nArray.length;
        int n2 = 0;
        int n3 = charSequence.length();
        char[] cArray = null;
        block0: while (n2 < n3) {
            int n4;
            char c;
            while ((c = charSequence.charAt(n2)) >= n || nArray[c] == 0) {
                stringBuilder.append(c);
                if (++n2 < n3) continue;
                break block0;
            }
            if (cArray == null) {
                cArray = this._qbuf();
            }
            int n5 = (n4 = nArray[c = charSequence.charAt(n2++)]) < 0 ? this._appendNumeric(c, cArray) : this._appendNamed(n4, cArray);
            stringBuilder.append(cArray, 0, n5);
        }
    }

    public byte[] quoteAsUTF8(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        byte[] byArray = new byte[JsonStringEncoder._initialByteBufSize(n2)];
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n < n2) {
            int n4;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while ((n4 = string.charAt(n)) <= 127 && nArray[n4] == 0) {
                if (n3 >= byArray.length) {
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n3);
                    }
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)n4;
                if (++n < n2) continue;
                break block0;
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n3);
            }
            if (n3 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
            }
            if ((n4 = string.charAt(n++)) <= 127) {
                int n5 = nArray[n4];
                n3 = this._appendByte(n4, n5, byteArrayBuilder, n3);
                byArray = byteArrayBuilder.getCurrentSegment();
                continue;
            }
            if (n4 <= 2047) {
                byArray[n3++] = (byte)(0xC0 | n4 >> 6);
                n4 = 0x80 | n4 & 0x3F;
            } else if (n4 < 55296 || n4 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n4 >> 12);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                n4 = 0x80 | n4 & 0x3F;
            } else {
                if (n4 > 56319) {
                    JsonStringEncoder._illegal(n4);
                }
                if (n >= n2) {
                    JsonStringEncoder._illegal(n4);
                }
                if ((n4 = JsonStringEncoder._convert(n4, string.charAt(n++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n4);
                }
                byArray[n3++] = (byte)(0xF0 | n4 >> 18);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                n4 = 0x80 | n4 & 0x3F;
            }
            if (n3 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
            }
            byArray[n3++] = (byte)n4;
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n3);
        }
        return byteArrayBuilder.completeAndCoalesce(n3);
    }

    public byte[] encodeAsUTF8(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        byte[] byArray = new byte[JsonStringEncoder._initialByteBufSize(n2)];
        int n4 = byArray.length;
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n < n2) {
            int n5 = string.charAt(n++);
            while (n5 <= 127) {
                if (n3 >= n4) {
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n3);
                    }
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)n5;
                if (n >= n2) break block0;
                n5 = string.charAt(n++);
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n3);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            if (n5 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n5 >> 12);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            } else {
                if (n5 > 56319) {
                    JsonStringEncoder._illegal(n5);
                }
                if (n >= n2) {
                    JsonStringEncoder._illegal(n5);
                }
                if ((n5 = JsonStringEncoder._convert(n5, string.charAt(n++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n5);
                }
                byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n3);
        }
        return byteArrayBuilder.completeAndCoalesce(n3);
    }

    public byte[] encodeAsUTF8(CharSequence charSequence) {
        int n = 0;
        int n2 = charSequence.length();
        int n3 = 0;
        byte[] byArray = new byte[JsonStringEncoder._initialByteBufSize(n2)];
        int n4 = byArray.length;
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n < n2) {
            int n5 = charSequence.charAt(n++);
            while (n5 <= 127) {
                if (n3 >= n4) {
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n3);
                    }
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)n5;
                if (n >= n2) break block0;
                n5 = charSequence.charAt(n++);
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n3);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            if (n5 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n5 >> 12);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            } else {
                if (n5 > 56319) {
                    JsonStringEncoder._illegal(n5);
                }
                if (n >= n2) {
                    JsonStringEncoder._illegal(n5);
                }
                if ((n5 = JsonStringEncoder._convert(n5, charSequence.charAt(n++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(n5);
                }
                byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n3);
        }
        return byteArrayBuilder.completeAndCoalesce(n3);
    }

    private char[] _qbuf() {
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[2] = 48;
        cArray[3] = 48;
        return cArray;
    }

    private int _appendNumeric(int n, char[] cArray) {
        cArray[1] = 117;
        cArray[4] = HC[n >> 4];
        cArray[5] = HC[n & 0xF];
        return 6;
    }

    private int _appendNamed(int n, char[] cArray) {
        cArray[1] = (char)n;
        return 2;
    }

    private int _appendByte(int n, int n2, ByteArrayBuilder byteArrayBuilder, int n3) {
        byteArrayBuilder.setCurrentSegmentLength(n3);
        byteArrayBuilder.append(92);
        if (n2 < 0) {
            byteArrayBuilder.append(117);
            if (n > 255) {
                int n4 = n >> 8;
                byteArrayBuilder.append(HB[n4 >> 4]);
                byteArrayBuilder.append(HB[n4 & 0xF]);
                n &= 0xFF;
            } else {
                byteArrayBuilder.append(48);
                byteArrayBuilder.append(48);
            }
            byteArrayBuilder.append(HB[n >> 4]);
            byteArrayBuilder.append(HB[n & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n2);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private static int _convert(int n, int n2) {
        if (n2 < 56320 || n2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n - 55296 << 10) + (n2 - 56320);
    }

    private static void _illegal(int n) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(n));
    }

    static int _initialCharBufSize(int n) {
        int n2 = Math.max(16, n + Math.min(6 + (n >> 3), 1000));
        return Math.min(n2, 32000);
    }

    static int _initialByteBufSize(int n) {
        int n2 = Math.max(24, n + 6 + (n >> 1));
        return Math.min(n2, 32000);
    }
}

