/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import java.math.BigDecimal;
import java.util.Arrays;

public final class BigDecimalParser {
    private static final int MAX_CHARS_TO_REPORT = 1000;
    private final char[] chars;

    BigDecimalParser(char[] cArray) {
        this.chars = cArray;
    }

    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    public static BigDecimal parse(char[] cArray, int n, int n2) {
        if (n > 0 || n2 != cArray.length) {
            cArray = Arrays.copyOfRange(cArray, n, n + n2);
        }
        return BigDecimalParser.parse(cArray);
    }

    public static BigDecimal parse(char[] cArray) {
        int n = cArray.length;
        try {
            if (n < 500) {
                return new BigDecimal(cArray);
            }
            return new BigDecimalParser(cArray).parseBigDecimal(n / 10);
        }
        catch (NumberFormatException numberFormatException) {
            String string = numberFormatException.getMessage();
            if (string == null) {
                string = "Not a valid number representation";
            }
            String string2 = cArray.length <= 1000 ? new String(cArray) : new String(Arrays.copyOfRange(cArray, 0, 1000)) + "(truncated, full length is " + cArray.length + " chars)";
            throw new NumberFormatException("Value \"" + string2 + "\" can not be represented as `java.math.BigDecimal`, reason: " + string);
        }
    }

    private BigDecimal parseBigDecimal(int n) {
        Object object;
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = this.chars.length;
        block6: for (n3 = 0; n3 < n8; ++n3) {
            n2 = this.chars[n3];
            switch (n2) {
                case 43: {
                    if (n5 >= 0) {
                        if (bl2) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl2 = true;
                        continue block6;
                    }
                    if (bl) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl = true;
                    n4 = n3 + 1;
                    continue block6;
                }
                case 45: {
                    if (n5 >= 0) {
                        if (bl2) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        bl2 = true;
                        continue block6;
                    }
                    if (bl) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl = true;
                    bl3 = true;
                    n4 = n3 + 1;
                    continue block6;
                }
                case 69: 
                case 101: {
                    if (n5 >= 0) {
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    n5 = n3;
                    continue block6;
                }
                case 46: {
                    if (n6 >= 0) {
                        throw new NumberFormatException("Multiple decimal points");
                    }
                    n6 = n3;
                    continue block6;
                }
                default: {
                    if (n6 < 0 || n5 != -1) continue block6;
                    ++n7;
                }
            }
        }
        n2 = 0;
        if (n5 >= 0) {
            n3 = n5;
            object = new String(this.chars, n5 + 1, n8 - n5 - 1);
            n2 = Integer.parseInt((String)object);
            n7 = this.adjustScale(n7, n2);
        } else {
            n3 = n8;
        }
        if (n6 >= 0) {
            int n9 = n6 - n4;
            BigDecimal bigDecimal = this.toBigDecimalRec(n4, n9, n2, n);
            int n10 = n3 - n6 - 1;
            BigDecimal bigDecimal2 = this.toBigDecimalRec(n6 + 1, n10, n2 - n10, n);
            object = bigDecimal.add(bigDecimal2);
        } else {
            object = this.toBigDecimalRec(n4, n3 - n4, n2, n);
        }
        if (n7 != 0) {
            object = ((BigDecimal)object).setScale(n7);
        }
        if (bl3) {
            object = ((BigDecimal)object).negate();
        }
        return object;
    }

    private int adjustScale(int n, long l) {
        long l2 = (long)n - l;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range: " + l2 + " while adjusting scale " + n + " to exponent " + l);
        }
        return (int)l2;
    }

    private BigDecimal toBigDecimalRec(int n, int n2, int n3, int n4) {
        if (n2 > n4) {
            int n5 = n2 / 2;
            BigDecimal bigDecimal = this.toBigDecimalRec(n, n5, n3 + n2 - n5, n4);
            BigDecimal bigDecimal2 = this.toBigDecimalRec(n + n5, n2 - n5, n3, n4);
            return bigDecimal.add(bigDecimal2);
        }
        return n2 == 0 ? BigDecimal.ZERO : new BigDecimal(this.chars, n, n2).movePointRight(n3);
    }
}

