/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.util.TimingInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
class TimingInfoFullSupport
extends TimingInfo {
    private final Map<String, List<TimingInfo>> subMeasurementsByName = new HashMap<String, List<TimingInfo>>();
    private final Map<String, Number> countersByName = new HashMap<String, Number>();

    TimingInfoFullSupport(Long l, long l2, Long l3) {
        super(l, l2, l3);
    }

    @Override
    public void addSubMeasurement(String string, TimingInfo timingInfo) {
        List<TimingInfo> list = this.subMeasurementsByName.get(string);
        if (list == null) {
            list = new ArrayList<TimingInfo>();
            this.subMeasurementsByName.put(string, list);
        }
        if (timingInfo.isEndTimeKnown()) {
            list.add(timingInfo);
        } else {
            LogFactory.getLog(this.getClass()).debug("Skip submeasurement timing info with no end time for " + string);
        }
    }

    @Override
    public TimingInfo getSubMeasurement(String string) {
        return this.getSubMeasurement(string, 0);
    }

    @Override
    public TimingInfo getSubMeasurement(String string, int n) {
        List<TimingInfo> list = this.subMeasurementsByName.get(string);
        if (n < 0 || list == null || list.size() == 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    @Override
    public TimingInfo getLastSubMeasurement(String string) {
        if (this.subMeasurementsByName == null || this.subMeasurementsByName.size() == 0) {
            return null;
        }
        List<TimingInfo> list = this.subMeasurementsByName.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public List<TimingInfo> getAllSubMeasurements(String string) {
        return this.subMeasurementsByName.get(string);
    }

    @Override
    public Map<String, List<TimingInfo>> getSubMeasurementsByName() {
        return this.subMeasurementsByName;
    }

    @Override
    public Number getCounter(String string) {
        return this.countersByName.get(string);
    }

    @Override
    public Map<String, Number> getAllCounters() {
        return this.countersByName;
    }

    @Override
    public void setCounter(String string, long l) {
        this.countersByName.put(string, l);
    }

    @Override
    public void incrementCounter(String string) {
        int n = 0;
        Number number = this.getCounter(string);
        if (number != null) {
            n = number.intValue();
        }
        this.setCounter(string, ++n);
    }
}

