/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Date;
import java.util.Locale;

public class StringUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String COMMA_SEPARATOR = ",";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Locale LOCALE_ENGLISH = Locale.ENGLISH;
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_NEW_LINE = '\n';
    private static final char CHAR_VERTICAL_TAB = '\u000b';
    private static final char CHAR_CARRIAGE_RETURN = '\r';
    private static final char CHAR_FORM_FEED = '\f';

    public static Integer toInteger(StringBuilder stringBuilder) {
        return Integer.parseInt(stringBuilder.toString());
    }

    public static String toString(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }

    public static Boolean toBoolean(StringBuilder stringBuilder) {
        return Boolean.valueOf(stringBuilder.toString());
    }

    public static String fromInteger(Integer n) {
        return Integer.toString(n);
    }

    public static String fromLong(Long l) {
        return Long.toString(l);
    }

    public static String fromShort(Short s2) {
        return Short.toString(s2);
    }

    public static String fromString(String string) {
        return string;
    }

    public static String fromBoolean(Boolean bl) {
        return Boolean.toString(bl);
    }

    public static String fromBigInteger(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    public static String fromBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static BigInteger toBigInteger(String string) {
        return new BigInteger(string);
    }

    public static BigDecimal toBigDecimal(String string) {
        return new BigDecimal(string);
    }

    public static String fromFloat(Float f) {
        return Float.toString(f.floatValue());
    }

    public static String fromDate(Date date) {
        return DateUtils.formatISO8601Date(date);
    }

    public static String fromDate(Date date, String string) {
        if ("unixTimestamp".equalsIgnoreCase(string)) {
            return DateUtils.formatServiceSpecificDate(date);
        }
        if ("iso8601".equalsIgnoreCase(string)) {
            return DateUtils.formatISO8601Date(date);
        }
        if ("rfc822".equalsIgnoreCase(string)) {
            return DateUtils.formatRFC822Date(date);
        }
        if ("unixTimestampInMillis".equalsIgnoreCase(string)) {
            return DateUtils.formatUnixTimestampInMills(date);
        }
        throw new IllegalArgumentException("unsupported timestamp format");
    }

    public static String fromDouble(Double d) {
        return Double.toString(d);
    }

    public static String fromByte(Byte by) {
        return Byte.toString(by);
    }

    public static String fromByteBuffer(ByteBuffer byteBuffer) {
        return Base64.encodeAsString(BinaryUtils.copyBytesFrom(byteBuffer));
    }

    public static String replace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string);
        int n = stringBuilder.indexOf(string2);
        while (n != -1) {
            stringBuilder = stringBuilder.replace(n, n + string2.length(), string3);
            n = stringBuilder.indexOf(string2, n + string3.length());
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean hasValue(String string) {
        return !StringUtils.isNullOrEmpty(string);
    }

    public static String lowerCase(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return string;
        }
        return string.toLowerCase(LOCALE_ENGLISH);
    }

    public static String upperCase(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return string;
        }
        return string.toUpperCase(LOCALE_ENGLISH);
    }

    public static int compare(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        Collator collator = Collator.getInstance(LOCALE_ENGLISH);
        return collator.compare(string, string2);
    }

    private static boolean isWhiteSpace(char c) {
        if (c == ' ') {
            return true;
        }
        if (c == '\t') {
            return true;
        }
        if (c == '\n') {
            return true;
        }
        if (c == '\u000b') {
            return true;
        }
        if (c == '\r') {
            return true;
        }
        return c == '\f';
    }

    public static void appendCompactedString(StringBuilder stringBuilder, String string) {
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (StringUtils.isWhiteSpace(c)) {
                if (bl) continue;
                stringBuilder.append(' ');
                bl = true;
                continue;
            }
            stringBuilder.append(c);
            bl = false;
        }
    }

    public static boolean beginsWithIgnoreCase(String string, String string2) {
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static Character findFirstOccurrence(String string, char ... cArray) {
        int n = Integer.MAX_VALUE;
        for (char c : cArray) {
            int n2 = string.indexOf(c);
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        return n == Integer.MAX_VALUE ? null : Character.valueOf(string.charAt(n));
    }
}

