/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImmutableMapParameter<K, V>
implements Map<K, V> {
    private static final String UNMODIFIABLE_MESSAGE = "This is an immutable map.";
    private static final String DUPLICATED_KEY_MESSAGE = "Duplicate keys are provided.";
    private final Map<K, V> map;

    private ImmutableMapParameter(Map<K, V> map) {
        this.map = map;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableMapParameter<K, V> of(K k, V v) {
        Map<K, V> map = Collections.singletonMap(k, v);
        return new ImmutableMapParameter<K, V>(map);
    }

    public static <K, V> ImmutableMapParameter<K, V> of(K k, V v, K k2, V v2) {
        HashMap hashMap = new HashMap();
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k, v);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k2, v2);
        return new ImmutableMapParameter(hashMap);
    }

    public static <K, V> ImmutableMapParameter<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        HashMap hashMap = new HashMap();
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k, v);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k2, v2);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k3, v3);
        return new ImmutableMapParameter(hashMap);
    }

    public static <K, V> ImmutableMapParameter<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        HashMap hashMap = new HashMap();
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k, v);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k2, v2);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k3, v3);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k4, v4);
        return new ImmutableMapParameter(hashMap);
    }

    public static <K, V> ImmutableMapParameter<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        HashMap hashMap = new HashMap();
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k, v);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k2, v2);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k3, v3);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k4, v4);
        ImmutableMapParameter.putAndWarnDuplicateKeys(hashMap, k5, v5);
        return new ImmutableMapParameter(hashMap);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public V put(K k, V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    private static <K, V> void putAndWarnDuplicateKeys(Map<K, V> map, K k, V v) {
        if (map.containsKey(k)) {
            throw new IllegalArgumentException(DUPLICATED_KEY_MESSAGE);
        }
        map.put(k, v);
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public static class Builder<K, V> {
        private final Map<K, V> entries = new HashMap();

        public Builder<K, V> put(K k, V v) {
            ImmutableMapParameter.putAndWarnDuplicateKeys(this.entries, k, v);
            return this;
        }

        public ImmutableMapParameter<K, V> build() {
            HashMap<K, V> hashMap = new HashMap<K, V>();
            hashMap.putAll(this.entries);
            return new ImmutableMapParameter(hashMap);
        }
    }
}

