/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.Releasable;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum IOUtils {

    private static final int BUFFER_SIZE = 4096;
    private static final Log defaultLog = LogFactory.getLog(IOUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream inputStream2) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream2.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public static String toString(InputStream inputStream2) throws IOException {
        return new String(IOUtils.toByteArray(inputStream2), StringUtils.UTF8);
    }

    public static void closeQuietly(Closeable closeable, Log log) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    Log log2;
                    Log log3 = log2 = log == null ? defaultLog : log;
                    if (!log2.isDebugEnabled()) break block3;
                    log2.debug("Ignore failure in closing the Closeable", iOException);
                }
            }
        }
    }

    public static void release(Closeable closeable, Log log) {
        IOUtils.closeQuietly(closeable, log);
        if (closeable instanceof Releasable) {
            Releasable releasable = (Releasable)((Object)closeable);
            releasable.release();
        }
    }

    public static long copy(InputStream inputStream2, OutputStream outputStream2) throws IOException {
        return IOUtils.copy(inputStream2, outputStream2, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream2, OutputStream outputStream2, long l) throws IOException {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        int n = 0;
        while ((n = inputStream2.read(byArray)) > -1) {
            outputStream2.write(byArray, 0, n);
            if ((l2 += (long)n) < l) continue;
            throw new IOException("Read limit exceeded: " + l);
        }
        return l2;
    }

    public static void drainInputStream(InputStream inputStream2) {
        try {
            while (inputStream2.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

