/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SdkProtectedApi
public final class HostnameValidator {
    private static final Pattern HOSTNAME_COMPLIANT_PATTERN = Pattern.compile("[A-Za-z0-9\\-]+");
    private static final int HOSTNAME_MAX_LENGTH = 63;

    private HostnameValidator() {
    }

    public static void validateHostnameCompliant(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string)) {
            throw new IllegalArgumentException(String.format("The provided %s is not valid: the required '%s' component is missing.", string3, string2));
        }
        if (string.length() > 63) {
            throw new IllegalArgumentException(String.format("The provided %s is not valid: the '%s' component exceeds the maximum length of %d characters.", string3, string2, 63));
        }
        Matcher matcher = HOSTNAME_COMPLIANT_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("The provided %s is not valid: the '%s' component must only contain alphanumeric characters and dashes.", string3, string2));
        }
    }
}

