/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base16Lower;
import com.amazonaws.util.Base64;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BinaryUtils {
    public static String toHex(byte[] byArray) {
        return Base16Lower.encodeAsString(byArray);
    }

    public static byte[] fromHex(String string) {
        return Base16Lower.decode(string);
    }

    public static String toBase64(byte[] byArray) {
        return Base64.encodeAsString(byArray);
    }

    public static byte[] fromBase64(String string) {
        return string == null ? null : Base64.decode(string);
    }

    public static ByteArrayInputStream toStream(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(BinaryUtils.copyBytesFrom(byteBuffer));
    }

    public static byte[] copyAllBytesFrom(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray()) {
            return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byteBuffer2.rewind();
        byte[] byArray = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray);
        return byArray;
    }

    public static byte[] copyBytesFrom(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray()) {
            return Arrays.copyOfRange(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.asReadOnlyBuffer().get(byArray);
        return byArray;
    }
}

