/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Codec;
import com.amazonaws.util.CodecUtils;

class Base16Codec
implements Codec {
    private static final int OFFSET_OF_a = 87;
    private static final int OFFSET_OF_A = 55;
    private static final int MASK_4BITS = 15;
    private final byte[] alphabets;

    Base16Codec() {
        this(true);
    }

    Base16Codec(boolean bl) {
        this.alphabets = bl ? CodecUtils.toBytesDirect("0123456789ABCDEF") : CodecUtils.toBytesDirect("0123456789abcdef");
    }

    @Override
    public byte[] encode(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = n++;
            byte by = byArray[i];
            byArray2[n2] = this.alphabets[by >>> 4 & 0xF];
            byArray2[n++] = this.alphabets[by & 0xF];
        }
        return byArray2;
    }

    @Override
    public byte[] decode(byte[] byArray, int n) {
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Input is expected to be encoded in multiple of 2 bytes but found: " + n);
        }
        byte[] byArray2 = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(this.pos(byArray[n2++]) << 4 | this.pos(byArray[n2++]));
        }
        return byArray2;
    }

    protected int pos(byte by) {
        byte by2 = LazyHolder.DECODED[by];
        if (by2 > -1) {
            return by2;
        }
        throw new IllegalArgumentException("Invalid base 16 character: '" + (char)by + "'");
    }

    private static class LazyHolder {
        private static final byte[] DECODED = LazyHolder.decodeTable();

        private LazyHolder() {
        }

        private static byte[] decodeTable() {
            byte[] byArray = new byte[103];
            for (int i = 0; i <= 102; ++i) {
                byArray[i] = i >= 48 && i <= 57 ? (int)(i - 48) : (i >= 65 && i <= 70 ? (int)(i - 55) : (i >= 97 && i <= 102 ? (int)(i - 87) : -1));
            }
            return byArray;
        }
    }
}

