/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.TimestampFormat;
import com.fasterxml.jackson.core.JsonToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;

public class SimpleTypeJsonUnmarshallers {

    public static class ShortJsonUnmarshaller
    implements Unmarshaller<Short, JsonUnmarshallerContext> {
        private static final ShortJsonUnmarshaller instance = new ShortJsonUnmarshaller();

        @Override
        public Short unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Short.valueOf(string);
        }

        public static ShortJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class CharacterJsonUnmarshaller
    implements Unmarshaller<Character, JsonUnmarshallerContext> {
        private static final CharacterJsonUnmarshaller instance = new CharacterJsonUnmarshaller();

        @Override
        public Character unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).isEmpty() || string.length() > 1) {
                throw new SdkClientException("'" + string + "' cannot be converted to Character");
            }
            return Character.valueOf(string.charAt(0));
        }

        public static CharacterJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class ByteBufferJsonUnmarshaller
    implements Unmarshaller<ByteBuffer, JsonUnmarshallerContext> {
        private static final ByteBufferJsonUnmarshaller instance = new ByteBufferJsonUnmarshaller();

        @Override
        public ByteBuffer unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            byte[] byArray = Base64.decode(string);
            return ByteBuffer.wrap(byArray);
        }

        public static ByteBufferJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DateJsonUnmarshallerFactory
    implements Unmarshaller<Date, JsonUnmarshallerContext> {
        private final String dateFormatType;

        private DateJsonUnmarshallerFactory(String string) {
            this.dateFormatType = string;
        }

        @Override
        public Date unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            try {
                if (TimestampFormat.RFC_822.getFormat().equals(this.dateFormatType)) {
                    return DateUtils.parseRFC822Date(string);
                }
                if (TimestampFormat.UNIX_TIMESTAMP.getFormat().equals(this.dateFormatType)) {
                    return DateUtils.parseServiceSpecificDate(string);
                }
                if (TimestampFormat.UNIX_TIMESTAMP_IN_MILLIS.getFormat().equals(this.dateFormatType)) {
                    return DateUtils.parseUnixTimestampInMillis(string);
                }
                return DateUtils.parseISO8601Date(string);
            }
            catch (Exception exception) {
                return DateJsonUnmarshaller.getInstance().unmarshall(jsonUnmarshallerContext);
            }
        }

        public static DateJsonUnmarshallerFactory getInstance(String string) {
            return new DateJsonUnmarshallerFactory(string);
        }
    }

    public static class DateJsonUnmarshaller
    implements Unmarshaller<Date, JsonUnmarshallerContext> {
        private static final DateJsonUnmarshaller instance = new DateJsonUnmarshaller();

        @Override
        public Date unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            if (jsonUnmarshallerContext.getCurrentToken() == JsonToken.VALUE_STRING) {
                return DateUtils.parseISO8601Date(jsonUnmarshallerContext.readText());
            }
            return DateUtils.parseServiceSpecificDate(jsonUnmarshallerContext.readText());
        }

        public static DateJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class ByteJsonUnmarshaller
    implements Unmarshaller<Byte, JsonUnmarshallerContext> {
        private static final ByteJsonUnmarshaller instance = new ByteJsonUnmarshaller();

        @Override
        public Byte unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Byte.valueOf(string);
        }

        public static ByteJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class LongJsonUnmarshaller
    implements Unmarshaller<Long, JsonUnmarshallerContext> {
        private static final LongJsonUnmarshaller instance = new LongJsonUnmarshaller();

        @Override
        public Long unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Long.valueOf(Long.parseLong(string));
        }

        public static LongJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class FloatJsonUnmarshaller
    implements Unmarshaller<Float, JsonUnmarshallerContext> {
        private static final FloatJsonUnmarshaller instance = new FloatJsonUnmarshaller();

        @Override
        public Float unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Float.valueOf(string);
        }

        public static FloatJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BooleanJsonUnmarshaller
    implements Unmarshaller<Boolean, JsonUnmarshallerContext> {
        private static final BooleanJsonUnmarshaller instance = new BooleanJsonUnmarshaller();

        @Override
        public Boolean unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Boolean.valueOf(Boolean.parseBoolean(string));
        }

        public static BooleanJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BigDecimalJsonUnmarshaller
    implements Unmarshaller<BigDecimal, JsonUnmarshallerContext> {
        private static final BigDecimalJsonUnmarshaller instance = new BigDecimalJsonUnmarshaller();

        @Override
        public BigDecimal unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : new BigDecimal(string);
        }

        public static BigDecimalJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BigIntegerJsonUnmarshaller
    implements Unmarshaller<BigInteger, JsonUnmarshallerContext> {
        private static final BigIntegerJsonUnmarshaller instance = new BigIntegerJsonUnmarshaller();

        @Override
        public BigInteger unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : new BigInteger(string);
        }

        public static BigIntegerJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class IntegerJsonUnmarshaller
    implements Unmarshaller<Integer, JsonUnmarshallerContext> {
        private static final IntegerJsonUnmarshaller instance = new IntegerJsonUnmarshaller();

        @Override
        public Integer unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Integer.valueOf(Integer.parseInt(string));
        }

        public static IntegerJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DoubleJsonUnmarshaller
    implements Unmarshaller<Double, JsonUnmarshallerContext> {
        private static final DoubleJsonUnmarshaller instance = new DoubleJsonUnmarshaller();

        @Override
        public Double unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = jsonUnmarshallerContext.readText();
            return string == null ? null : Double.valueOf(Double.parseDouble(string));
        }

        public static DoubleJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class JsonValueStringUnmarshaller
    extends StringJsonUnmarshaller {
        private static final JsonValueStringUnmarshaller INSTANCE = new JsonValueStringUnmarshaller();

        @Override
        public String unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            String string = super.unmarshall(jsonUnmarshallerContext);
            return !jsonUnmarshallerContext.isInsideResponseHeader() ? string : new String(Base64.decode(string), Charset.forName("utf-8"));
        }

        public static JsonValueStringUnmarshaller getInstance() {
            return INSTANCE;
        }
    }

    public static class StringJsonUnmarshaller
    implements Unmarshaller<String, JsonUnmarshallerContext> {
        private static final StringJsonUnmarshaller instance = new StringJsonUnmarshaller();

        @Override
        public String unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
            return jsonUnmarshallerContext.readText();
        }

        public static StringJsonUnmarshaller getInstance() {
            return instance;
        }
    }
}

