/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal.future;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CompositeFuture<T>
implements Future<List<T>> {
    private final List<? extends Future<T>> futures;

    public CompositeFuture(List<? extends Future<T>> list) {
        this.futures = list;
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = false;
        for (Future<T> future : this.futures) {
            bl2 |= future.cancel(bl);
        }
        return bl2;
    }

    @Override
    public boolean isCancelled() {
        for (Future<T> future : this.futures) {
            if (future.isCancelled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDone() {
        for (Future<T> future : this.futures) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<T> get() throws InterruptedException, ExecutionException {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Future<T> future : this.futures) {
            arrayList.add(future.get());
        }
        return arrayList;
    }

    @Override
    public List<T> get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = System.nanoTime() + timeUnit.toNanos(l);
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Future<T> future : this.futures) {
            long l3 = l2 - System.nanoTime();
            arrayList.add(future.get(l3, TimeUnit.NANOSECONDS));
        }
        return arrayList;
    }
}

