/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ReleasableInputStream;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import java.io.File;

public class UploadPartRequestFactory {
    private final String bucketName;
    private final String key;
    private final String uploadId;
    private final long optimalPartSize;
    private final File file;
    private final PutObjectRequest origReq;
    private int partNumber = 1;
    private long offset = 0L;
    private long remainingBytes;
    private SSECustomerKey sseCustomerKey;
    private final int totalNumberOfParts;
    private ReleasableInputStream wrappedStream;

    public UploadPartRequestFactory(PutObjectRequest putObjectRequest, String string, long l) {
        this.origReq = putObjectRequest;
        this.uploadId = string;
        this.optimalPartSize = l;
        this.bucketName = putObjectRequest.getBucketName();
        this.key = putObjectRequest.getKey();
        this.file = TransferManagerUtils.getRequestFile(putObjectRequest);
        this.remainingBytes = TransferManagerUtils.getContentLength(putObjectRequest);
        this.sseCustomerKey = putObjectRequest.getSSECustomerKey();
        this.totalNumberOfParts = (int)Math.ceil((double)this.remainingBytes / (double)this.optimalPartSize);
        if (putObjectRequest.getInputStream() != null) {
            this.wrappedStream = ReleasableInputStream.wrap(putObjectRequest.getInputStream());
        }
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized UploadPartRequest getNextUploadPartRequest() {
        long l = Math.min(this.optimalPartSize, this.remainingBytes);
        boolean bl = this.remainingBytes - l <= 0L;
        UploadPartRequest uploadPartRequest = null;
        uploadPartRequest = this.wrappedStream != null ? new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withInputStream(new InputSubstream(this.wrappedStream, 0L, l, bl)).withPartNumber(this.partNumber++).withPartSize(l) : new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withFile(this.file).withFileOffset(this.offset).withPartNumber(this.partNumber++).withPartSize(l);
        ObjectMetadata objectMetadata = this.origReq.getMetadata();
        if (objectMetadata != null && objectMetadata.getRawMetadataValue("x-amz-server-side-encryption-customer-key") != null && objectMetadata.getSSECustomerAlgorithm() != null && objectMetadata.getSSECustomerKeyMd5() != null) {
            ObjectMetadata objectMetadata2 = new ObjectMetadata();
            objectMetadata2.setHeader("x-amz-server-side-encryption-customer-key", objectMetadata.getRawMetadataValue("x-amz-server-side-encryption-customer-key"));
            objectMetadata2.setSSECustomerAlgorithm(objectMetadata.getSSECustomerAlgorithm());
            objectMetadata2.setSSECustomerKeyMd5(objectMetadata.getSSECustomerKeyMd5());
            uploadPartRequest.withObjectMetadata(objectMetadata2);
        }
        uploadPartRequest.withRequesterPays(this.origReq.isRequesterPays());
        TransferManager.appendMultipartUserAgent(uploadPartRequest);
        if (this.sseCustomerKey != null) {
            uploadPartRequest.setSSECustomerKey(this.sseCustomerKey);
        }
        this.offset += l;
        this.remainingBytes -= l;
        uploadPartRequest.setLastPart(bl);
        ((AmazonWebServiceRequest)uploadPartRequest.withGeneralProgressListener(this.origReq.getGeneralProgressListener())).withRequestMetricCollector(this.origReq.getRequestMetricCollector());
        uploadPartRequest.getRequestClientOptions().setReadLimit(this.origReq.getReadLimit());
        uploadPartRequest.withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
        return uploadPartRequest;
    }

    public int getTotalNumberOfParts() {
        return this.totalNumberOfParts;
    }
}

