/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.PauseResult;
import com.amazonaws.services.s3.transfer.PauseStatus;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.CompleteMultipartUpload;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.services.s3.transfer.internal.UploadCallable;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.internal.future.CompletedFuture;
import com.amazonaws.services.s3.transfer.internal.future.DelegatingFuture;
import com.amazonaws.services.s3.transfer.internal.future.FailedFuture;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class UploadMonitor
implements TransferMonitor,
Callable<Void> {
    private final AmazonS3 s3;
    private final PutObjectRequest origReq;
    private final ProgressListenerChain listener;
    private final UploadCallable multipartUploadCallable;
    private final UploadImpl transfer;
    private final ExecutorService threadPool;
    private final DelegatingFuture<UploadResult> resultFuture = new DelegatingFuture();
    private final DelegatingFuture<Void> initiateUploadFuture = new DelegatingFuture();

    public Future<UploadResult> getFuture() {
        return this.resultFuture;
    }

    @Override
    public synchronized boolean isDone() {
        return this.resultFuture.isDone();
    }

    public static UploadMonitor create(TransferManager transferManager, UploadImpl uploadImpl, ExecutorService executorService, UploadCallable uploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        UploadMonitor uploadMonitor = new UploadMonitor(transferManager, uploadImpl, executorService, uploadCallable, putObjectRequest, progressListenerChain);
        uploadMonitor.initiateUploadFuture.setDelegate(executorService.submit(uploadMonitor));
        return uploadMonitor;
    }

    private UploadMonitor(TransferManager transferManager, UploadImpl uploadImpl, ExecutorService executorService, UploadCallable uploadCallable, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.multipartUploadCallable = uploadCallable;
        this.origReq = putObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = uploadImpl;
        this.threadPool = executorService;
    }

    @Override
    public Void call() {
        try {
            UploadResult uploadResult = this.multipartUploadCallable.call();
            if (uploadResult == null) {
                CompleteMultipartUpload completeMultipartUpload = new CompleteMultipartUpload(this.multipartUploadCallable.getMultipartUploadId(), this.s3, this.origReq, this.multipartUploadCallable.getFutures(), this.multipartUploadCallable.getETags(), this.listener, this);
                this.resultFuture.setDelegate(this.threadPool.submit(completeMultipartUpload));
            } else {
                this.setTransferStateToCompleted();
                this.resultFuture.setDelegate(new CompletedFuture<UploadResult>(uploadResult));
            }
        }
        catch (CancellationException cancellationException) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            SdkClientException sdkClientException = new SdkClientException("Upload canceled");
            this.resultFuture.setDelegate(new FailedFuture(sdkClientException));
        }
        catch (Throwable throwable) {
            this.transfer.setState(Transfer.TransferState.Failed);
            this.resultFuture.setDelegate(new FailedFuture(throwable));
        }
        return null;
    }

    void setTransferStateToCompleted() {
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartUploadCallable.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    void setTransferStateToFailed() {
        this.transfer.setState(Transfer.TransferState.Failed);
    }

    PauseResult<PersistableUpload> pause(boolean bl) {
        PersistableUpload persistableUpload = this.multipartUploadCallable.getPersistableUpload();
        if (persistableUpload == null) {
            PauseStatus pauseStatus = TransferManagerUtils.determinePauseStatus(this.transfer.getState(), bl);
            if (bl) {
                this.cancelTransferFutures();
                this.multipartUploadCallable.safelyAbortMultipartUpload(this.initiateUploadFuture);
            }
            return new PauseResult<PersistableUpload>(pauseStatus);
        }
        this.initiateUploadFuture.cancel(true);
        this.cancelTransferFutures();
        return new PauseResult<PersistableUpload>(PauseStatus.SUCCESS, persistableUpload);
    }

    private void cancelTransferFutures() {
        this.resultFuture.cancel(true);
        this.multipartUploadCallable.getFutures().cancel(true);
    }

    void performAbort() {
        this.cancelTransferFutures();
        this.multipartUploadCallable.safelyAbortMultipartUpload(this.initiateUploadFuture);
        SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
    }
}

