/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Encryption;
import com.amazonaws.services.s3.AmazonS3EncryptionV2;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.EncryptedPutObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.S3ProgressPublisher;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.internal.UploadPartCallable;
import com.amazonaws.services.s3.transfer.internal.UploadPartRequestFactory;
import com.amazonaws.services.s3.transfer.internal.future.CompletedFuture;
import com.amazonaws.services.s3.transfer.internal.future.CompositeFuture;
import com.amazonaws.services.s3.transfer.internal.future.DelegatingFuture;
import com.amazonaws.services.s3.transfer.internal.future.FutureImpl;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadCallable
implements Callable<UploadResult> {
    private static final Log log = LogFactory.getLog(UploadCallable.class);
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest origReq;
    private final FutureImpl<String> multipartUploadId = new FutureImpl();
    private final UploadImpl upload;
    private final TransferManagerConfiguration configuration;
    private final DelegatingFuture<List<PartETag>> partsFuture = new DelegatingFuture();
    private final ProgressListenerChain listener;
    private final TransferProgress transferProgress;
    private final List<PartETag> eTagsToSkip = new ArrayList<PartETag>();
    private final int MULTIPART_UPLOAD_ID_RETRIEVAL_TIMEOUT_SECONDS = 30;
    private PersistableUpload persistableUpload;
    private final AtomicReference<State> state = new AtomicReference<State>(State.BEFORE_INITIATE);
    private final AtomicBoolean abortRequestSent = new AtomicBoolean(false);

    public UploadCallable(TransferManager transferManager, ExecutorService executorService, UploadImpl uploadImpl, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain, String string, TransferProgress transferProgress) {
        this.s3 = transferManager.getAmazonS3Client();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = executorService;
        this.origReq = putObjectRequest;
        this.listener = progressListenerChain;
        this.upload = uploadImpl;
        this.transferProgress = transferProgress;
        if (string != null) {
            this.multipartUploadId.complete(string);
        }
    }

    Future<List<PartETag>> getFutures() {
        return this.partsFuture;
    }

    List<PartETag> getETags() {
        return this.eTagsToSkip;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId.getOrThrowUnchecked("Failed to retrieve multipart upload ID.");
    }

    public boolean isMultipartUpload() {
        return TransferManagerUtils.shouldUseMultipartUpload(this.origReq, this.configuration);
    }

    @Override
    public UploadResult call() throws Exception {
        try {
            this.upload.setState(Transfer.TransferState.InProgress);
            if (this.isMultipartUpload()) {
                SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_STARTED_EVENT);
                UploadResult uploadResult = this.uploadInParts();
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadInOneChunk();
            return uploadResult;
        }
        finally {
            this.partsFuture.setDelegateIfUnset(new CompletedFuture(Collections.emptyList()));
            this.multipartUploadId.complete(null);
        }
    }

    private UploadResult uploadInOneChunk() {
        this.multipartUploadId.complete(null);
        PutObjectResult putObjectResult = this.s3.putObject(this.origReq);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.origReq.getBucketName());
        uploadResult.setKey(this.origReq.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        return uploadResult;
    }

    private void captureUploadStateIfPossible(String string) {
        if (this.origReq.getSSECustomerKey() == null) {
            this.persistableUpload = new PersistableUpload(this.origReq.getBucketName(), this.origReq.getKey(), this.origReq.getFile().getAbsolutePath(), string, this.configuration.getMinimumUploadPartSize(), this.configuration.getMultipartUploadThreshold());
            this.notifyPersistableTransferAvailability();
        }
    }

    public PersistableUpload getPersistableUpload() {
        return this.persistableUpload;
    }

    private void notifyPersistableTransferAvailability() {
        S3ProgressPublisher.publishTransferPersistable(this.listener, this.persistableUpload);
    }

    private UploadResult uploadInParts() throws Exception {
        boolean bl = this.s3 instanceof AmazonS3Encryption || this.s3 instanceof AmazonS3EncryptionV2;
        long l = this.getOptimalPartSize(bl);
        try {
            String string = this.multipartUploadId.isDone() ? this.multipartUploadId.get() : this.initiateMultipartUpload(this.origReq, bl);
            UploadPartRequestFactory uploadPartRequestFactory = new UploadPartRequestFactory(this.origReq, string, l);
            if (TransferManagerUtils.isUploadParallelizable(this.origReq, bl)) {
                this.captureUploadStateIfPossible(string);
                this.uploadPartsInParallel(uploadPartRequestFactory, string);
                UploadResult uploadResult = null;
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadPartsInSeries(uploadPartRequestFactory, string);
            return uploadResult;
        }
        catch (Exception exception) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            if (this.multipartUploadId.isDone()) {
                this.abortMultipartUpload(this.multipartUploadId.get());
            }
            throw exception;
        }
        finally {
            if (this.origReq.getInputStream() != null) {
                try {
                    this.origReq.getInputStream().close();
                }
                catch (Exception exception) {
                    log.warn("Unable to cleanly close input stream: " + exception.getMessage(), exception);
                }
            }
        }
    }

    void safelyAbortMultipartUpload(Future<?> future) {
        if (this.multipartUploadId.isDone()) {
            this.state.set(State.ABORTED);
            this.abortMultipartUpload(this.getUploadIdOrTimeout());
        } else if (!this.state.compareAndSet(State.BEFORE_INITIATE, State.ABORTED) && this.state.compareAndSet(State.INITIATED, State.ABORTED)) {
            this.abortMultipartUpload(this.getUploadIdOrTimeout());
        }
        future.cancel(true);
    }

    private String getUploadIdOrTimeout() {
        try {
            return this.multipartUploadId.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to retrieve an upload ID after 30 seconds.");
        }
    }

    private void abortMultipartUpload(String string) {
        if (string == null) {
            return;
        }
        if (!this.abortRequestSent.compareAndSet(false, true)) {
            return;
        }
        try {
            AbortMultipartUploadRequest abortMultipartUploadRequest = (AbortMultipartUploadRequest)new AbortMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), string).withRequesterPays(this.origReq.isRequesterPays()).withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
            this.s3.abortMultipartUpload(abortMultipartUploadRequest);
        }
        catch (Exception exception) {
            log.info("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + exception.getMessage(), exception);
        }
    }

    private long getOptimalPartSize(boolean bl) {
        long l = TransferManagerUtils.calculateOptimalPartSize(this.origReq, this.configuration);
        if (bl && l % 32L > 0L) {
            l = l - l % 32L + 32L;
        }
        log.debug("Calculated optimal part size: " + l);
        return l;
    }

    private UploadResult uploadPartsInSeries(UploadPartRequestFactory uploadPartRequestFactory, String string) {
        Object object;
        AmazonWebServiceRequest amazonWebServiceRequest;
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        while (uploadPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            amazonWebServiceRequest = uploadPartRequestFactory.getNextUploadPartRequest();
            object = amazonWebServiceRequest.getInputStream();
            if (object != null && ((InputStream)object).markSupported()) {
                if (amazonWebServiceRequest.getPartSize() >= Integer.MAX_VALUE) {
                    ((InputStream)object).mark(Integer.MAX_VALUE);
                } else {
                    ((InputStream)object).mark((int)amazonWebServiceRequest.getPartSize());
                }
            }
            arrayList.add(this.s3.uploadPart((UploadPartRequest)amazonWebServiceRequest).getPartETag());
        }
        amazonWebServiceRequest = (CompleteMultipartUploadRequest)((AmazonWebServiceRequest)((AmazonWebServiceRequest)new CompleteMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), string, arrayList).withRequesterPays(this.origReq.isRequesterPays()).withGeneralProgressListener(this.origReq.getGeneralProgressListener())).withRequestMetricCollector(this.origReq.getRequestMetricCollector())).withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
        object = this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)amazonWebServiceRequest);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(((CompleteMultipartUploadResult)object).getBucketName());
        uploadResult.setKey(((CompleteMultipartUploadResult)object).getKey());
        uploadResult.setETag(((CompleteMultipartUploadResult)object).getETag());
        uploadResult.setVersionId(((CompleteMultipartUploadResult)object).getVersionId());
        return uploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadPartsInParallel(UploadPartRequestFactory uploadPartRequestFactory, String string) {
        Map<Integer, PartSummary> map = this.identifyExistingPartsForResume(string);
        ArrayList<Future<PartETag>> arrayList = new ArrayList<Future<PartETag>>();
        try {
            while (uploadPartRequestFactory.hasMoreRequests()) {
                if (this.threadPool.isShutdown()) {
                    throw new CancellationException("TransferManager has been shutdown");
                }
                UploadPartRequest uploadPartRequest = uploadPartRequestFactory.getNextUploadPartRequest();
                if (map.containsKey(uploadPartRequest.getPartNumber())) {
                    PartSummary partSummary = map.get(uploadPartRequest.getPartNumber());
                    this.eTagsToSkip.add(new PartETag(uploadPartRequest.getPartNumber(), partSummary.getETag()));
                    this.transferProgress.updateProgress(partSummary.getSize());
                    continue;
                }
                arrayList.add(this.threadPool.submit(new UploadPartCallable(this.s3, uploadPartRequest, this.shouldCalculatePartMd5())));
            }
        }
        finally {
            this.partsFuture.setDelegate(new CompositeFuture(arrayList));
        }
    }

    private Map<Integer, PartSummary> identifyExistingPartsForResume(String string) {
        HashMap<Integer, PartSummary> hashMap = new HashMap<Integer, PartSummary>();
        if (string == null) {
            return hashMap;
        }
        int n = 0;
        while (true) {
            ListPartsRequest listPartsRequest = (ListPartsRequest)new ListPartsRequest(this.origReq.getBucketName(), this.origReq.getKey(), string).withPartNumberMarker(n).withRequesterPays(this.origReq.isRequesterPays()).withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
            PartListing partListing = this.s3.listParts(listPartsRequest);
            for (PartSummary partSummary : partListing.getParts()) {
                hashMap.put(partSummary.getPartNumber(), partSummary);
            }
            if (!partListing.isTruncated()) {
                return hashMap;
            }
            n = partListing.getNextPartNumberMarker();
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest, boolean bl) {
        String string;
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = null;
        if (bl && putObjectRequest instanceof EncryptedPutObjectRequest) {
            initiateMultipartUploadRequest = new EncryptedInitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
            ((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).setMaterialsDescription(((EncryptedPutObjectRequest)putObjectRequest).getMaterialsDescription());
        } else {
            initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        }
        initiateMultipartUploadRequest.withTagging(putObjectRequest.getTagging());
        TransferManager.appendMultipartUserAgent(initiateMultipartUploadRequest);
        ((AmazonWebServiceRequest)initiateMultipartUploadRequest.withAccessControlList(putObjectRequest.getAccessControlList()).withRequesterPays(putObjectRequest.isRequesterPays()).withStorageClass(putObjectRequest.getStorageClass()).withRedirectLocation(putObjectRequest.getRedirectLocation()).withSSECustomerKey(putObjectRequest.getSSECustomerKey()).withSSEAwsKeyManagementParams(putObjectRequest.getSSEAwsKeyManagementParams()).withGeneralProgressListener(putObjectRequest.getGeneralProgressListener())).withRequestMetricCollector(putObjectRequest.getRequestMetricCollector());
        initiateMultipartUploadRequest.withObjectLockMode(putObjectRequest.getObjectLockMode()).withObjectLockRetainUntilDate(putObjectRequest.getObjectLockRetainUntilDate()).withObjectLockLegalHoldStatus(putObjectRequest.getObjectLockLegalHoldStatus());
        initiateMultipartUploadRequest.withRequestCredentialsProvider(putObjectRequest.getRequestCredentialsProvider());
        if (!this.state.compareAndSet(State.BEFORE_INITIATE, State.INITIATED)) {
            throw new IllegalStateException("Failed to update state to " + (Object)((Object)State.INITIATED) + " (State: " + (Object)((Object)this.state.get()) + ")");
        }
        try {
            string = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
            this.multipartUploadId.complete(string);
        }
        catch (RuntimeException runtimeException) {
            this.multipartUploadId.complete(null);
            throw runtimeException;
        }
        catch (Error error) {
            this.multipartUploadId.complete(null);
            throw error;
        }
        log.debug("Initiated new multipart upload: " + string);
        return string;
    }

    private boolean shouldCalculatePartMd5() {
        return this.origReq.getObjectLockMode() != null || this.origReq.getObjectLockRetainUntilDate() != null || this.origReq.getObjectLockLegalHoldStatus() != null || this.configuration.isAlwaysCalculateMultipartMd5();
    }

    private static enum State {
        BEFORE_INITIATE,
        INITIATED,
        ABORTED;

    }
}

