/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.FileLocks;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.exception.FileLockException;
import com.amazonaws.services.s3.transfer.internal.AbstractDownloadCallable;
import com.amazonaws.services.s3.transfer.internal.DownloadMonitor;
import com.amazonaws.services.s3.transfer.internal.DownloadS3ObjectCallable;
import com.amazonaws.services.s3.transfer.internal.PresignedUrlDownloadImpl;
import com.amazonaws.services.s3.transfer.internal.PresignedUrlRetryableDownloadTaskImpl;
import java.io.File;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLProtocolException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class PresignUrlDownloadCallable
extends AbstractDownloadCallable {
    private static final Log LOG = LogFactory.getLog(PresignUrlDownloadCallable.class);
    private final AmazonS3 s3;
    private final PresignedUrlDownloadRequest request;
    private final PresignedUrlDownloadImpl download;
    private final long perRequestDownloadSize;
    private final Long startByte;
    private final Long endByte;
    private final boolean resumeOnRetry;
    private long expectedFileLength;
    private static boolean testing;

    public PresignUrlDownloadCallable(ExecutorService executorService, File file, CountDownLatch countDownLatch, PresignedUrlDownloadImpl presignedUrlDownloadImpl, boolean bl, ScheduledExecutorService scheduledExecutorService, long l, AmazonS3 amazonS3, PresignedUrlDownloadRequest presignedUrlDownloadRequest, long l2, Long l3, Long l4, boolean bl2) {
        super(PresignUrlDownloadCallable.constructCallableConfig(executorService, file, countDownLatch, presignedUrlDownloadImpl, bl, scheduledExecutorService, l));
        if (amazonS3 == null || presignedUrlDownloadRequest == null || presignedUrlDownloadImpl == null) {
            throw new IllegalArgumentException();
        }
        this.s3 = amazonS3;
        this.request = presignedUrlDownloadRequest;
        this.download = presignedUrlDownloadImpl;
        this.perRequestDownloadSize = l2;
        this.startByte = l3;
        this.endByte = l4;
        this.resumeOnRetry = bl2;
        this.expectedFileLength = 0L;
    }

    @Override
    protected void downloadAsSingleObject() {
        S3Object s3Object = this.retryableDownloadS3ObjectToFile(this.dstfile, new PresignedUrlRetryableDownloadTaskImpl(this.s3, this.download, this.request));
        this.updateDownloadStatus(s3Object);
    }

    @Override
    protected void downloadInParallel() throws Exception {
        this.downloadInParallelUsingRange();
    }

    @Override
    protected void setState(Transfer.TransferState transferState) {
        this.download.setState(transferState);
    }

    private void updateDownloadStatus(S3Object s3Object) {
        if (s3Object == null) {
            this.download.setState(Transfer.TransferState.Canceled);
            this.download.setMonitor(new DownloadMonitor(this.download, null));
        } else {
            this.download.setState(Transfer.TransferState.Completed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object retryableDownloadS3ObjectToFile(File file, ServiceUtils.RetryableS3DownloadTask retryableS3DownloadTask) {
        boolean bl = false;
        while (true) {
            S3Object s3Object;
            boolean bl2;
            boolean bl3 = bl2 = this.resumeOnRetry && this.canResumeDownload() && bl;
            if (bl2) {
                this.adjustRequest(this.request);
            }
            if ((s3Object = retryableS3DownloadTask.getS3ObjectStream()) == null) {
                return null;
            }
            try {
                if (testing && !bl) {
                    throw new SdkClientException("testing");
                }
                ServiceUtils.downloadToFile(s3Object, file, retryableS3DownloadTask.needIntegrityCheck(), bl2, this.expectedFileLength);
                S3Object s3Object2 = s3Object;
                return s3Object2;
            }
            catch (AmazonClientException amazonClientException) {
                if (!amazonClientException.isRetryable()) {
                    throw amazonClientException;
                }
                Throwable throwable = amazonClientException.getCause();
                if (throwable instanceof SocketException && !throwable.getMessage().equals("Connection reset") || throwable instanceof SSLProtocolException) {
                    throw amazonClientException;
                }
                if (bl) {
                    throw amazonClientException;
                }
                LOG.debug("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")", amazonClientException);
                bl = true;
                continue;
            }
            finally {
                s3Object.getObjectContent().abort();
                continue;
            }
            break;
        }
    }

    private boolean canResumeDownload() {
        return this.startByte != null && this.endByte != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRequest(PresignedUrlDownloadRequest presignedUrlDownloadRequest) {
        long l = -1L;
        long l2 = -1L;
        if (presignedUrlDownloadRequest.getRange() != null) {
            long[] lArray = presignedUrlDownloadRequest.getRange();
            l = lArray[0];
            l2 = lArray[1];
        } else {
            l = this.startByte;
            l2 = this.endByte;
        }
        if (this.dstfile.exists()) {
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile + " for range adjustment");
            }
            try {
                this.expectedFileLength = this.dstfile.length();
                long l3 = l + this.expectedFileLength;
                LOG.debug("Adjusting request range from " + Arrays.toString(new long[]{l, l2}) + " to " + Arrays.toString(new long[]{l3, l2}) + " for file " + this.dstfile);
                presignedUrlDownloadRequest.setRange(l3, l2);
                long l4 = l2 - l3 + 1L;
                if (l4 < 0L) {
                    throw new IllegalArgumentException("Unable to determine the range for download operation. lastByte=" + l2 + ", StartingByte=" + l3 + ", expectedFileLength=" + this.expectedFileLength + ", totalBytesToDownload=" + l4);
                }
            }
            finally {
                FileLocks.unlock(this.dstfile);
            }
        }
    }

    private void downloadInParallelUsingRange() throws Exception {
        Object object;
        ServiceUtils.createParentDirectoryIfNecessary(this.dstfile);
        if (!FileLocks.lock(this.dstfile)) {
            throw new FileLockException("Fail to lock " + this.dstfile);
        }
        long l = this.startByte;
        long l2 = 0L;
        long l3 = 0L;
        while (l <= this.endByte) {
            l2 = l + this.perRequestDownloadSize - 1L;
            if (l2 > this.endByte) {
                l2 = this.endByte;
            }
            object = this.request.clone();
            ((PresignedUrlDownloadRequest)object).setRange(l, l2);
            Callable<S3Object> callable = this.serviceCall((PresignedUrlDownloadRequest)object);
            this.futures.add(this.executor.submit(new DownloadS3ObjectCallable(callable, this.dstfile, l3)));
            l3 += this.perRequestDownloadSize;
            l = l2 + 1L;
        }
        object = this.executor.submit(this.completeAllFutures());
        ((DownloadMonitor)this.download.getMonitor()).setFuture((Future<File>)object);
    }

    private Callable<S3Object> serviceCall(final PresignedUrlDownloadRequest presignedUrlDownloadRequest) {
        return new Callable<S3Object>(){

            @Override
            public S3Object call() throws Exception {
                return PresignUrlDownloadCallable.this.s3.download(presignedUrlDownloadRequest).getS3Object();
            }
        };
    }

    private Callable<File> completeAllFutures() {
        return new Callable<File>(){

            @Override
            public File call() throws Exception {
                try {
                    for (Future future : PresignUrlDownloadCallable.this.futures) {
                        future.get();
                    }
                    PresignUrlDownloadCallable.this.download.setState(Transfer.TransferState.Completed);
                }
                finally {
                    FileLocks.unlock(PresignUrlDownloadCallable.this.dstfile);
                }
                return PresignUrlDownloadCallable.this.dstfile;
            }
        };
    }

    @SdkTestInternalApi
    public static void setTesting(boolean bl) {
        testing = bl;
    }
}

