/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MultipleFileTransferMonitor
implements TransferMonitor {
    private final Collection<? extends AbstractTransfer> subTransfers;
    private final AbstractTransfer transfer;
    private final Future<?> future;

    public MultipleFileTransferMonitor(AbstractTransfer abstractTransfer, Collection<? extends AbstractTransfer> collection) {
        this.subTransfers = collection;
        this.transfer = abstractTransfer;
        this.future = new Future<Object>(){

            @Override
            public boolean cancel(boolean bl) {
                return true;
            }

            @Override
            public Object get() throws InterruptedException, ExecutionException {
                Object var1_1 = null;
                for (AbstractTransfer abstractTransfer : MultipleFileTransferMonitor.this.subTransfers) {
                    var1_1 = abstractTransfer.getMonitor().getFuture().get();
                }
                return var1_1;
            }

            @Override
            public Object get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                Object var4_3 = null;
                for (AbstractTransfer abstractTransfer : MultipleFileTransferMonitor.this.subTransfers) {
                    var4_3 = abstractTransfer.getMonitor().getFuture().get(l, timeUnit);
                }
                return var4_3;
            }

            @Override
            public boolean isCancelled() {
                return MultipleFileTransferMonitor.this.transfer.getState() == Transfer.TransferState.Canceled;
            }

            @Override
            public boolean isDone() {
                return MultipleFileTransferMonitor.this.isDone();
            }
        };
    }

    @Override
    public Future<?> getFuture() {
        return this.future;
    }

    @Override
    public synchronized boolean isDone() {
        for (Transfer transfer : this.subTransfers) {
            if (transfer.isDone()) continue;
            return false;
        }
        return true;
    }
}

