/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.CompleteMultipartCopy;
import com.amazonaws.services.s3.transfer.internal.CopyCallable;
import com.amazonaws.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class CopyMonitor
implements TransferMonitor,
Callable<CopyResult> {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest origReq;
    private final CopyCallable multipartCopyCallable;
    private final CopyImpl transfer;
    private final ProgressListenerChain listener;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isCopyDone = false;
    private AtomicReference<Future<CopyResult>> futureReference = new AtomicReference<Object>(null);

    public Future<CopyResult> getFuture() {
        return this.futureReference.get();
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCopyDone;
    }

    private synchronized void markAllDone() {
        this.isCopyDone = true;
    }

    public static CopyMonitor create(TransferManager transferManager, CopyImpl copyImpl, ExecutorService executorService, CopyCallable copyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        CopyMonitor copyMonitor = new CopyMonitor(transferManager, copyImpl, executorService, copyCallable, copyObjectRequest, progressListenerChain);
        Future<CopyResult> future = executorService.submit(copyMonitor);
        copyMonitor.futureReference.compareAndSet(null, future);
        return copyMonitor;
    }

    private CopyMonitor(TransferManager transferManager, CopyImpl copyImpl, ExecutorService executorService, CopyCallable copyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.multipartCopyCallable = copyCallable;
        this.origReq = copyObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = copyImpl;
        this.threadPool = executorService;
    }

    @Override
    public CopyResult call() throws Exception {
        try {
            CopyResult copyResult = this.multipartCopyCallable.call();
            if (copyResult == null) {
                this.futures.addAll(this.multipartCopyCallable.getFutures());
                this.futureReference.set(this.threadPool.submit(new CompleteMultipartCopy(this.multipartCopyCallable.getMultipartUploadId(), this.s3, this.origReq, this.futures, this.listener, this)));
            } else {
                this.copyComplete();
            }
            return copyResult;
        }
        catch (CancellationException cancellationException) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new SdkClientException("Upload canceled");
        }
        catch (Exception exception) {
            this.transfer.setState(Transfer.TransferState.Failed);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw exception;
        }
    }

    void copyComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        this.transfer.getProgress().updateProgress(this.transfer.getProgress().getTotalBytesToTransfer());
        if (this.multipartCopyCallable.isMultipartCopy()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    void reportFailure() {
        this.transfer.setState(Transfer.TransferState.Failed);
    }
}

