/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.transfer.internal.CopyMonitor;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CompleteMultipartCopy
implements Callable<CopyResult> {
    private final String uploadId;
    private final AmazonS3 s3;
    private final CopyObjectRequest origReq;
    private final List<Future<PartETag>> futures;
    private final CopyMonitor monitor;
    private final ProgressListenerChain listener;

    public CompleteMultipartCopy(String string, AmazonS3 amazonS3, CopyObjectRequest copyObjectRequest, List<Future<PartETag>> list, ProgressListenerChain progressListenerChain, CopyMonitor copyMonitor) {
        this.uploadId = string;
        this.s3 = amazonS3;
        this.origReq = copyObjectRequest;
        this.futures = list;
        this.listener = progressListenerChain;
        this.monitor = copyMonitor;
    }

    @Override
    public CopyResult call() throws Exception {
        CompleteMultipartUploadResult completeMultipartUploadResult;
        Object object;
        try {
            object = (CompleteMultipartUploadRequest)((AmazonWebServiceRequest)((AmazonWebServiceRequest)new CompleteMultipartUploadRequest(this.origReq.getDestinationBucketName(), this.origReq.getDestinationKey(), this.uploadId, this.collectPartETags()).withRequesterPays(this.origReq.isRequesterPays()).withGeneralProgressListener(this.origReq.getGeneralProgressListener())).withRequestMetricCollector(this.origReq.getRequestMetricCollector())).withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
            completeMultipartUploadResult = this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)object);
        }
        catch (Exception exception) {
            this.monitor.reportFailure();
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw exception;
        }
        object = new CopyResult();
        ((CopyResult)object).setSourceBucketName(this.origReq.getSourceBucketName());
        ((CopyResult)object).setSourceKey(this.origReq.getSourceKey());
        ((CopyResult)object).setDestinationBucketName(completeMultipartUploadResult.getBucketName());
        ((CopyResult)object).setDestinationKey(completeMultipartUploadResult.getKey());
        ((CopyResult)object).setETag(completeMultipartUploadResult.getETag());
        ((CopyResult)object).setVersionId(completeMultipartUploadResult.getVersionId());
        this.monitor.copyComplete();
        return object;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        for (Future<PartETag> future : this.futures) {
            try {
                arrayList.add(future.get());
            }
            catch (Exception exception) {
                throw new SdkClientException("Unable to copy part: " + exception.getCause().getMessage(), exception.getCause());
            }
        }
        return arrayList;
    }
}

