/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.services.s3.transfer.PersistableDownload;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class PersistableTransfer {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public final String serialize() {
        return Jackson.toJsonString(this);
    }

    public final void serialize(OutputStream outputStream2) throws IOException {
        outputStream2.write(Jackson.toJsonString(this).getBytes(StringUtils.UTF8));
        outputStream2.flush();
    }

    public static <T extends PersistableTransfer> T deserializeFrom(InputStream inputStream2) {
        String string;
        Class<PersistableUpload> clazz;
        JsonNode jsonNode;
        try {
            jsonNode = MAPPER.readTree(inputStream2);
            clazz = jsonNode.get("pauseType");
            if (clazz == null) {
                throw new IllegalArgumentException("Unrecognized serialized state");
            }
            string = ((JsonNode)((Object)clazz)).asText();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        if ("download".equals(string)) {
            clazz = PersistableDownload.class;
        } else if ("upload".equals(string)) {
            clazz = PersistableUpload.class;
        } else {
            throw new UnsupportedOperationException("Unsupported paused transfer type: " + string);
        }
        try {
            PersistableTransfer persistableTransfer = MAPPER.treeToValue((TreeNode)jsonNode, clazz);
            return (T)persistableTransfer;
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PersistableTransfer> T deserializeFrom(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StringUtils.UTF8));
        T t2 = PersistableTransfer.deserializeFrom(byteArrayInputStream);
        return t2;
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

