/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.internal.XmlWriterUtils;
import com.amazonaws.services.s3.model.ObjectLockRetention;
import java.util.Date;

public final class ObjectLockRetentionXmlFactory {
    public byte[] convertToXmlByteArray(ObjectLockRetention objectLockRetention) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Retention", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        XmlWriterUtils.addIfNotNull(xmlWriter, "Mode", objectLockRetention.getMode());
        ObjectLockRetentionXmlFactory.addDateIfNotNull(xmlWriter, "RetainUntilDate", objectLockRetention.getRetainUntilDate());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private static void addDateIfNotNull(XmlWriter xmlWriter, String string, Date date) {
        if (date != null) {
            xmlWriter.start(string).value(ServiceUtils.formatIso8601Date(date)).end();
        }
    }
}

