/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3.model.PublicAccessBlockConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XmlUtils;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;

public class GetPublicAccessBlockStaxUnmarshaller
implements Unmarshaller<GetPublicAccessBlockResult, InputStream> {
    private static final GetPublicAccessBlockStaxUnmarshaller instance = new GetPublicAccessBlockStaxUnmarshaller();

    public static GetPublicAccessBlockStaxUnmarshaller getInstance() {
        return instance;
    }

    private GetPublicAccessBlockStaxUnmarshaller() {
    }

    @Override
    public GetPublicAccessBlockResult unmarshall(InputStream inputStream2) throws Exception {
        StaxUnmarshallerContext staxUnmarshallerContext = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream2));
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        GetPublicAccessBlockResult getPublicAccessBlockResult = new GetPublicAccessBlockResult();
        PublicAccessBlockConfiguration publicAccessBlockConfiguration = new PublicAccessBlockConfiguration();
        getPublicAccessBlockResult.setPublicAccessBlockConfiguration(publicAccessBlockConfiguration);
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return getPublicAccessBlockResult;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("BlockPublicAcls", n2)) {
                    publicAccessBlockConfiguration.setBlockPublicAcls(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                }
                if (staxUnmarshallerContext.testExpression("IgnorePublicAcls", n2)) {
                    publicAccessBlockConfiguration.setIgnorePublicAcls(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                }
                if (staxUnmarshallerContext.testExpression("BlockPublicPolicy", n2)) {
                    publicAccessBlockConfiguration.setBlockPublicPolicy(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                }
                if (!staxUnmarshallerContext.testExpression("RestrictPublicBuckets", n2)) continue;
                publicAccessBlockConfiguration.setRestrictPublicBuckets(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return getPublicAccessBlockResult;
    }
}

