/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.AccessControlTranslation;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketReplicationConfiguration;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CloudFunctionConfiguration;
import com.amazonaws.services.s3.model.DeleteMarkerReplication;
import com.amazonaws.services.s3.model.EventBridgeConfiguration;
import com.amazonaws.services.s3.model.ExistingObjectReplication;
import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.FilterRule;
import com.amazonaws.services.s3.model.LambdaConfiguration;
import com.amazonaws.services.s3.model.Metrics;
import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.services.s3.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3.model.QueueConfiguration;
import com.amazonaws.services.s3.model.RedirectRule;
import com.amazonaws.services.s3.model.ReplicaModifications;
import com.amazonaws.services.s3.model.ReplicationDestinationConfig;
import com.amazonaws.services.s3.model.ReplicationRule;
import com.amazonaws.services.s3.model.ReplicationTime;
import com.amazonaws.services.s3.model.ReplicationTimeValue;
import com.amazonaws.services.s3.model.RoutingRule;
import com.amazonaws.services.s3.model.RoutingRuleCondition;
import com.amazonaws.services.s3.model.S3KeyFilter;
import com.amazonaws.services.s3.model.ServerSideEncryptionByDefault;
import com.amazonaws.services.s3.model.ServerSideEncryptionConfiguration;
import com.amazonaws.services.s3.model.ServerSideEncryptionRule;
import com.amazonaws.services.s3.model.SourceSelectionCriteria;
import com.amazonaws.services.s3.model.SseKmsEncryptedObjects;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.TagSet;
import com.amazonaws.services.s3.model.TopicConfiguration;
import com.amazonaws.services.s3.model.analytics.AnalyticsConfiguration;
import com.amazonaws.services.s3.model.analytics.AnalyticsExportDestination;
import com.amazonaws.services.s3.model.analytics.AnalyticsFilter;
import com.amazonaws.services.s3.model.analytics.AnalyticsFilterPredicate;
import com.amazonaws.services.s3.model.analytics.AnalyticsS3BucketDestination;
import com.amazonaws.services.s3.model.analytics.StorageClassAnalysis;
import com.amazonaws.services.s3.model.analytics.StorageClassAnalysisDataExport;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringConfiguration;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringFilter;
import com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringFilterPredicate;
import com.amazonaws.services.s3.model.intelligenttiering.Tiering;
import com.amazonaws.services.s3.model.inventory.InventoryConfiguration;
import com.amazonaws.services.s3.model.inventory.InventoryDestination;
import com.amazonaws.services.s3.model.inventory.InventoryEncryption;
import com.amazonaws.services.s3.model.inventory.InventoryFilter;
import com.amazonaws.services.s3.model.inventory.InventoryFilterPredicate;
import com.amazonaws.services.s3.model.inventory.InventoryPrefixPredicate;
import com.amazonaws.services.s3.model.inventory.InventoryS3BucketDestination;
import com.amazonaws.services.s3.model.inventory.InventorySchedule;
import com.amazonaws.services.s3.model.inventory.ServerSideEncryptionKMS;
import com.amazonaws.services.s3.model.inventory.ServerSideEncryptionS3;
import com.amazonaws.services.s3.model.lifecycle.LifecycleAndOperator;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilter;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecycleObjectSizeGreaterThanPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecycleObjectSizeLessThanPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecyclePredicateVisitor;
import com.amazonaws.services.s3.model.lifecycle.LifecyclePrefixPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsAccessPointArnPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsAndOperator;
import com.amazonaws.services.s3.model.metrics.MetricsConfiguration;
import com.amazonaws.services.s3.model.metrics.MetricsFilter;
import com.amazonaws.services.s3.model.metrics.MetricsFilterPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsPredicateVisitor;
import com.amazonaws.services.s3.model.metrics.MetricsPrefixPredicate;
import com.amazonaws.services.s3.model.metrics.MetricsTagPredicate;
import com.amazonaws.services.s3.model.ownership.OwnershipControls;
import com.amazonaws.services.s3.model.ownership.OwnershipControlsRule;
import com.amazonaws.services.s3.model.replication.ReplicationFilter;
import com.amazonaws.services.s3.model.replication.ReplicationFilterPredicate;
import com.amazonaws.services.s3.model.transform.AnalyticsPredicateVisitorImpl;
import com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactoryFunctions;
import com.amazonaws.services.s3.model.transform.ReplicationPredicateVisitorImpl;
import com.amazonaws.services.s3.model.transform.XmlIntelligentTieringPredicateVisitor;
import com.amazonaws.util.CollectionUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class BucketConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(BucketVersioningConfiguration bucketVersioningConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("VersioningConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xmlWriter.start("Status").value(bucketVersioningConfiguration.getStatus()).end();
        Boolean bl = bucketVersioningConfiguration.isMfaDeleteEnabled();
        if (bl != null) {
            if (bl.booleanValue()) {
                xmlWriter.start("MfaDelete").value("Enabled").end();
            } else {
                xmlWriter.start("MfaDelete").value("Disabled").end();
            }
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketAccelerateConfiguration bucketAccelerateConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("AccelerateConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xmlWriter.start("Status").value(bucketAccelerateConfiguration.getStatus()).end();
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLoggingConfiguration bucketLoggingConfiguration) {
        String string = bucketLoggingConfiguration.getLogFilePrefix();
        if (string == null) {
            string = "";
        }
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("BucketLoggingStatus", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (bucketLoggingConfiguration.isLoggingEnabled()) {
            xmlWriter.start("LoggingEnabled");
            xmlWriter.start("TargetBucket").value(bucketLoggingConfiguration.getDestinationBucketName()).end();
            xmlWriter.start("TargetPrefix").value(bucketLoggingConfiguration.getLogFilePrefix()).end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketNotificationConfiguration bucketNotificationConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("NotificationConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        Map<String, NotificationConfiguration> map = bucketNotificationConfiguration.getConfigurations();
        for (Map.Entry<String, NotificationConfiguration> entry : map.entrySet()) {
            String string = entry.getKey();
            NotificationConfiguration notificationConfiguration = entry.getValue();
            if (notificationConfiguration instanceof TopicConfiguration) {
                xmlWriter.start("TopicConfiguration");
                xmlWriter.start("Id").value(string).end();
                xmlWriter.start("Topic").value(((TopicConfiguration)notificationConfiguration).getTopicARN()).end();
                this.addEventsAndFilterCriteria(xmlWriter, notificationConfiguration);
                xmlWriter.end();
                continue;
            }
            if (notificationConfiguration instanceof QueueConfiguration) {
                xmlWriter.start("QueueConfiguration");
                xmlWriter.start("Id").value(string).end();
                xmlWriter.start("Queue").value(((QueueConfiguration)notificationConfiguration).getQueueARN()).end();
                this.addEventsAndFilterCriteria(xmlWriter, notificationConfiguration);
                xmlWriter.end();
                continue;
            }
            if (notificationConfiguration instanceof CloudFunctionConfiguration) {
                xmlWriter.start("CloudFunctionConfiguration");
                xmlWriter.start("Id").value(string).end();
                xmlWriter.start("InvocationRole").value(((CloudFunctionConfiguration)notificationConfiguration).getInvocationRoleARN()).end();
                xmlWriter.start("CloudFunction").value(((CloudFunctionConfiguration)notificationConfiguration).getCloudFunctionARN()).end();
                this.addEventsAndFilterCriteria(xmlWriter, notificationConfiguration);
                xmlWriter.end();
                continue;
            }
            if (!(notificationConfiguration instanceof LambdaConfiguration)) continue;
            xmlWriter.start("CloudFunctionConfiguration");
            xmlWriter.start("Id").value(string).end();
            xmlWriter.start("CloudFunction").value(((LambdaConfiguration)notificationConfiguration).getFunctionARN()).end();
            this.addEventsAndFilterCriteria(xmlWriter, notificationConfiguration);
            xmlWriter.end();
        }
        EventBridgeConfiguration eventBridgeConfiguration = bucketNotificationConfiguration.getEventBridgeConfiguration();
        if (eventBridgeConfiguration != null) {
            xmlWriter.start("EventBridgeConfiguration");
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void addEventsAndFilterCriteria(XmlWriter xmlWriter, NotificationConfiguration notificationConfiguration) {
        for (String object : notificationConfiguration.getEvents()) {
            xmlWriter.start("Event").value(object).end();
        }
        Filter filter = notificationConfiguration.getFilter();
        if (filter != null) {
            this.validateFilter(filter);
            xmlWriter.start("Filter");
            if (filter.getS3KeyFilter() != null) {
                this.validateS3KeyFilter(filter.getS3KeyFilter());
                xmlWriter.start("S3Key");
                for (FilterRule filterRule : filter.getS3KeyFilter().getFilterRules()) {
                    xmlWriter.start("FilterRule");
                    xmlWriter.start("Name").value(filterRule.getName()).end();
                    xmlWriter.start("Value").value(filterRule.getValue()).end();
                    xmlWriter.end();
                }
                xmlWriter.end();
            }
            xmlWriter.end();
        }
    }

    private void validateFilter(Filter filter) {
        if (filter.getS3KeyFilter() == null) {
            throw new SdkClientException("Cannot have a Filter without any criteria");
        }
    }

    private void validateS3KeyFilter(S3KeyFilter s3KeyFilter) {
        if (CollectionUtils.isNullOrEmpty(s3KeyFilter.getFilterRules())) {
            throw new SdkClientException("Cannot have an S3KeyFilter without any filter rules");
        }
    }

    private void writeReplicationPrefix(XmlWriter xmlWriter, ReplicationRule replicationRule) {
        if (replicationRule.getFilter() == null) {
            xmlWriter.start("Prefix").value(replicationRule.getPrefix() == null ? "" : replicationRule.getPrefix()).end();
        } else if (replicationRule.getPrefix() != null) {
            throw new IllegalArgumentException("Prefix cannot be used with Filter. Use ReplicationPrefixPredicate to create a ReplicationFilter");
        }
    }

    public byte[] convertToXmlByteArray(BucketReplicationConfiguration bucketReplicationConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("ReplicationConfiguration");
        Map<String, ReplicationRule> map = bucketReplicationConfiguration.getRules();
        String string = bucketReplicationConfiguration.getRoleARN();
        xmlWriter.start("Role").value(string).end();
        for (Map.Entry<String, ReplicationRule> entry : map.entrySet()) {
            Serializable serializable;
            ReplicationTime replicationTime;
            Cloneable cloneable;
            Serializable serializable2;
            DeleteMarkerReplication deleteMarkerReplication;
            String string2 = entry.getKey();
            ReplicationRule replicationRule = entry.getValue();
            xmlWriter.start("Rule");
            xmlWriter.start("ID").value(string2).end();
            Integer n = replicationRule.getPriority();
            if (n != null) {
                xmlWriter.start("Priority").value(Integer.toString(n)).end();
            }
            xmlWriter.start("Status").value(replicationRule.getStatus()).end();
            ExistingObjectReplication existingObjectReplication = replicationRule.getExistingObjectReplication();
            if (existingObjectReplication != null) {
                xmlWriter.start("ExistingObjectReplication").start("Status").value(existingObjectReplication.getStatus()).end().end();
            }
            if ((deleteMarkerReplication = replicationRule.getDeleteMarkerReplication()) != null) {
                xmlWriter.start("DeleteMarkerReplication").start("Status").value(deleteMarkerReplication.getStatus()).end().end();
            }
            this.writeReplicationPrefix(xmlWriter, replicationRule);
            this.writeReplicationFilter(xmlWriter, replicationRule.getFilter());
            SourceSelectionCriteria sourceSelectionCriteria = replicationRule.getSourceSelectionCriteria();
            if (sourceSelectionCriteria != null) {
                xmlWriter.start("SourceSelectionCriteria");
                serializable2 = sourceSelectionCriteria.getSseKmsEncryptedObjects();
                if (serializable2 != null) {
                    xmlWriter.start("SseKmsEncryptedObjects");
                    BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Status", ((SseKmsEncryptedObjects)serializable2).getStatus());
                    xmlWriter.end();
                }
                if ((cloneable = sourceSelectionCriteria.getReplicaModifications()) != null) {
                    xmlWriter.start("ReplicaModifications");
                    BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Status", ((ReplicaModifications)cloneable).getStatus());
                    xmlWriter.end();
                }
                xmlWriter.end();
            }
            serializable2 = replicationRule.getDestinationConfig();
            xmlWriter.start("Destination");
            xmlWriter.start("Bucket").value(((ReplicationDestinationConfig)serializable2).getBucketARN()).end();
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Account", ((ReplicationDestinationConfig)serializable2).getAccount());
            if (((ReplicationDestinationConfig)serializable2).getStorageClass() != null) {
                xmlWriter.start("StorageClass").value(((ReplicationDestinationConfig)serializable2).getStorageClass()).end();
            }
            if ((cloneable = ((ReplicationDestinationConfig)serializable2).getAccessControlTranslation()) != null) {
                xmlWriter.start("AccessControlTranslation");
                BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Owner", ((AccessControlTranslation)cloneable).getOwner());
                xmlWriter.end();
            }
            if (((ReplicationDestinationConfig)serializable2).getEncryptionConfiguration() != null) {
                xmlWriter.start("EncryptionConfiguration");
                BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "ReplicaKmsKeyID", ((ReplicationDestinationConfig)serializable2).getEncryptionConfiguration().getReplicaKmsKeyID());
                xmlWriter.end();
            }
            if ((replicationTime = ((ReplicationDestinationConfig)serializable2).getReplicationTime()) != null) {
                xmlWriter.start("ReplicationTime");
                BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Status", replicationTime.getStatus());
                if (replicationTime.getTime() != null) {
                    xmlWriter.start("Time");
                    serializable = replicationTime.getTime();
                    if (((ReplicationTimeValue)serializable).getMinutes() != null) {
                        xmlWriter.start("Minutes").value(((ReplicationTimeValue)serializable).getMinutes().toString()).end();
                    }
                    xmlWriter.end();
                }
                xmlWriter.end();
            }
            if ((serializable = ((ReplicationDestinationConfig)serializable2).getMetrics()) != null) {
                xmlWriter.start("Metrics");
                BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Status", ((Metrics)serializable).getStatus());
                if (((Metrics)serializable).getEventThreshold() != null) {
                    xmlWriter.start("EventThreshold");
                    ReplicationTimeValue replicationTimeValue = ((Metrics)serializable).getEventThreshold();
                    if (replicationTimeValue.getMinutes() != null) {
                        xmlWriter.start("Minutes").value(replicationTimeValue.getMinutes().toString()).end();
                    }
                    xmlWriter.end();
                }
                xmlWriter.end();
            }
            xmlWriter.end();
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketWebsiteConfiguration bucketWebsiteConfiguration) {
        XmlWriter xmlWriter;
        Object object;
        XmlWriter xmlWriter2 = new XmlWriter();
        xmlWriter2.start("WebsiteConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (bucketWebsiteConfiguration.getIndexDocumentSuffix() != null) {
            object = xmlWriter2.start("IndexDocument");
            ((XmlWriter)object).start("Suffix").value(bucketWebsiteConfiguration.getIndexDocumentSuffix()).end();
            ((XmlWriter)object).end();
        }
        if (bucketWebsiteConfiguration.getErrorDocument() != null) {
            object = xmlWriter2.start("ErrorDocument");
            ((XmlWriter)object).start("Key").value(bucketWebsiteConfiguration.getErrorDocument()).end();
            ((XmlWriter)object).end();
        }
        if ((object = bucketWebsiteConfiguration.getRedirectAllRequestsTo()) != null) {
            xmlWriter = xmlWriter2.start("RedirectAllRequestsTo");
            if (((RedirectRule)object).getprotocol() != null) {
                xmlWriter2.start("Protocol").value(((RedirectRule)object).getprotocol()).end();
            }
            if (((RedirectRule)object).getHostName() != null) {
                xmlWriter2.start("HostName").value(((RedirectRule)object).getHostName()).end();
            }
            if (((RedirectRule)object).getReplaceKeyPrefixWith() != null) {
                xmlWriter2.start("ReplaceKeyPrefixWith").value(((RedirectRule)object).getReplaceKeyPrefixWith()).end();
            }
            if (((RedirectRule)object).getReplaceKeyWith() != null) {
                xmlWriter2.start("ReplaceKeyWith").value(((RedirectRule)object).getReplaceKeyWith()).end();
            }
            xmlWriter.end();
        }
        if (bucketWebsiteConfiguration.getRoutingRules() != null && bucketWebsiteConfiguration.getRoutingRules().size() > 0) {
            xmlWriter = xmlWriter2.start("RoutingRules");
            for (RoutingRule routingRule : bucketWebsiteConfiguration.getRoutingRules()) {
                this.writeRule(xmlWriter, routingRule);
            }
            xmlWriter.end();
        }
        xmlWriter2.end();
        return xmlWriter2.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLifecycleConfiguration bucketLifecycleConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : bucketLifecycleConfiguration.getRules()) {
            this.writeRule(xmlWriter, rule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketCrossOriginConfiguration bucketCrossOriginConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("CORSConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        for (CORSRule cORSRule : bucketCrossOriginConfiguration.getRules()) {
            this.writeRule(xmlWriter, cORSRule);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeLifecyclePrefix(XmlWriter xmlWriter, BucketLifecycleConfiguration.Rule rule) {
        if (rule.getFilter() == null) {
            xmlWriter.start("Prefix").value(rule.getPrefix() == null ? "" : rule.getPrefix()).end();
        } else if (rule.getPrefix() != null) {
            throw new IllegalArgumentException("Prefix cannot be used with Filter. Use LifecyclePrefixPredicate to create a LifecycleFilter");
        }
    }

    private void writeRule(XmlWriter xmlWriter, BucketLifecycleConfiguration.Rule rule) {
        xmlWriter.start("Rule");
        if (rule.getId() != null) {
            xmlWriter.start("ID").value(rule.getId()).end();
        }
        this.writeLifecyclePrefix(xmlWriter, rule);
        xmlWriter.start("Status").value(rule.getStatus()).end();
        this.writeLifecycleFilter(xmlWriter, rule.getFilter());
        this.addTransitions(xmlWriter, rule.getTransitions());
        this.addNoncurrentTransitions(xmlWriter, rule.getNoncurrentVersionTransitions());
        this.addNoncurrentExpiration(xmlWriter, rule.getNoncurrentVersionExpiration());
        if (this.hasCurrentExpirationPolicy(rule)) {
            xmlWriter.start("Expiration");
            if (rule.getExpirationInDays() != -1) {
                xmlWriter.start("Days").value("" + rule.getExpirationInDays()).end();
            }
            if (rule.getExpirationDate() != null) {
                xmlWriter.start("Date").value(ServiceUtils.formatIso8601Date(rule.getExpirationDate())).end();
            }
            if (rule.isExpiredObjectDeleteMarker()) {
                xmlWriter.start("ExpiredObjectDeleteMarker").value("true").end();
            }
            xmlWriter.end();
        }
        if (rule.getAbortIncompleteMultipartUpload() != null) {
            xmlWriter.start("AbortIncompleteMultipartUpload");
            xmlWriter.start("DaysAfterInitiation").value(Integer.toString(rule.getAbortIncompleteMultipartUpload().getDaysAfterInitiation())).end();
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void addTransitions(XmlWriter xmlWriter, List<BucketLifecycleConfiguration.Transition> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.Transition transition : list) {
            if (transition == null) continue;
            xmlWriter.start("Transition");
            if (transition.getDate() != null) {
                xmlWriter.start("Date");
                xmlWriter.value(ServiceUtils.formatIso8601Date(transition.getDate()));
                xmlWriter.end();
            }
            if (transition.getDays() != -1) {
                xmlWriter.start("Days");
                xmlWriter.value(Integer.toString(transition.getDays()));
                xmlWriter.end();
            }
            xmlWriter.start("StorageClass");
            xmlWriter.value(transition.getStorageClassAsString());
            xmlWriter.end();
            xmlWriter.end();
        }
    }

    private void addNoncurrentTransitions(XmlWriter xmlWriter, List<BucketLifecycleConfiguration.NoncurrentVersionTransition> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.NoncurrentVersionTransition noncurrentVersionTransition : list) {
            if (noncurrentVersionTransition == null) continue;
            xmlWriter.start("NoncurrentVersionTransition");
            if (noncurrentVersionTransition.getDays() != -1) {
                xmlWriter.start("NoncurrentDays");
                xmlWriter.value(Integer.toString(noncurrentVersionTransition.getDays()));
                xmlWriter.end();
            }
            if (noncurrentVersionTransition.getNewerNoncurrentVersions() != -1) {
                xmlWriter.start("NewerNoncurrentVersions");
                xmlWriter.value(Integer.toString(noncurrentVersionTransition.getNewerNoncurrentVersions()));
                xmlWriter.end();
            }
            xmlWriter.start("StorageClass");
            xmlWriter.value(noncurrentVersionTransition.getStorageClassAsString());
            xmlWriter.end();
            xmlWriter.end();
        }
    }

    private void addNoncurrentExpiration(XmlWriter xmlWriter, BucketLifecycleConfiguration.NoncurrentVersionExpiration noncurrentVersionExpiration) {
        if (noncurrentVersionExpiration == null) {
            return;
        }
        xmlWriter.start("NoncurrentVersionExpiration");
        if (noncurrentVersionExpiration.getDays() != -1) {
            xmlWriter.start("NoncurrentDays");
            xmlWriter.value(Integer.toString(noncurrentVersionExpiration.getDays()));
            xmlWriter.end();
        }
        if (noncurrentVersionExpiration.getNewerNoncurrentVersions() != -1) {
            xmlWriter.start("NewerNoncurrentVersions");
            xmlWriter.value(Integer.toString(noncurrentVersionExpiration.getNewerNoncurrentVersions()));
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeLifecycleFilter(XmlWriter xmlWriter, LifecycleFilter lifecycleFilter) {
        if (lifecycleFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeLifecycleFilterPredicate(xmlWriter, lifecycleFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeLifecycleFilterPredicate(XmlWriter xmlWriter, LifecycleFilterPredicate lifecycleFilterPredicate) {
        if (lifecycleFilterPredicate == null) {
            return;
        }
        lifecycleFilterPredicate.accept(new LifecyclePredicateVisitorImpl(xmlWriter));
    }

    private void writeReplicationFilter(XmlWriter xmlWriter, ReplicationFilter replicationFilter) {
        if (replicationFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeReplicationPredicate(xmlWriter, replicationFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeReplicationPredicate(XmlWriter xmlWriter, ReplicationFilterPredicate replicationFilterPredicate) {
        if (replicationFilterPredicate == null) {
            return;
        }
        replicationFilterPredicate.accept(new ReplicationPredicateVisitorImpl(xmlWriter));
    }

    public byte[] convertToXmlByteArray(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("ServerSideEncryptionConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        for (ServerSideEncryptionRule serverSideEncryptionRule : serverSideEncryptionConfiguration.getRules()) {
            xmlWriter.start("Rule");
            this.addBooleanParameterIfNotNull(xmlWriter, "BucketKeyEnabled", serverSideEncryptionRule.getBucketKeyEnabled());
            this.writeServerSideEncryptionByDefault(xmlWriter, serverSideEncryptionRule.getApplyServerSideEncryptionByDefault());
            xmlWriter.end();
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeServerSideEncryptionByDefault(XmlWriter xmlWriter, ServerSideEncryptionByDefault serverSideEncryptionByDefault) {
        if (serverSideEncryptionByDefault == null) {
            return;
        }
        xmlWriter.start("ApplyServerSideEncryptionByDefault");
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "SSEAlgorithm", serverSideEncryptionByDefault.getSSEAlgorithm());
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "KMSMasterKeyID", serverSideEncryptionByDefault.getKMSMasterKeyID());
        xmlWriter.end();
    }

    public byte[] convertToXmlByteArray(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("PublicAccessBlockConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        this.addBooleanParameterIfNotNull(xmlWriter, "BlockPublicAcls", publicAccessBlockConfiguration.getBlockPublicAcls());
        this.addBooleanParameterIfNotNull(xmlWriter, "IgnorePublicAcls", publicAccessBlockConfiguration.getIgnorePublicAcls());
        this.addBooleanParameterIfNotNull(xmlWriter, "BlockPublicPolicy", publicAccessBlockConfiguration.getBlockPublicPolicy());
        this.addBooleanParameterIfNotNull(xmlWriter, "RestrictPublicBuckets", publicAccessBlockConfiguration.getRestrictPublicBuckets());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private boolean hasCurrentExpirationPolicy(BucketLifecycleConfiguration.Rule rule) {
        return rule.getExpirationInDays() != -1 || rule.getExpirationDate() != null || rule.isExpiredObjectDeleteMarker();
    }

    private void writeRule(XmlWriter xmlWriter, CORSRule cORSRule) {
        xmlWriter.start("CORSRule");
        if (cORSRule.getId() != null) {
            xmlWriter.start("ID").value(cORSRule.getId()).end();
        }
        if (cORSRule.getAllowedOrigins() != null) {
            for (String object : cORSRule.getAllowedOrigins()) {
                xmlWriter.start("AllowedOrigin").value(object).end();
            }
        }
        if (cORSRule.getAllowedMethods() != null) {
            for (CORSRule.AllowedMethods allowedMethods : cORSRule.getAllowedMethods()) {
                xmlWriter.start("AllowedMethod").value(allowedMethods.toString()).end();
            }
        }
        if (cORSRule.getMaxAgeSeconds() != 0) {
            xmlWriter.start("MaxAgeSeconds").value(Integer.toString(cORSRule.getMaxAgeSeconds())).end();
        }
        if (cORSRule.getExposedHeaders() != null) {
            for (String string : cORSRule.getExposedHeaders()) {
                xmlWriter.start("ExposeHeader").value(string).end();
            }
        }
        if (cORSRule.getAllowedHeaders() != null) {
            for (String string : cORSRule.getAllowedHeaders()) {
                xmlWriter.start("AllowedHeader").value(string).end();
            }
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, RoutingRule routingRule) {
        xmlWriter.start("RoutingRule");
        RoutingRuleCondition routingRuleCondition = routingRule.getCondition();
        if (routingRuleCondition != null) {
            xmlWriter.start("Condition");
            xmlWriter.start("KeyPrefixEquals");
            if (routingRuleCondition.getKeyPrefixEquals() != null) {
                xmlWriter.value(routingRuleCondition.getKeyPrefixEquals());
            }
            xmlWriter.end();
            if (routingRuleCondition.getHttpErrorCodeReturnedEquals() != null) {
                xmlWriter.start("HttpErrorCodeReturnedEquals ").value(routingRuleCondition.getHttpErrorCodeReturnedEquals()).end();
            }
            xmlWriter.end();
        }
        xmlWriter.start("Redirect");
        RedirectRule redirectRule = routingRule.getRedirect();
        if (redirectRule != null) {
            if (redirectRule.getprotocol() != null) {
                xmlWriter.start("Protocol").value(redirectRule.getprotocol()).end();
            }
            if (redirectRule.getHostName() != null) {
                xmlWriter.start("HostName").value(redirectRule.getHostName()).end();
            }
            if (redirectRule.getReplaceKeyPrefixWith() != null) {
                xmlWriter.start("ReplaceKeyPrefixWith").value(redirectRule.getReplaceKeyPrefixWith()).end();
            }
            if (redirectRule.getReplaceKeyWith() != null) {
                xmlWriter.start("ReplaceKeyWith").value(redirectRule.getReplaceKeyWith()).end();
            }
            if (redirectRule.getHttpRedirectCode() != null) {
                xmlWriter.start("HttpRedirectCode").value(redirectRule.getHttpRedirectCode()).end();
            }
        }
        xmlWriter.end();
        xmlWriter.end();
    }

    public byte[] convertToXmlByteArray(BucketTaggingConfiguration bucketTaggingConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("Tagging");
        for (TagSet tagSet : bucketTaggingConfiguration.getAllTagSets()) {
            this.writeRule(xmlWriter, tagSet);
        }
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    public byte[] convertToXmlByteArray(InventoryConfiguration inventoryConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("InventoryConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        xmlWriter.start("Id").value(inventoryConfiguration.getId()).end();
        xmlWriter.start("IsEnabled").value(String.valueOf(inventoryConfiguration.isEnabled())).end();
        xmlWriter.start("IncludedObjectVersions").value(inventoryConfiguration.getIncludedObjectVersions()).end();
        this.writeInventoryDestination(xmlWriter, inventoryConfiguration.getDestination());
        this.writeInventoryFilter(xmlWriter, inventoryConfiguration.getInventoryFilter());
        this.addInventorySchedule(xmlWriter, inventoryConfiguration.getSchedule());
        this.addInventoryOptionalFields(xmlWriter, inventoryConfiguration.getOptionalFields());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeInventoryDestination(XmlWriter xmlWriter, InventoryDestination inventoryDestination) {
        if (inventoryDestination == null) {
            return;
        }
        xmlWriter.start("Destination");
        InventoryS3BucketDestination inventoryS3BucketDestination = inventoryDestination.getS3BucketDestination();
        if (inventoryS3BucketDestination != null) {
            xmlWriter.start("S3BucketDestination");
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "AccountId", inventoryS3BucketDestination.getAccountId());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Bucket", inventoryS3BucketDestination.getBucketArn());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Prefix", inventoryS3BucketDestination.getPrefix());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Format", inventoryS3BucketDestination.getFormat());
            this.writeInventoryEncryption(xmlWriter, inventoryS3BucketDestination.getEncryption());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeInventoryEncryption(XmlWriter xmlWriter, InventoryEncryption inventoryEncryption) {
        if (inventoryEncryption == null) {
            return;
        }
        xmlWriter.start("Encryption");
        if (inventoryEncryption instanceof ServerSideEncryptionS3) {
            xmlWriter.start("SSE-S3").end();
        } else if (inventoryEncryption instanceof ServerSideEncryptionKMS) {
            xmlWriter.start("SSE-KMS");
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "KeyId", ((ServerSideEncryptionKMS)inventoryEncryption).getKeyId());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeInventoryFilter(XmlWriter xmlWriter, InventoryFilter inventoryFilter) {
        if (inventoryFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeInventoryFilterPredicate(xmlWriter, inventoryFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeInventoryFilterPredicate(XmlWriter xmlWriter, InventoryFilterPredicate inventoryFilterPredicate) {
        if (inventoryFilterPredicate == null) {
            return;
        }
        if (inventoryFilterPredicate instanceof InventoryPrefixPredicate) {
            BucketConfigurationXmlFactoryFunctions.writePrefix(xmlWriter, ((InventoryPrefixPredicate)inventoryFilterPredicate).getPrefix());
        }
    }

    private void addInventorySchedule(XmlWriter xmlWriter, InventorySchedule inventorySchedule) {
        if (inventorySchedule == null) {
            return;
        }
        xmlWriter.start("Schedule");
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Frequency", inventorySchedule.getFrequency());
        xmlWriter.end();
    }

    private void addInventoryOptionalFields(XmlWriter xmlWriter, List<String> list) {
        if (CollectionUtils.isNullOrEmpty(list)) {
            return;
        }
        xmlWriter.start("OptionalFields");
        for (String string : list) {
            xmlWriter.start("Field").value(string).end();
        }
        xmlWriter.end();
    }

    private void writeRule(XmlWriter xmlWriter, TagSet tagSet) {
        xmlWriter.start("TagSet");
        for (String string : tagSet.getAllTags().keySet()) {
            xmlWriter.start("Tag");
            xmlWriter.start("Key").value(string).end();
            xmlWriter.start("Value").value(tagSet.getTag(string)).end();
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private boolean hasTags(TagSet tagSet) {
        return tagSet != null && tagSet.getAllTags() != null && tagSet.getAllTags().size() > 0;
    }

    public byte[] convertToXmlByteArray(AnalyticsConfiguration analyticsConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("AnalyticsConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Id", analyticsConfiguration.getId());
        this.writeAnalyticsFilter(xmlWriter, analyticsConfiguration.getFilter());
        this.writeStorageClassAnalysis(xmlWriter, analyticsConfiguration.getStorageClassAnalysis());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeAnalyticsFilter(XmlWriter xmlWriter, AnalyticsFilter analyticsFilter) {
        if (analyticsFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeAnalyticsFilterPredicate(xmlWriter, analyticsFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeAnalyticsFilterPredicate(XmlWriter xmlWriter, AnalyticsFilterPredicate analyticsFilterPredicate) {
        if (analyticsFilterPredicate == null) {
            return;
        }
        analyticsFilterPredicate.accept(new AnalyticsPredicateVisitorImpl(xmlWriter));
    }

    private void writeStorageClassAnalysis(XmlWriter xmlWriter, StorageClassAnalysis storageClassAnalysis) {
        if (storageClassAnalysis == null) {
            return;
        }
        xmlWriter.start("StorageClassAnalysis");
        if (storageClassAnalysis.getDataExport() != null) {
            StorageClassAnalysisDataExport storageClassAnalysisDataExport = storageClassAnalysis.getDataExport();
            xmlWriter.start("DataExport");
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "OutputSchemaVersion", storageClassAnalysisDataExport.getOutputSchemaVersion());
            this.writeAnalyticsExportDestination(xmlWriter, storageClassAnalysisDataExport.getDestination());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    private void writeAnalyticsExportDestination(XmlWriter xmlWriter, AnalyticsExportDestination analyticsExportDestination) {
        if (analyticsExportDestination == null) {
            return;
        }
        xmlWriter.start("Destination");
        if (analyticsExportDestination.getS3BucketDestination() != null) {
            xmlWriter.start("S3BucketDestination");
            AnalyticsS3BucketDestination analyticsS3BucketDestination = analyticsExportDestination.getS3BucketDestination();
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Format", analyticsS3BucketDestination.getFormat());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "BucketAccountId", analyticsS3BucketDestination.getBucketAccountId());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Bucket", analyticsS3BucketDestination.getBucketArn());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Prefix", analyticsS3BucketDestination.getPrefix());
            xmlWriter.end();
        }
        xmlWriter.end();
    }

    public byte[] convertToXmlByteArray(IntelligentTieringConfiguration intelligentTieringConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("IntelligentTieringConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Id", intelligentTieringConfiguration.getId());
        this.writeIntelligentTieringFilter(xmlWriter, intelligentTieringConfiguration.getFilter());
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Status", intelligentTieringConfiguration.getStatus().name());
        this.writeIntelligentTierings(xmlWriter, intelligentTieringConfiguration.getTierings());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeIntelligentTieringFilter(XmlWriter xmlWriter, IntelligentTieringFilter intelligentTieringFilter) {
        if (intelligentTieringFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeIntelligentTieringFilterPredicate(xmlWriter, intelligentTieringFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeIntelligentTieringFilterPredicate(XmlWriter xmlWriter, IntelligentTieringFilterPredicate intelligentTieringFilterPredicate) {
        if (intelligentTieringFilterPredicate == null) {
            return;
        }
        intelligentTieringFilterPredicate.accept(new XmlIntelligentTieringPredicateVisitor(xmlWriter));
    }

    private void writeIntelligentTierings(XmlWriter xmlWriter, List<Tiering> list) {
        if (list == null) {
            return;
        }
        for (Tiering tiering : list) {
            xmlWriter.start("Tiering");
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "AccessTier", tiering.getAccessTier().name());
            BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Days", Integer.toString(tiering.getDays()));
            xmlWriter.end();
        }
    }

    public byte[] convertToXmlByteArray(MetricsConfiguration metricsConfiguration) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("MetricsConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "Id", metricsConfiguration.getId());
        this.writeMetricsFilter(xmlWriter, metricsConfiguration.getFilter());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeMetricsFilter(XmlWriter xmlWriter, MetricsFilter metricsFilter) {
        if (metricsFilter == null) {
            return;
        }
        xmlWriter.start("Filter");
        this.writeMetricsFilterPredicate(xmlWriter, metricsFilter.getPredicate());
        xmlWriter.end();
    }

    private void writeMetricsFilterPredicate(XmlWriter xmlWriter, MetricsFilterPredicate metricsFilterPredicate) {
        if (metricsFilterPredicate == null) {
            return;
        }
        metricsFilterPredicate.accept(new MetricsPredicateVisitorImpl(xmlWriter));
    }

    public byte[] convertToXmlByteArray(OwnershipControls ownershipControls) throws SdkClientException {
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.start("OwnershipControls", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        this.writeOwnershipControlsRule(xmlWriter, ownershipControls.getRules());
        xmlWriter.end();
        return xmlWriter.getBytes();
    }

    private void writeOwnershipControlsRule(XmlWriter xmlWriter, List<OwnershipControlsRule> list) {
        if (list == null) {
            return;
        }
        for (OwnershipControlsRule ownershipControlsRule : list) {
            if (ownershipControlsRule == null) {
                throw new IllegalArgumentException("Ownership control rules must not be null.");
            }
            xmlWriter.start("Rule");
            if (ownershipControlsRule.getOwnership() != null) {
                xmlWriter.start("ObjectOwnership").value(ownershipControlsRule.getOwnership()).end();
            }
            xmlWriter.end();
        }
    }

    private void addBooleanParameterIfNotNull(XmlWriter xmlWriter, String string, Boolean bl) {
        if (bl != null) {
            xmlWriter.start(string).value(bl.toString()).end();
        }
    }

    private void writeTag(XmlWriter xmlWriter, Tag tag) {
        if (tag == null) {
            return;
        }
        xmlWriter.start("Tag");
        xmlWriter.start("Key").value(tag.getKey()).end();
        xmlWriter.start("Value").value(tag.getValue()).end();
        xmlWriter.end();
    }

    static void writeAccessPointArn(XmlWriter xmlWriter, String string) {
        BucketConfigurationXmlFactoryFunctions.addParameterIfNotNull(xmlWriter, "AccessPointArn", string);
    }

    private class MetricsPredicateVisitorImpl
    implements MetricsPredicateVisitor {
        private final XmlWriter xml;

        public MetricsPredicateVisitorImpl(XmlWriter xmlWriter) {
            this.xml = xmlWriter;
        }

        @Override
        public void visit(MetricsPrefixPredicate metricsPrefixPredicate) {
            BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, metricsPrefixPredicate.getPrefix());
        }

        @Override
        public void visit(MetricsTagPredicate metricsTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, metricsTagPredicate.getTag());
        }

        @Override
        public void visit(MetricsAndOperator metricsAndOperator) {
            this.xml.start("And");
            for (MetricsFilterPredicate metricsFilterPredicate : metricsAndOperator.getOperands()) {
                metricsFilterPredicate.accept(this);
            }
            this.xml.end();
        }

        @Override
        public void visit(MetricsAccessPointArnPredicate metricsAccessPointArnPredicate) {
            BucketConfigurationXmlFactory.writeAccessPointArn(this.xml, metricsAccessPointArnPredicate.getAccessPointArn());
        }
    }

    private class LifecyclePredicateVisitorImpl
    implements LifecyclePredicateVisitor {
        private final XmlWriter xml;

        public LifecyclePredicateVisitorImpl(XmlWriter xmlWriter) {
            this.xml = xmlWriter;
        }

        @Override
        public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
            BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
        }

        @Override
        public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, lifecycleTagPredicate.getTag());
        }

        @Override
        public void visit(LifecycleObjectSizeGreaterThanPredicate lifecycleObjectSizeGreaterThanPredicate) {
            BucketConfigurationXmlFactoryFunctions.writeObjectSizeGreaterThan(this.xml, lifecycleObjectSizeGreaterThanPredicate.getObjectSizeGreaterThan());
        }

        @Override
        public void visit(LifecycleObjectSizeLessThanPredicate lifecycleObjectSizeLessThanPredicate) {
            BucketConfigurationXmlFactoryFunctions.writeObjectSizeLessThan(this.xml, lifecycleObjectSizeLessThanPredicate.getObjectSizeLessThan());
        }

        @Override
        public void visit(LifecycleAndOperator lifecycleAndOperator) {
            this.xml.start("And");
            for (LifecycleFilterPredicate lifecycleFilterPredicate : lifecycleAndOperator.getOperands()) {
                lifecycleFilterPredicate.accept(this);
            }
            this.xml.end();
        }
    }
}

