/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.FilterRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class S3KeyFilter
implements Serializable {
    private List<FilterRule> filterRules = new ArrayList<FilterRule>();

    public List<FilterRule> getFilterRules() {
        return Collections.unmodifiableList(this.filterRules);
    }

    public void setFilterRules(List<FilterRule> list) {
        this.filterRules = new ArrayList<FilterRule>(list);
    }

    public S3KeyFilter withFilterRules(List<FilterRule> list) {
        this.setFilterRules(list);
        return this;
    }

    public S3KeyFilter withFilterRules(FilterRule ... filterRuleArray) {
        this.setFilterRules(Arrays.asList(filterRuleArray));
        return this;
    }

    public void addFilterRule(FilterRule filterRule) {
        this.filterRules.add(filterRule);
    }

    public static enum FilterRuleName {
        Prefix,
        Suffix;


        public FilterRule newRule() {
            return new FilterRule().withName(this.toString());
        }

        public FilterRule newRule(String string) {
            return this.newRule().withValue(string);
        }
    }
}

