/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;

public final class PresignedUrlDownloadConfig {
    private static final long DEFAULT_TIMEOUT = -1L;
    private static final long DEFAULT_DOWNLOAD_SIZE = 0x500000L;
    private S3ProgressListener s3progressListener;
    private long timeoutMillis = -1L;
    private long downloadSizePerRequest = 0x500000L;
    private boolean resumeOnRetry = false;

    public S3ProgressListener getS3progressListener() {
        return this.s3progressListener;
    }

    public void setS3progressListener(S3ProgressListener s3ProgressListener) {
        this.s3progressListener = s3ProgressListener;
    }

    public PresignedUrlDownloadConfig withS3progressListener(S3ProgressListener s3ProgressListener) {
        this.setS3progressListener(s3ProgressListener);
        return this;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long l) {
        this.timeoutMillis = l;
    }

    public PresignedUrlDownloadConfig withTimeoutMillis(long l) {
        this.setTimeoutMillis(l);
        return this;
    }

    public long getDownloadSizePerRequest() {
        return this.downloadSizePerRequest;
    }

    public void setDownloadSizePerRequest(long l) {
        this.assertIsPositive(l, "partial object size");
        this.downloadSizePerRequest = l;
    }

    public PresignedUrlDownloadConfig withDownloadSizePerRequest(long l) {
        this.setDownloadSizePerRequest(l);
        return this;
    }

    public boolean isResumeOnRetry() {
        return this.resumeOnRetry;
    }

    public void setResumeOnRetry(boolean bl) {
        this.resumeOnRetry = bl;
    }

    public PresignedUrlDownloadConfig withResumeOnRetry(boolean bl) {
        this.setResumeOnRetry(bl);
        return this;
    }

    private void assertIsPositive(long l, String string) {
        if (l <= 0L) {
            throw new IllegalArgumentException(String.format("%s must be positive", string));
        }
    }
}

