/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.VersionListing;
import java.io.Serializable;

public class ListNextBatchOfVersionsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private VersionListing previousVersionListing;

    public ListNextBatchOfVersionsRequest(VersionListing versionListing) {
        this.setPreviousVersionListing(versionListing);
    }

    public VersionListing getPreviousVersionListing() {
        return this.previousVersionListing;
    }

    public void setPreviousVersionListing(VersionListing versionListing) {
        if (versionListing == null) {
            throw new IllegalArgumentException("The parameter previousVersionListing must be specified.");
        }
        this.previousVersionListing = versionListing;
    }

    public ListNextBatchOfVersionsRequest withPreviousVersionListing(VersionListing versionListing) {
        this.setPreviousVersionListing(versionListing);
        return this;
    }

    public ListVersionsRequest toListVersionsRequest() {
        ListVersionsRequest listVersionsRequest = (ListVersionsRequest)((AmazonWebServiceRequest)((AmazonWebServiceRequest)new ListVersionsRequest(this.previousVersionListing.getBucketName(), this.previousVersionListing.getPrefix(), this.previousVersionListing.getNextKeyMarker(), this.previousVersionListing.getNextVersionIdMarker(), this.previousVersionListing.getDelimiter(), this.previousVersionListing.getMaxKeys()).withEncodingType(this.previousVersionListing.getEncodingType()).withRequestCredentialsProvider(this.getRequestCredentialsProvider())).withGeneralProgressListener(this.getGeneralProgressListener())).withRequestMetricCollector(this.getRequestMetricCollector());
        Integer n = this.getSdkClientExecutionTimeout();
        if (n != null) {
            listVersionsRequest.setSdkClientExecutionTimeout(n);
        }
        Integer n2 = this.getSdkRequestTimeout();
        if (n != null) {
            listVersionsRequest.setSdkRequestTimeout(n2);
        }
        return listVersionsRequest;
    }
}

