/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.HttpMethod;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SSECustomerKeyProvider;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GeneratePresignedUrlRequest
extends AmazonWebServiceRequest
implements SSECustomerKeyProvider,
Serializable {
    private HttpMethod method;
    private String bucketName;
    private String key;
    private String versionId;
    private String contentType;
    private String contentMd5;
    private Date expiration;
    private boolean zeroByteContent;
    private Map<String, String> requestParameters = new HashMap<String, String>();
    private ResponseHeaderOverrides responseHeaders;
    private SSECustomerKey sseCustomerKey;
    private String sseAlgorithm;
    private String kmsCmkId;

    public String getKmsCmkId() {
        return this.kmsCmkId;
    }

    public void setKmsCmkId(String string) {
        this.kmsCmkId = string;
    }

    public GeneratePresignedUrlRequest withKmsCmkId(String string) {
        this.setKmsCmkId(string);
        return this;
    }

    public String getSSEAlgorithm() {
        return this.sseAlgorithm;
    }

    public void setSSEAlgorithm(String string) {
        this.sseAlgorithm = string;
    }

    public GeneratePresignedUrlRequest withSSEAlgorithm(String string) {
        this.setSSEAlgorithm(string);
        return this;
    }

    public void setSSEAlgorithm(SSEAlgorithm sSEAlgorithm) {
        this.sseAlgorithm = sSEAlgorithm.getAlgorithm();
    }

    public GeneratePresignedUrlRequest withSSEAlgorithm(SSEAlgorithm sSEAlgorithm) {
        this.setSSEAlgorithm(sSEAlgorithm);
        return this;
    }

    public GeneratePresignedUrlRequest(String string, String string2) {
        this(string, string2, HttpMethod.GET);
    }

    public GeneratePresignedUrlRequest(String string, String string2, HttpMethod httpMethod) {
        this.bucketName = string;
        this.key = string2;
        this.method = httpMethod;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod httpMethod) {
        this.method = httpMethod;
    }

    public GeneratePresignedUrlRequest withMethod(HttpMethod httpMethod) {
        this.setMethod(httpMethod);
        return this;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public GeneratePresignedUrlRequest withBucketName(String string) {
        this.setBucketName(string);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public GeneratePresignedUrlRequest withKey(String string) {
        this.setKey(string);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String string) {
        this.versionId = string;
    }

    public GeneratePresignedUrlRequest withVersionId(String string) {
        this.setVersionId(string);
        return this;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date date) {
        this.expiration = date;
    }

    public GeneratePresignedUrlRequest withExpiration(Date date) {
        this.setExpiration(date);
        return this;
    }

    public void addRequestParameter(String string, String string2) {
        this.requestParameters.put(string, string2);
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaderOverrides) {
        this.responseHeaders = responseHeaderOverrides;
    }

    public GeneratePresignedUrlRequest withResponseHeaders(ResponseHeaderOverrides responseHeaderOverrides) {
        this.setResponseHeaders(responseHeaderOverrides);
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public GeneratePresignedUrlRequest withContentType(String string) {
        this.setContentType(string);
        return this;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String string) {
        this.contentMd5 = string;
    }

    public GeneratePresignedUrlRequest withContentMd5(String string) {
        this.contentMd5 = string;
        return this;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.sseCustomerKey = sSECustomerKey;
    }

    public GeneratePresignedUrlRequest withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        return this;
    }

    public void setSSECustomerKeyAlgorithm(SSEAlgorithm sSEAlgorithm) {
        if (sSEAlgorithm == null) {
            this.sseCustomerKey = null;
        } else if (sSEAlgorithm.getAlgorithm().equals(SSEAlgorithm.AES256.getAlgorithm())) {
            this.sseCustomerKey = SSECustomerKey.generateSSECustomerKeyForPresignUrl(sSEAlgorithm.getAlgorithm());
        } else {
            throw new IllegalArgumentException("Currently the only supported Server Side Encryption algorithm is " + (Object)((Object)SSEAlgorithm.AES256));
        }
    }

    public GeneratePresignedUrlRequest withSSECustomerKeyAlgorithm(SSEAlgorithm sSEAlgorithm) {
        this.setSSECustomerKeyAlgorithm(sSEAlgorithm);
        return this;
    }

    public boolean isZeroByteContent() {
        return this.zeroByteContent;
    }

    public void setZeroByteContent(boolean bl) {
        this.zeroByteContent = bl;
    }

    public GeneratePresignedUrlRequest withZeroByteContent(boolean bl) {
        this.setZeroByteContent(bl);
        return this;
    }

    public void rejectIllegalArguments() {
        if (this.bucketName == null) {
            throw new IllegalArgumentException("The bucket name parameter must be specified when generating a pre-signed URL");
        }
        if (this.method == null) {
            throw new IllegalArgumentException("The HTTP method request parameter must be specified when generating a pre-signed URL");
        }
        if (this.sseCustomerKey != null) {
            if (this.sseAlgorithm != null) {
                throw new IllegalArgumentException("Either SSE or SSE-C can be specified but not both");
            }
            if (this.kmsCmkId != null) {
                throw new IllegalArgumentException("KMS CMK is not applicable for SSE-C");
            }
        } else if (this.kmsCmkId != null && !SSEAlgorithm.KMS.getAlgorithm().equals(this.sseAlgorithm)) {
            throw new IllegalArgumentException("For KMS server side encryption, the SSE algorithm must be set to " + (Object)((Object)SSEAlgorithm.KMS));
        }
    }
}

