/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import java.io.Serializable;
import java.security.Provider;
import java.security.SecureRandom;

@Deprecated
public class CryptoConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8646831898339939580L;
    private static final SecureRandom SRAND = new SecureRandom();
    private CryptoMode cryptoMode;
    private CryptoStorageMode storageMode;
    private Provider cryptoProvider;
    private boolean alwaysUseCryptoProvider;
    private SecureRandom secureRandom;
    private boolean ignoreMissingInstructionFile = true;
    private transient Region awskmsRegion;

    public CryptoConfiguration() {
        this(CryptoMode.EncryptionOnly);
    }

    public CryptoConfiguration(CryptoMode cryptoMode) {
        this.check(cryptoMode);
        this.storageMode = CryptoStorageMode.ObjectMetadata;
        this.cryptoProvider = null;
        this.secureRandom = SRAND;
        this.cryptoMode = cryptoMode;
    }

    public void setStorageMode(CryptoStorageMode cryptoStorageMode) {
        this.storageMode = cryptoStorageMode;
    }

    public CryptoConfiguration withStorageMode(CryptoStorageMode cryptoStorageMode) {
        this.storageMode = cryptoStorageMode;
        return this;
    }

    public CryptoStorageMode getStorageMode() {
        return this.storageMode;
    }

    public void setCryptoProvider(Provider provider) {
        this.cryptoProvider = provider;
    }

    public CryptoConfiguration withCryptoProvider(Provider provider) {
        this.cryptoProvider = provider;
        return this;
    }

    public Provider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setAlwaysUseCryptoProvider(boolean bl) {
        this.alwaysUseCryptoProvider = bl;
    }

    public CryptoConfiguration withAlwaysUseCryptoProvider(boolean bl) {
        this.alwaysUseCryptoProvider = bl;
        return this;
    }

    public boolean getAlwaysUseCryptoProvider() {
        return this.alwaysUseCryptoProvider;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public CryptoConfiguration withSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public CryptoMode getCryptoMode() {
        return this.cryptoMode;
    }

    public void setCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.cryptoMode = cryptoMode;
        this.check(cryptoMode);
    }

    public CryptoConfiguration withCryptoMode(CryptoMode cryptoMode) throws UnsupportedOperationException {
        this.cryptoMode = cryptoMode;
        this.check(cryptoMode);
        return this;
    }

    public boolean isIgnoreMissingInstructionFile() {
        return this.ignoreMissingInstructionFile;
    }

    public void setIgnoreMissingInstructionFile(boolean bl) {
        this.ignoreMissingInstructionFile = bl;
    }

    public CryptoConfiguration withIgnoreMissingInstructionFile(boolean bl) {
        this.ignoreMissingInstructionFile = bl;
        return this;
    }

    private void check(CryptoMode cryptoMode) {
        boolean bl;
        boolean bl2 = cryptoMode == CryptoMode.AuthenticatedEncryption || cryptoMode == CryptoMode.StrictAuthenticatedEncryption;
        boolean bl3 = bl = this.cryptoProvider != null && this.alwaysUseCryptoProvider;
        if (bl2 && !bl) {
            if (!CryptoRuntime.isBouncyCastleAvailable()) {
                CryptoRuntime.enableBouncyCastle();
                if (!CryptoRuntime.isBouncyCastleAvailable()) {
                    throw new UnsupportedOperationException("The Bouncy castle library jar is required on the classpath to enable authenticated encryption");
                }
            }
            if (!CryptoRuntime.isAesGcmAvailable()) {
                throw new UnsupportedOperationException("More recent version of the Bouncy castle library is required to enable authenticated encryption");
            }
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public CryptoConfiguration readOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return this.copyTo(new ReadOnly());
    }

    public CryptoConfiguration clone() {
        return this.copyTo(new CryptoConfiguration());
    }

    private CryptoConfiguration copyTo(CryptoConfiguration cryptoConfiguration) {
        cryptoConfiguration.cryptoMode = this.cryptoMode;
        cryptoConfiguration.storageMode = this.storageMode;
        cryptoConfiguration.cryptoProvider = this.cryptoProvider;
        cryptoConfiguration.alwaysUseCryptoProvider = this.alwaysUseCryptoProvider;
        cryptoConfiguration.secureRandom = this.secureRandom;
        cryptoConfiguration.ignoreMissingInstructionFile = this.ignoreMissingInstructionFile;
        cryptoConfiguration.awskmsRegion = this.awskmsRegion;
        return cryptoConfiguration;
    }

    @Deprecated
    public Regions getKmsRegion() {
        if (this.awskmsRegion == null) {
            return null;
        }
        return Regions.fromName(this.awskmsRegion.getName());
    }

    @Deprecated
    public void setKmsRegion(Regions regions) {
        if (regions != null) {
            this.setAwsKmsRegion(Region.getRegion(regions));
        } else {
            this.setAwsKmsRegion(null);
        }
    }

    @Deprecated
    public CryptoConfiguration withKmsRegion(Regions regions) {
        this.setKmsRegion(regions);
        return this;
    }

    public Region getAwsKmsRegion() {
        return this.awskmsRegion;
    }

    public void setAwsKmsRegion(Region region) {
        this.awskmsRegion = region;
    }

    public CryptoConfiguration withAwsKmsRegion(Region region) {
        this.awskmsRegion = region;
        return this;
    }

    private static final class ReadOnly
    extends CryptoConfiguration {
        private ReadOnly() {
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void setStorageMode(CryptoStorageMode cryptoStorageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withStorageMode(CryptoStorageMode cryptoStorageMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoProvider(Provider provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withCryptoProvider(Provider provider) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAlwaysUseCryptoProvider(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withAlwaysUseCryptoProvider(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSecureRandom(SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withSecureRandom(SecureRandom secureRandom) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withCryptoMode(CryptoMode cryptoMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIgnoreMissingInstructionFile(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withIgnoreMissingInstructionFile(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setKmsRegion(Regions regions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CryptoConfiguration withKmsRegion(Regions regions) {
            throw new UnsupportedOperationException();
        }
    }
}

