/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.internal.S3RequesterChargedResult;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AccessControlList
implements S3RequesterChargedResult,
Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    private Set<Grant> grantSet;
    private List<Grant> grantList;
    private Owner owner = null;
    private boolean isRequesterCharged;

    public Owner getOwner() {
        return this.owner;
    }

    public AccessControlList withOwner(Owner owner) {
        this.owner = owner;
        return this;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        this.getGrantsAsList().add(new Grant(grantee, permission));
    }

    public void grantAllPermissions(Grant ... grantArray) {
        for (Grant grant : grantArray) {
            this.grantPermission(grant.getGrantee(), grant.getPermission());
        }
    }

    public void revokeAllPermissions(Grantee grantee) {
        ArrayList<Grant> arrayList = new ArrayList<Grant>();
        List<Grant> list = this.getGrantsAsList();
        for (Grant grant : list) {
            if (!grant.getGrantee().equals(grantee)) continue;
            arrayList.add(grant);
        }
        this.grantList.removeAll(arrayList);
    }

    @Deprecated
    public Set<Grant> getGrants() {
        this.checkState();
        if (this.grantSet == null) {
            if (this.grantList == null) {
                this.grantSet = new HashSet<Grant>();
            } else {
                this.grantSet = new HashSet<Grant>(this.grantList);
                this.grantList = null;
            }
        }
        return this.grantSet;
    }

    private void checkState() {
        if (this.grantSet != null && this.grantList != null) {
            throw new IllegalStateException("Both grant set and grant list cannot be null");
        }
    }

    public List<Grant> getGrantsAsList() {
        this.checkState();
        if (this.grantList == null) {
            if (this.grantSet == null) {
                this.grantList = new LinkedList<Grant>();
            } else {
                this.grantList = new LinkedList<Grant>(this.grantSet);
                this.grantSet = null;
            }
        }
        return this.grantList;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.owner == null ? 0 : this.owner.hashCode());
        n2 = 31 * n2 + (this.grantSet == null ? 0 : this.grantSet.hashCode());
        n2 = 31 * n2 + (this.grantList == null ? 0 : this.grantList.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessControlList accessControlList = (AccessControlList)object;
        if (this.owner == null ? accessControlList.owner != null : !this.owner.equals(accessControlList.owner)) {
            return false;
        }
        if (this.grantSet == null ? accessControlList.grantSet != null : !this.grantSet.equals(accessControlList.grantSet)) {
            return false;
        }
        return !(this.grantList == null ? accessControlList.grantList != null : !this.grantList.equals(accessControlList.grantList));
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrantsAsList() + "]";
    }

    @Override
    public boolean isRequesterCharged() {
        return this.isRequesterCharged;
    }

    @Override
    public void setRequesterCharged(boolean bl) {
        this.isRequesterCharged = bl;
    }
}

