/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.eventstreaming;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.services.s3.internal.eventstreaming.Checksums;
import com.amazonaws.services.s3.internal.eventstreaming.Header;
import com.amazonaws.services.s3.internal.eventstreaming.HeaderValue;
import com.amazonaws.services.s3.internal.eventstreaming.Prelude;
import com.amazonaws.services.s3.internal.eventstreaming.Utils;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class Message {
    private static final int TRAILING_CRC_LENGTH = 4;
    static final int MESSAGE_OVERHEAD = 16;
    private final Map<String, HeaderValue> headers;
    private final byte[] payload;

    public Message(Map<String, HeaderValue> map, byte[] byArray) {
        this.headers = map;
        this.payload = (byte[])byArray.clone();
    }

    public Map<String, HeaderValue> getHeaders() {
        return this.headers;
    }

    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    public static Message decode(ByteBuffer byteBuffer) {
        Prelude prelude = Prelude.decode(byteBuffer);
        int n = prelude.getTotalLength();
        Message.validateMessageCrc(byteBuffer, n);
        byteBuffer.position(byteBuffer.position() + 12);
        long l = prelude.getHeadersLength();
        byte[] byArray = new byte[Utils.toIntExact(l)];
        byteBuffer.get(byArray);
        Map<String, HeaderValue> map = Message.decodeHeaders(ByteBuffer.wrap(byArray));
        byte[] byArray2 = new byte[Utils.toIntExact((long)(n - 16) - l)];
        byteBuffer.get(byArray2);
        byteBuffer.getInt();
        return new Message(map, byArray2);
    }

    private static void validateMessageCrc(ByteBuffer byteBuffer, int n) {
        CRC32 cRC32 = new CRC32();
        Checksums.update(cRC32, (ByteBuffer)byteBuffer.duplicate().limit(byteBuffer.position() + n - 4));
        long l = cRC32.getValue();
        long l2 = Utils.toUnsignedLong(byteBuffer.getInt(byteBuffer.position() + n - 4));
        if (l2 != l) {
            throw new SdkClientException(new CRC32MismatchException(String.format("Message checksum failure: expected 0x%x, computed 0x%x", l2, l)));
        }
    }

    static Map<String, HeaderValue> decodeHeaders(ByteBuffer byteBuffer) {
        HashMap<String, HeaderValue> hashMap = new HashMap<String, HeaderValue>();
        while (byteBuffer.hasRemaining()) {
            Header header = Header.decode(byteBuffer);
            hashMap.put(header.getName(), header.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public ByteBuffer toByteBuffer() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.encode(byteArrayOutputStream);
            byteArrayOutputStream.close();
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void encode(OutputStream outputStream2) {
        try {
            CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream2, new CRC32());
            this.encodeOrThrow(checkedOutputStream);
            long l = checkedOutputStream.getChecksum().getValue();
            outputStream2.write((int)(0xFFL & l >> 24));
            outputStream2.write((int)(0xFFL & l >> 16));
            outputStream2.write((int)(0xFFL & l >> 8));
            outputStream2.write((int)(0xFFL & l));
            outputStream2.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void encodeOrThrow(OutputStream outputStream2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (Map.Entry<String, HeaderValue> object2 : this.headers.entrySet()) {
            Header.encode(object2, dataOutputStream);
        }
        dataOutputStream.write(this.payload);
        dataOutputStream.flush();
        int n = 12 + byteArrayOutputStream.size() + 4;
        Object object3 = this.getPrelude(n);
        CRC32 cRC32 = new CRC32();
        cRC32.update((byte[])object3, 0, ((Object)object3).length);
        DataOutputStream dataOutputStream2 = new DataOutputStream(outputStream2);
        dataOutputStream2.write((byte[])object3);
        long l = cRC32.getValue();
        int n2 = (int)l;
        dataOutputStream2.writeInt(n2);
        dataOutputStream2.flush();
        byteArrayOutputStream.writeTo(outputStream2);
    }

    private byte[] getPrelude(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = n - 16 - this.payload.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        if (!this.headers.equals(message.headers)) {
            return false;
        }
        return Arrays.equals(this.payload, message.payload);
    }

    public int hashCode() {
        int n = this.headers.hashCode();
        n = 31 * n + Arrays.hashCode(this.payload);
        return n;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, HeaderValue> object2 : this.headers.entrySet()) {
            stringBuilder.append(object2.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(object2.getValue().toString());
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        Object object3 = this.headers.get("content-type");
        if (object3 == null) {
            object3 = HeaderValue.fromString("application/octet-stream");
        }
        if ((string = ((HeaderValue)object3).getString()).contains("json") || string.contains("text")) {
            stringBuilder.append(new String(this.payload, StringUtils.UTF8));
        } else {
            stringBuilder.append(Base64.encodeAsString(this.payload));
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

