/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v2;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.v2.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.v2.S3CryptoModuleAE;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.S3ObjectId;

public class S3CryptoModuleAEStrict
extends S3CryptoModuleAE {
    public S3CryptoModuleAEStrict(AWSKMS aWSKMS, S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfigurationV2 cryptoConfigurationV2) {
        super(aWSKMS, s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfigurationV2);
        if (cryptoConfigurationV2.getCryptoMode() != CryptoMode.StrictAuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final boolean isStrict() {
        return true;
    }

    @Override
    protected void securityCheck(ContentCryptoMaterial contentCryptoMaterial, S3ObjectId s3ObjectId, boolean bl) {
        if (!bl && !ContentCryptoScheme.AES_GCM.equals(contentCryptoMaterial.getContentCryptoScheme())) {
            throw new SecurityException("S3 object [bucket: " + s3ObjectId.getBucket() + ", key: " + s3ObjectId.getKey() + "] not encrypted using authenticated encryption");
        }
    }
}

