/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v1;

import com.amazonaws.services.s3.internal.crypto.v1.SecuredCEK;
import java.util.Map;

final class KMSSecuredCEK
extends SecuredCEK {
    static final String KEY_PROTECTION_MECHANISM_V1 = "kms";
    static final String KEY_PROTECTION_MECHANISM_V2 = "kms+context";

    KMSSecuredCEK(byte[] byArray, Map<String, String> map) {
        super(byArray, KEY_PROTECTION_MECHANISM_V1, map);
    }

    public static boolean isKMSKeyWrapped(String string) {
        return KMSSecuredCEK.isKMSV1KeyWrapped(string) || KMSSecuredCEK.isKMSV2KeyWrapped(string);
    }

    public static boolean isKMSV1KeyWrapped(String string) {
        return KEY_PROTECTION_MECHANISM_V1.equals(string);
    }

    public static boolean isKMSV2KeyWrapped(String string) {
        return KEY_PROTECTION_MECHANISM_V2.equals(string);
    }
}

