/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.keywrap;

import com.amazonaws.services.s3.internal.crypto.keywrap.CipherProvider;
import com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import com.amazonaws.services.s3.internal.crypto.keywrap.Mgf1Scheme;
import com.amazonaws.util.Throwables;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public final class RsaOaepKeyWrapper
implements KeyWrapper {
    private static final String CIPHER_ALGORITHM = "RSA/ECB/OAEPPadding";
    private static final Map<InternalKeyWrapAlgorithm, String> DIGEST_SCHEME_MAP;
    private static final Map<InternalKeyWrapAlgorithm, Mgf1Scheme> MGF1_SCHEME_MAP;
    private final CipherProvider cipherProvider;
    private final String digestScheme;
    private final Mgf1Scheme mgf1Scheme;
    private final InternalKeyWrapAlgorithm cryptoKeyWrapAlgorithm;
    private final String cekAlgorithm;
    private final byte[] encodedCekAlgorithm;

    private RsaOaepKeyWrapper(Builder builder) {
        this.cipherProvider = this.validateNotNull(builder.cipherProvider, "cipherProvider");
        this.cryptoKeyWrapAlgorithm = this.validateNotNull(builder.cryptoKeyWrapAlgorithm, "cryptoKeyAlgorithm");
        this.cekAlgorithm = this.validateNotNull(builder.cekAlgorithm, "cekAlgorithm");
        this.encodedCekAlgorithm = builder.cekAlgorithm.getBytes(StandardCharsets.UTF_8);
        this.digestScheme = DIGEST_SCHEME_MAP.get((Object)this.cryptoKeyWrapAlgorithm);
        this.mgf1Scheme = MGF1_SCHEME_MAP.get((Object)this.cryptoKeyWrapAlgorithm);
        if (this.mgf1Scheme == null) {
            throw new IllegalArgumentException("No valid MGF1 scheme could be found for cryptoKeyAlgorithm '" + this.cryptoKeyWrapAlgorithm.algorithmName() + "'");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String cipherAlgorithm() {
        return CIPHER_ALGORITHM;
    }

    @Override
    public byte[] unwrapCek(byte[] byArray, Key key) {
        Cipher cipher = this.cipherProvider.createCipher();
        OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec(this.digestScheme, "MGF1", this.mgf1Scheme.getMgf1ParameterSpec(), PSource.PSpecified.DEFAULT);
        try {
            cipher.init(4, key, oAEPParameterSpec);
            Key key2 = cipher.unwrap(byArray, "AES", 3);
            return this.splitConcatenatedKey(key2.getEncoded());
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "An exception was thrown when attempting to decrypt the Content Encryption Key");
        }
    }

    @Override
    public byte[] wrapCek(byte[] byArray, Key key) {
        Cipher cipher = this.cipherProvider.createCipher();
        OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec(this.digestScheme, "MGF1", this.mgf1Scheme.getMgf1ParameterSpec(), PSource.PSpecified.DEFAULT);
        try {
            cipher.init(3, key, oAEPParameterSpec);
            return cipher.wrap(new SecretKeySpec(this.createCompositeCek(byArray), "AES"));
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "An exception was thrown when attempting to encrypt the Content Encryption Key");
        }
    }

    public CipherProvider cipherProvider() {
        return this.cipherProvider;
    }

    public Mgf1Scheme mgf1Scheme() {
        return this.mgf1Scheme;
    }

    public String cekAlgorithm() {
        return this.cekAlgorithm;
    }

    private <T> T validateNotNull(T t2, String string) {
        if (t2 == null) {
            throw new NullPointerException("Error initializing RsaOaepKeyWrapper: '" + string + "' cannot be null");
        }
        return t2;
    }

    private byte[] createCompositeCek(byte[] byArray) {
        int n = 1 + byArray.length + this.encodedCekAlgorithm.length;
        byte[] byArray2 = new byte[n];
        byArray2[0] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        System.arraycopy(this.encodedCekAlgorithm, 0, byArray2, 1 + byArray.length, this.encodedCekAlgorithm.length);
        return byArray2;
    }

    private byte[] splitConcatenatedKey(byte[] byArray) {
        byte by = byArray[0];
        int n = byArray.length - by - 1;
        if (!RsaOaepKeyWrapper.isValidKeyLength(by)) {
            throw new SecurityException("invalid key length in composite CEK");
        }
        if (n <= 0) {
            throw new SecurityException("invalid algorithm length in composite CEK");
        }
        byte[] byArray2 = new byte[by];
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 1, byArray2, 0, by);
        System.arraycopy(byArray, 1 + by, byArray3, 0, n);
        if (!Arrays.equals(byArray3, this.encodedCekAlgorithm)) {
            throw new SecurityException("The content encryption algorithm used at encryption time does not match the algorithm stored for decryption time. The object may be altered or corrupted.");
        }
        return byArray2;
    }

    private static boolean isValidKeyLength(int n) {
        return n == 16 || n == 24 || n == 32;
    }

    static {
        HashMap<InternalKeyWrapAlgorithm, String> hashMap = new HashMap<InternalKeyWrapAlgorithm, String>();
        hashMap.put(InternalKeyWrapAlgorithm.RSA_OAEP_SHA1, "SHA-1");
        DIGEST_SCHEME_MAP = Collections.unmodifiableMap(hashMap);
        HashMap<InternalKeyWrapAlgorithm, Mgf1Scheme> hashMap2 = new HashMap<InternalKeyWrapAlgorithm, Mgf1Scheme>();
        hashMap2.put(InternalKeyWrapAlgorithm.RSA_OAEP_SHA1, Mgf1Scheme.MGF1_SHA1);
        MGF1_SCHEME_MAP = Collections.unmodifiableMap(hashMap2);
    }

    public static final class Builder {
        private CipherProvider cipherProvider;
        private InternalKeyWrapAlgorithm cryptoKeyWrapAlgorithm;
        private String cekAlgorithm;

        private Builder() {
        }

        public Builder cipherProvider(CipherProvider cipherProvider) {
            this.cipherProvider = cipherProvider;
            return this;
        }

        public Builder cryptoKeyWrapAlgorithm(InternalKeyWrapAlgorithm internalKeyWrapAlgorithm) {
            this.cryptoKeyWrapAlgorithm = internalKeyWrapAlgorithm;
            return this;
        }

        public Builder cekAlgorithm(String string) {
            this.cekAlgorithm = string;
            return this;
        }

        public RsaOaepKeyWrapper build() {
            return new RsaOaepKeyWrapper(this);
        }
    }
}

