/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class RenewableCipherLiteInputStream
extends CipherLiteInputStream {
    private boolean hasBeenAccessed;

    public RenewableCipherLiteInputStream(InputStream inputStream2, CipherLite cipherLite) {
        super(inputStream2, cipherLite);
    }

    public RenewableCipherLiteInputStream(InputStream inputStream2, CipherLite cipherLite, int n) {
        super(inputStream2, cipherLite, n);
    }

    public RenewableCipherLiteInputStream(InputStream inputStream2, CipherLite cipherLite, int n, boolean bl, boolean bl2) {
        super(inputStream2, cipherLite, n, bl, bl2);
    }

    protected RenewableCipherLiteInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void mark(int n) {
        this.abortIfNeeded();
        if (this.hasBeenAccessed) {
            throw new UnsupportedOperationException("Marking is only supported before your first call to read or skip.");
        }
        this.in.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
        this.renewCipherLite();
        this.resetInternal();
        this.hasBeenAccessed = false;
    }

    @Override
    public int read() throws IOException {
        this.hasBeenAccessed = true;
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.hasBeenAccessed = true;
        return super.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.hasBeenAccessed = true;
        return super.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.hasBeenAccessed = true;
        return super.skip(l);
    }
}

