/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.crypto.AesCbc;
import com.amazonaws.services.s3.internal.crypto.AesCtr;
import com.amazonaws.services.s3.internal.crypto.AesGcm;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public abstract class ContentCryptoScheme {
    public static final long MAX_GCM_BLOCKS = 0xFFFFFFFEL;
    public static final long MAX_GCM_BYTES = 0xFFFFFFFE0L;
    static final long MAX_CBC_BYTES = 0x10000000000000L;
    static final long MAX_CTR_BYTES = -1L;
    public static final ContentCryptoScheme AES_CBC = new AesCbc();
    public static final ContentCryptoScheme AES_GCM = new AesGcm();
    public static final ContentCryptoScheme AES_CTR = new AesCtr();

    public abstract String getKeyGeneratorAlgorithm();

    public abstract String getCipherAlgorithm();

    public String getPreferredCipherProvider() {
        return null;
    }

    public abstract int getKeyLengthInBits();

    public abstract int getBlockSizeInBytes();

    public abstract int getIVLengthInBytes();

    public int getTagLengthInBits() {
        return 0;
    }

    public byte[] adjustIV(byte[] byArray, long l) {
        return byArray;
    }

    public String toString() {
        return "cipherAlgo=" + this.getCipherAlgorithm() + ", blockSizeInBytes=" + this.getBlockSizeInBytes() + ", ivLengthInBytes=" + this.getIVLengthInBytes() + ", keyGenAlgo=" + this.getKeyGeneratorAlgorithm() + ", keyLengthInBits=" + this.getKeyLengthInBits() + ", preferredProvider=" + this.getPreferredCipherProvider() + ", tagLengthInBits=" + this.getTagLengthInBits();
    }

    public static byte[] incrementBlocks(byte[] byArray, long l) {
        if (l == 0L) {
            return byArray;
        }
        if (byArray == null || byArray.length != 16) {
            throw new IllegalArgumentException();
        }
        if (l > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        for (int i = 12; i <= 15; ++i) {
            byteBuffer.put(i - 8, byArray[i]);
        }
        long l2 = byteBuffer.getLong() + l;
        if (l2 > 0xFFFFFFFEL) {
            throw new IllegalStateException();
        }
        byteBuffer.rewind();
        byte[] byArray2 = byteBuffer.putLong(l2).array();
        for (int i = 12; i <= 15; ++i) {
            byArray[i] = byArray2[i - 8];
        }
        return byArray;
    }

    public static ContentCryptoScheme fromCEKAlgo(String string) {
        return ContentCryptoScheme.fromCEKAlgo(string, false);
    }

    public static ContentCryptoScheme fromCEKAlgo(String string, boolean bl) {
        if (AES_GCM.getCipherAlgorithm().equals(string)) {
            return bl ? AES_CTR : AES_GCM;
        }
        if (string == null || AES_CBC.getCipherAlgorithm().equals(string)) {
            return AES_CBC;
        }
        throw new UnsupportedOperationException("Unsupported content encryption scheme: " + string);
    }

    public CipherLite createCipherLite(SecretKey secretKey, byte[] byArray, int n, Provider provider, boolean bl) {
        try {
            Cipher cipher = this.createCipher(provider, bl);
            cipher.init(n, (Key)secretKey, new IvParameterSpec(byArray));
            return this.newCipherLite(cipher, secretKey, n);
        }
        catch (Exception exception) {
            throw exception instanceof RuntimeException ? (RuntimeException)exception : new SdkClientException("Unable to build cipher: " + exception.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and configured for your JVM", exception);
        }
    }

    private Cipher createCipher(Provider provider, boolean bl) throws GeneralSecurityException {
        String string = this.getCipherAlgorithm();
        String string2 = this.getPreferredCipherProvider();
        if (bl) {
            return Cipher.getInstance(string, provider);
        }
        if (string2 != null) {
            return Cipher.getInstance(string, string2);
        }
        if (provider != null) {
            return Cipher.getInstance(string, provider);
        }
        return Cipher.getInstance(string);
    }

    protected CipherLite newCipherLite(Cipher cipher, SecretKey secretKey, int n) {
        return new CipherLite(cipher, this, secretKey, n);
    }

    CipherLite createAuxillaryCipher(SecretKey secretKey, byte[] byArray, int n, Provider provider, long l) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return null;
    }

    public CipherLite createCipherLite(SecretKey secretKey, byte[] byArray, int n) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.createCipherLite(secretKey, byArray, n, null, false);
    }

    abstract long getMaxPlaintextSize();

    public final String getKeySpec() {
        return this.getKeyGeneratorAlgorithm() + "_" + this.getKeyLengthInBits();
    }
}

