/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;

public class CipherLite {
    public static final CipherLite Null = new CipherLite(){

        @Override
        public CipherLite createAuxiliary(long l) {
            return this;
        }

        @Override
        public CipherLite createInverse() {
            return this;
        }
    };
    private final Cipher cipher;
    private final ContentCryptoScheme scheme;
    private final SecretKey secreteKey;
    private final int cipherMode;

    private CipherLite() {
        this.cipher = new NullCipher();
        this.scheme = null;
        this.secreteKey = null;
        this.cipherMode = -1;
    }

    CipherLite(Cipher cipher, ContentCryptoScheme contentCryptoScheme, SecretKey secretKey, int n) {
        this.cipher = cipher;
        this.scheme = contentCryptoScheme;
        this.secreteKey = secretKey;
        this.cipherMode = n;
    }

    public CipherLite recreate() {
        return this.scheme.createCipherLite(this.secreteKey, this.cipher.getIV(), this.cipherMode, this.cipher.getProvider(), true);
    }

    public CipherLite createUsingIV(byte[] byArray) {
        return this.scheme.createCipherLite(this.secreteKey, byArray, this.cipherMode, this.cipher.getProvider(), true);
    }

    public CipherLite createAuxiliary(long l) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        return this.scheme.createAuxillaryCipher(this.secreteKey, this.cipher.getIV(), this.cipherMode, this.cipher.getProvider(), l);
    }

    public CipherLite createInverse() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        int n;
        if (this.cipherMode == 2) {
            n = 1;
        } else if (this.cipherMode == 1) {
            n = 2;
        } else {
            throw new UnsupportedOperationException();
        }
        return this.scheme.createCipherLite(this.secreteKey, this.cipher.getIV(), n, this.cipher.getProvider(), true);
    }

    public byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal();
    }

    public byte[] doFinal(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray);
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    public byte[] update(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    public final String getCipherAlgorithm() {
        return this.cipher.getAlgorithm();
    }

    public final Provider getCipherProvider() {
        return this.cipher.getProvider();
    }

    public final String getSecretKeyAlgorithm() {
        return this.secreteKey.getAlgorithm();
    }

    public final Cipher getCipher() {
        return this.cipher;
    }

    public final ContentCryptoScheme getContentCryptoScheme() {
        return this.scheme;
    }

    public final byte[] getIV() {
        return this.cipher.getIV();
    }

    public final int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    final int getCipherMode() {
        return this.cipherMode;
    }

    public boolean markSupported() {
        return false;
    }

    public long mark() {
        return -1L;
    }

    public void reset() {
        throw new IllegalStateException("mark/reset not supported");
    }

    int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }
}

