/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.services.s3.internal.RestUtils;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.util.SdkHttpUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3Signer
extends AbstractAWSSigner {
    private static final Log log = LogFactory.getLog(S3Signer.class);
    private final String httpVerb;
    private final String resourcePath;
    private final Set<String> additionalQueryParamsToSign;

    public S3Signer() {
        this.httpVerb = null;
        this.resourcePath = null;
        this.additionalQueryParamsToSign = null;
    }

    public S3Signer(String string, String string2) {
        this(string, string2, null);
    }

    public S3Signer(String string, String string2, Collection<String> collection) {
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
        this.httpVerb = string;
        this.resourcePath = string2;
        this.additionalQueryParamsToSign = collection == null ? null : Collections.unmodifiableSet(new HashSet<String>(collection));
    }

    @Override
    public void sign(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials) {
        if (this.resourcePath == null) {
            throw new UnsupportedOperationException("Cannot sign a request using a dummy S3Signer instance with no resource path");
        }
        if (aWSCredentials == null || aWSCredentials.getAWSSecretKey() == null) {
            log.debug("Canonical string will not be signed, as no AWS Secret Key was provided");
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(signableRequest, (AWSSessionCredentials)aWSCredentials2);
        }
        String string = SdkHttpUtils.appendUri(signableRequest.getEndpoint().getPath(), SdkHttpUtils.urlEncode(this.resourcePath, true), true);
        int n = signableRequest.getTimeOffset();
        Date date = this.getSignatureDate(n);
        signableRequest.addHeader("Date", ServiceUtils.formatRfc822Date(date));
        String string2 = RestUtils.makeS3CanonicalString(this.httpVerb, string, signableRequest, null, this.additionalQueryParamsToSign);
        log.debug("Calculated string to sign:\n\"" + string2 + "\"");
        String string3 = super.signAndBase64Encode(string2, aWSCredentials2.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        signableRequest.addHeader("Authorization", "AWS " + aWSCredentials2.getAWSAccessKeyId() + ":" + string3);
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> signableRequest, AWSSessionCredentials aWSSessionCredentials) {
        signableRequest.addHeader("x-amz-security-token", aWSSessionCredentials.getSessionToken());
    }
}

