/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.util.HostnameValidator;
import java.net.URI;

public class S3ObjectLambdaEndpointBuilder {
    private URI endpointOverride;
    private String accessPointName;
    private String region;
    private String accountId;
    private String protocol;
    private String domain;
    private Boolean fipsEnabled;
    private Boolean dualstackEnabled;

    private S3ObjectLambdaEndpointBuilder() {
    }

    public static S3ObjectLambdaEndpointBuilder create() {
        return new S3ObjectLambdaEndpointBuilder();
    }

    public S3ObjectLambdaEndpointBuilder withEndpointOverride(URI uRI) {
        this.endpointOverride = uRI;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withAccessPointName(String string) {
        this.accessPointName = string;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withRegion(String string) {
        this.region = string;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withAccountId(String string) {
        this.accountId = string;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withProtocol(String string) {
        this.protocol = string;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withDomain(String string) {
        this.domain = string;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withFipsEnabled(Boolean bl) {
        this.fipsEnabled = bl;
        return this;
    }

    public S3ObjectLambdaEndpointBuilder withDualstackEnabled(Boolean bl) {
        this.dualstackEnabled = bl;
        return this;
    }

    public URI toURI() {
        String string;
        String string2;
        HostnameValidator.validateHostnameCompliant(this.accountId, "accountId", "object lambda ARN");
        HostnameValidator.validateHostnameCompliant(this.accessPointName, "accessPointName", "object lambda ARN");
        String string3 = string2 = Boolean.TRUE.equals(this.fipsEnabled) ? "-fips" : "";
        if (this.endpointOverride == null) {
            if (Boolean.TRUE.equals(this.dualstackEnabled)) {
                throw new IllegalArgumentException("S3 Object Lambda does not support Dual stack endpoints");
            }
            string = String.format("%s://%s-%s.s3-object-lambda%s.%s.%s", this.protocol, this.accessPointName, this.accountId, string2, this.region, this.domain);
        } else {
            StringBuilder stringBuilder = new StringBuilder(this.endpointOverride.getHost());
            if (this.endpointOverride.getPort() > 0) {
                stringBuilder.append(":").append(this.endpointOverride.getPort());
            }
            if (this.endpointOverride.getPath() != null) {
                stringBuilder.append(this.endpointOverride.getPath());
            }
            string = String.format("%s://%s-%s.%s", this.protocol, this.accessPointName, this.accountId, stringBuilder);
        }
        return URI.create(string);
    }
}

