/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.Throwables;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;

@SdkInternalApi
public final class S3AbortableInputStream
extends SdkFilterInputStream {
    private static final Log LOG = LogFactory.getLog(S3AbortableInputStream.class);
    private final HttpRequestBase httpRequest;
    private final long contentLength;
    private long bytesRead;
    private long markedBytes;
    private boolean eofReached = false;

    public S3AbortableInputStream(InputStream inputStream2, HttpRequestBase httpRequestBase, long l) {
        super(inputStream2);
        this.httpRequest = httpRequestBase;
        this.contentLength = l;
    }

    @Override
    public void abort() {
        super.abort();
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly(this.in, null);
    }

    @Override
    public int available() throws IOException {
        int n = super.available();
        return n == 0 ? 1 : n;
    }

    @Override
    public int read() throws IOException {
        try {
            int n = super.read();
            boolean bl = this.eofReached = n == -1;
            if (!this.eofReached) {
                ++this.bytesRead;
            }
            return n;
        }
        catch (Exception exception) {
            return this.onException(exception);
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = super.read(byArray, n, n2);
            boolean bl = this.eofReached = n3 == -1;
            if (!this.eofReached) {
                this.bytesRead += (long)n3;
            }
            return n3;
        }
        catch (Exception exception) {
            return this.onException(exception);
        }
    }

    @Override
    public synchronized void mark(int n) {
        super.mark(n);
        this.markedBytes = this.bytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.bytesRead = this.markedBytes;
        this.eofReached = false;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        try {
            long l2 = super.skip(l);
            if (l2 > 0L) {
                this.bytesRead += l2;
            }
            return l2;
        }
        catch (Exception exception) {
            return this.onException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        if (this._readAllBytes() || this.isAborted()) {
            super.close();
        } else {
            LOG.warn("Not all bytes were read from the S3ObjectInputStream, aborting HTTP connection. This is likely an error and may result in sub-optimal behavior. Request only the bytes you need via a ranged GET or drain the input stream after use.");
            if (this.httpRequest != null) {
                this.httpRequest.abort();
            }
            IOUtils.closeQuietly(this.in, null);
        }
    }

    @SdkTestInternalApi
    long getBytesRead() {
        return this.bytesRead;
    }

    @SdkTestInternalApi
    boolean isEofReached() {
        return this.eofReached;
    }

    private int onException(Exception exception) throws IOException {
        this.eofReached = true;
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw Throwables.failure(exception);
    }

    private boolean _readAllBytes() {
        return this.bytesRead >= this.contentLength || this.eofReached;
    }
}

