/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
@SdkInternalApi
public final class RegionalEndpointsOptionResolver {
    private static final Log log = LogFactory.getLog(RegionalEndpointsOptionResolver.class);
    private static final String ENV_VAR = "AWS_S3_US_EAST_1_REGIONAL_ENDPOINT";
    private static final String PROFILE_PROPERTY = "s3_us_east_1_regional_endpoint";
    private final AwsProfileFileLocationProvider configFileLocationProvider;
    private volatile String profileName;
    private volatile ProfilesConfigFile configFile;
    private volatile boolean profileLoadAttempted;

    public RegionalEndpointsOptionResolver() {
        this.configFileLocationProvider = AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER;
    }

    public RegionalEndpointsOptionResolver(AwsProfileFileLocationProvider awsProfileFileLocationProvider) {
        this.configFileLocationProvider = awsProfileFileLocationProvider;
    }

    public boolean useRegionalMode() {
        Option option = this.envVarOption();
        if (option == null) {
            option = this.profileOption();
        }
        return option == Option.REGIONAL;
    }

    private Option envVarOption() {
        String string = System.getenv(ENV_VAR);
        return this.resolveOption(string, String.format("Unexpected value set for %s environment variable: '%s'", ENV_VAR, string));
    }

    private synchronized Option profileOption() {
        String string = this.getProfileName();
        BasicProfile basicProfile = this.getProfile(string);
        if (basicProfile == null) {
            return null;
        }
        String string2 = basicProfile.getPropertyValue(PROFILE_PROPERTY);
        return this.resolveOption(string2, String.format("Unexpected option for '%s' property in profile '%s': %s", PROFILE_PROPERTY, string, string2));
    }

    private Option resolveOption(String string, String string2) {
        if (string == null) {
            return null;
        }
        if ("legacy".equalsIgnoreCase(string)) {
            return Option.LEGACY;
        }
        if ("regional".equalsIgnoreCase(string)) {
            return Option.REGIONAL;
        }
        throw new SdkClientException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProfileName() {
        if (this.profileName == null) {
            RegionalEndpointsOptionResolver regionalEndpointsOptionResolver = this;
            synchronized (regionalEndpointsOptionResolver) {
                if (this.profileName == null) {
                    this.profileName = AwsProfileNameLoader.INSTANCE.loadProfileName();
                }
            }
        }
        return this.profileName;
    }

    private synchronized BasicProfile getProfile(String string) {
        ProfilesConfigFile profilesConfigFile = this.getProfilesConfigFile();
        if (profilesConfigFile != null) {
            return profilesConfigFile.getAllBasicProfiles().get(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilesConfigFile getProfilesConfigFile() {
        if (!this.profileLoadAttempted) {
            RegionalEndpointsOptionResolver regionalEndpointsOptionResolver = this;
            synchronized (regionalEndpointsOptionResolver) {
                if (!this.profileLoadAttempted) {
                    File file = null;
                    try {
                        file = this.configFileLocationProvider.getLocation();
                        if (file != null) {
                            this.configFile = new ProfilesConfigFile(file);
                        }
                    }
                    catch (Exception exception) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unable to load config file " + file, exception);
                        }
                    }
                    finally {
                        this.profileLoadAttempted = true;
                    }
                }
            }
        }
        return this.configFile;
    }

    private static enum Option {
        LEGACY,
        REGIONAL;

    }
}

