/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AbortedException;
import com.amazonaws.services.s3.OnFileDelete;
import com.amazonaws.services.s3.UploadObjectObserver;
import com.amazonaws.services.s3.internal.FileDeletionEvent;
import com.amazonaws.services.s3.internal.PartCreationEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class MultiFileOutputStream
extends OutputStream
implements OnFileDelete {
    static final int DEFAULT_PART_SIZE = 0x500000;
    private final File root;
    private final String namePrefix;
    private int filesCreated;
    private long partSize = 0x500000L;
    private long diskLimit = Long.MAX_VALUE;
    private UploadObjectObserver observer;
    private int currFileBytesWritten;
    private long totalBytesWritten;
    private FileOutputStream os;
    private boolean closed;
    private Semaphore diskPermits;

    public MultiFileOutputStream() {
        this.root = new File(System.getProperty("java.io.tmpdir"));
        this.namePrefix = MultiFileOutputStream.yyMMdd_hhmmss() + "." + UUID.randomUUID();
    }

    public MultiFileOutputStream(File file, String string) {
        if (file == null || !file.isDirectory() || !file.canWrite()) {
            throw new IllegalArgumentException(file + " must be a writable directory");
        }
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Please specify a non-empty name prefix");
        }
        this.root = file;
        this.namePrefix = string;
    }

    public MultiFileOutputStream init(UploadObjectObserver uploadObjectObserver, long l, long l2) {
        if (uploadObjectObserver == null) {
            throw new IllegalArgumentException("Observer must be specified");
        }
        this.observer = uploadObjectObserver;
        if (l2 < l << 1) {
            throw new IllegalArgumentException("Maximum temporary disk space must be at least twice as large as the part size: partSize=" + l + ", diskSize=" + l2);
        }
        this.partSize = l;
        this.diskLimit = l2;
        int n = (int)(l2 / l);
        this.diskPermits = n < 0 ? null : new Semaphore(n);
        return this;
    }

    @Override
    public void write(int n) throws IOException {
        this.fos().write(n);
        ++this.currFileBytesWritten;
        ++this.totalBytesWritten;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray.length == 0) {
            return;
        }
        this.fos().write(byArray);
        this.currFileBytesWritten += byArray.length;
        this.totalBytesWritten += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length == 0) {
            return;
        }
        this.fos().write(byArray, n, n2);
        this.currFileBytesWritten += n2;
        this.totalBytesWritten += (long)n2;
    }

    private FileOutputStream fos() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream is already closed");
        }
        if (this.os == null || (long)this.currFileBytesWritten >= this.partSize) {
            if (this.os != null) {
                this.os.close();
                this.observer.onPartCreate(new PartCreationEvent(this.getFile(this.filesCreated), this.filesCreated, false, this));
            }
            this.currFileBytesWritten = 0;
            ++this.filesCreated;
            this.blockIfNecessary();
            File file = this.getFile(this.filesCreated);
            this.os = new FileOutputStream(file);
        }
        return this.os;
    }

    @Override
    public void onFileDelete(FileDeletionEvent fileDeletionEvent) {
        if (this.diskPermits != null) {
            this.diskPermits.release();
        }
    }

    private void blockIfNecessary() {
        if (this.diskPermits == null || this.diskLimit == Long.MAX_VALUE) {
            return;
        }
        try {
            this.diskPermits.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new AbortedException(interruptedException);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.os != null) {
            this.os.close();
            File file = this.getFile(this.filesCreated);
            if (file.length() == 0L) {
                if (!file.delete()) {
                    LogFactory.getLog(this.getClass()).debug("Ignoring failure to delete empty file " + file);
                }
            } else {
                this.observer.onPartCreate(new PartCreationEvent(this.getFile(this.filesCreated), this.filesCreated, true, this));
            }
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.getNumFilesWritten(); ++i) {
            File file = this.getFile(i);
            if (!file.exists() || file.delete()) continue;
            LogFactory.getLog(this.getClass()).debug("Ignoring failure to delete file " + file);
        }
    }

    public int getNumFilesWritten() {
        return this.filesCreated;
    }

    public File getFile(int n) {
        return new File(this.root, this.namePrefix + "." + n);
    }

    public long getPartSize() {
        return this.partSize;
    }

    public File getRoot() {
        return this.root;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    static String yyMMdd_hhmmss() {
        return DateTimeFormat.forPattern("yyMMdd-hhmmss").print(new DateTime());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getDiskLimit() {
        return this.diskLimit;
    }
}

