/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.ServiceEndpointBuilder;
import com.amazonaws.regions.Region;
import java.net.URI;
import java.net.URISyntaxException;

public class DualstackEndpointBuilder
extends ServiceEndpointBuilder {
    private final String serviceName;
    private final String protocol;
    private Region region;

    public DualstackEndpointBuilder(String string, String string2, Region region) {
        this.serviceName = string;
        this.protocol = string2;
        this.region = region;
    }

    @Override
    public DualstackEndpointBuilder withRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("Region cannot be null");
        }
        this.region = region;
        return this;
    }

    @Override
    public URI getServiceEndpoint() {
        String string = String.format("%s.%s.%s.%s", this.serviceName, "dualstack", this.region.getName(), this.region.getDomain());
        return this.toURI(this.stripProtocol(string));
    }

    private String stripProtocol(String string) {
        int n = string.indexOf("://");
        return n >= 0 ? string.substring(n + "://".length()) : string;
    }

    private URI toURI(String string) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", this.protocol, string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }
}

