/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.S3ResponseMetadata;
import com.amazonaws.services.s3.internal.ObjectExpirationHeaderHandler;
import com.amazonaws.services.s3.internal.ObjectRestoreHeaderHandler;
import com.amazonaws.services.s3.internal.S3MetadataResponseHandler;
import com.amazonaws.services.s3.internal.S3RequesterChargedHeaderHandler;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractS3ResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private static final Log log = LogFactory.getLog(S3MetadataResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected AmazonWebServiceResponse<T> parseResponseMetadata(HttpResponse httpResponse) {
        AmazonWebServiceResponse amazonWebServiceResponse = new AmazonWebServiceResponse();
        String string = httpResponse.getHeaders().get("x-amz-request-id");
        String string2 = httpResponse.getHeaders().get("x-amz-id-2");
        String string3 = httpResponse.getHeaders().get("X-Amz-Cf-Id");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AWS_REQUEST_ID", string);
        hashMap.put("HOST_ID", string2);
        hashMap.put("CLOUD_FRONT_ID", string3);
        amazonWebServiceResponse.setResponseMetadata(new S3ResponseMetadata(hashMap));
        return amazonWebServiceResponse;
    }

    protected void populateObjectMetadata(HttpResponse httpResponse, ObjectMetadata objectMetadata) {
        for (Map.Entry<String, String> entry : httpResponse.getHeaders().entrySet()) {
            String string = entry.getKey();
            if (StringUtils.beginsWithIgnoreCase(string, "x-amz-meta-")) {
                string = string.substring("x-amz-meta-".length());
                objectMetadata.addUserMetadata(string, entry.getValue());
                continue;
            }
            if (ignoredHeaders.contains(string)) continue;
            if (string.equalsIgnoreCase("Last-Modified")) {
                try {
                    objectMetadata.setHeader(string, ServiceUtils.parseRfc822Date(entry.getValue()));
                }
                catch (Exception exception) {
                    log.warn("Unable to parse last modified date: " + entry.getValue(), exception);
                }
                continue;
            }
            if (string.equalsIgnoreCase("Content-Length")) {
                try {
                    objectMetadata.setHeader(string, Long.parseLong(entry.getValue()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SdkClientException("Unable to parse content length. Header 'Content-Length' has corrupted data" + numberFormatException.getMessage(), numberFormatException);
                }
            }
            if (string.equalsIgnoreCase("ETag")) {
                objectMetadata.setHeader(string, ServiceUtils.removeQuotes(entry.getValue()));
                continue;
            }
            if (string.equalsIgnoreCase("Expires")) {
                objectMetadata.setHeader("Expires", entry.getValue());
                try {
                    objectMetadata.setHttpExpiresDate(DateUtils.parseRFC822Date(entry.getValue()));
                }
                catch (Exception exception) {
                    log.warn("Unable to parse http expiration date: " + entry.getValue(), exception);
                }
                continue;
            }
            if (string.equalsIgnoreCase("x-amz-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(objectMetadata, httpResponse);
                continue;
            }
            if (string.equalsIgnoreCase("x-amz-restore")) {
                new ObjectRestoreHeaderHandler<ObjectMetadata>().handle(objectMetadata, httpResponse);
                continue;
            }
            if (string.equalsIgnoreCase("x-amz-request-charged")) {
                new S3RequesterChargedHeaderHandler<ObjectMetadata>().handle(objectMetadata, httpResponse);
                continue;
            }
            if (string.equalsIgnoreCase("x-amz-mp-parts-count")) {
                try {
                    objectMetadata.setHeader(string, Integer.parseInt(entry.getValue()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SdkClientException("Unable to parse part count. Header x-amz-mp-parts-count has corrupted data" + numberFormatException.getMessage(), numberFormatException);
                }
            }
            if (string.equalsIgnoreCase("x-amz-server-side-encryption-bucket-key-enabled")) {
                objectMetadata.setBucketKeyEnabled("true".equals(entry.getValue()));
                continue;
            }
            objectMetadata.setHeader(string, entry.getValue());
        }
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-amz-request-id");
        ignoredHeaders.add("x-amz-id-2");
        ignoredHeaders.add("X-Amz-Cf-Id");
        ignoredHeaders.add("Connection");
    }
}

