/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public final class S3ObjectResource
implements S3Resource {
    private static final S3ResourceType S3_RESOURCE_TYPE = S3ResourceType.OBJECT;
    private final S3Resource parentS3Resource;
    private final String key;

    private S3ObjectResource(Builder builder) {
        this.parentS3Resource = this.validateParentS3Resource(builder.parentS3Resource);
        this.key = ValidationUtils.assertStringNotEmpty(builder.key, "key");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return S3_RESOURCE_TYPE.toString();
    }

    @Override
    public String getPartition() {
        return this.parentS3Resource.getPartition();
    }

    @Override
    public String getRegion() {
        return this.parentS3Resource.getRegion();
    }

    @Override
    public String getAccountId() {
        return this.parentS3Resource.getAccountId();
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public S3Resource getParentS3Resource() {
        return this.parentS3Resource;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        S3ObjectResource s3ObjectResource = (S3ObjectResource)object;
        if (this.parentS3Resource != null ? !this.parentS3Resource.equals(s3ObjectResource.parentS3Resource) : s3ObjectResource.parentS3Resource != null) {
            return false;
        }
        return this.key != null ? this.key.equals(s3ObjectResource.key) : s3ObjectResource.key == null;
    }

    public int hashCode() {
        int n = this.parentS3Resource != null ? this.parentS3Resource.hashCode() : 0;
        n = 31 * n + (this.key != null ? this.key.hashCode() : 0);
        return n;
    }

    private S3Resource validateParentS3Resource(S3Resource s3Resource) {
        ValidationUtils.assertNotNull(s3Resource, "parentS3Resource");
        if (!S3ResourceType.ACCESS_POINT.toString().equals(s3Resource.getType()) && !S3ResourceType.BUCKET.toString().equals(s3Resource.getType())) {
            throw new IllegalArgumentException("Invalid 'parentS3Resource' type. An S3 object resource must be associated with either a bucket or access-point parent resource.");
        }
        return s3Resource;
    }

    public static final class Builder {
        private S3Resource parentS3Resource;
        private String key;

        public void setParentS3Resource(S3Resource s3Resource) {
            this.parentS3Resource = s3Resource;
        }

        public Builder withParentS3Resource(S3Resource s3Resource) {
            this.setParentS3Resource(s3Resource);
            return this;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public Builder withKey(String string) {
            this.setKey(string);
            return this;
        }

        public S3ObjectResource build() {
            return new S3ObjectResource(this);
        }
    }
}

