/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.arn.Arn;
import com.amazonaws.arn.ArnConverter;
import com.amazonaws.arn.ArnResource;
import com.amazonaws.services.s3.S3AccessPointResource;
import com.amazonaws.services.s3.S3ArnUtils;
import com.amazonaws.services.s3.S3BucketResource;
import com.amazonaws.services.s3.S3ObjectResource;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.services.s3.internal.IntermediateOutpostResource;
import com.amazonaws.services.s3.internal.OutpostResourceType;
import com.amazonaws.services.s3.internal.S3ObjectLambdasResource;
import com.amazonaws.services.s3.internal.S3OutpostResource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SdkInternalApi
public class S3ArnConverter
implements ArnConverter<S3Resource> {
    private static final S3ArnConverter INSTANCE = new S3ArnConverter();
    private static final Pattern OBJECT_AP_PATTERN = Pattern.compile("^([0-9a-zA-Z-]+)/object/(.*)$");
    private static final String OBJECT_LAMBDAS_SERVICE = "s3-object-lambda";

    private S3ArnConverter() {
    }

    public static S3ArnConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public S3Resource convertArn(Arn arn) {
        S3ResourceType s3ResourceType;
        if (S3ArnConverter.isV1Arn(arn)) {
            return this.convertV1Arn(arn);
        }
        try {
            s3ResourceType = S3ResourceType.fromValue(arn.getResource().getResourceType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown ARN type '" + arn.getResource().getResourceType() + "'");
        }
        switch (s3ResourceType) {
            case ACCESS_POINT: {
                return this.parseS3AccessPointArn(arn);
            }
            case BUCKET: {
                return this.parseS3BucketArn(arn);
            }
            case OUTPOST: {
                return this.parseS3OutpostAccessPointArn(arn);
            }
        }
        throw new IllegalArgumentException("Unknown ARN type '" + arn.getResource().getResourceType() + "'");
    }

    private S3Resource convertV1Arn(Arn arn) {
        String string = arn.getResourceAsString();
        String[] stringArray = string.split("/", 2);
        if (stringArray.length > 1) {
            S3BucketResource s3BucketResource = S3BucketResource.builder().withPartition(arn.getPartition()).withBucketName(stringArray[0]).build();
            return S3ObjectResource.builder().withParentS3Resource(s3BucketResource).withKey(stringArray[1]).build();
        }
        return S3BucketResource.builder().withPartition(arn.getPartition()).withBucketName(string).build();
    }

    private S3Resource parseS3OutpostAccessPointArn(Arn arn) {
        IntermediateOutpostResource intermediateOutpostResource = S3ArnUtils.parseOutpostArn(arn);
        ArnResource arnResource = intermediateOutpostResource.getOutpostSubresource();
        if (!OutpostResourceType.OUTPOST_ACCESS_POINT.toString().equals(arnResource.getResourceType())) {
            throw new IllegalArgumentException("Unknown outpost ARN type '" + arnResource.getResourceType() + "'");
        }
        return S3AccessPointResource.builder().withAccessPointName(arnResource.getResource()).withParentS3Resource(S3OutpostResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withOutpostId(intermediateOutpostResource.getOutpostId()).build()).build();
    }

    private S3BucketResource parseS3BucketArn(Arn arn) {
        return S3BucketResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withBucketName(arn.getResource().getResource()).build();
    }

    private S3Resource parseS3AccessPointArn(Arn arn) {
        Matcher matcher = OBJECT_AP_PATTERN.matcher(arn.getResource().getResource());
        if (matcher.matches()) {
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            S3AccessPointResource s3AccessPointResource = S3AccessPointResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withAccessPointName(string).build();
            return S3ObjectResource.builder().withParentS3Resource(s3AccessPointResource).withKey(string2).build();
        }
        if (OBJECT_LAMBDAS_SERVICE.equals(arn.getService())) {
            return this.parseS3ObjectLambdasAccessPointArn(arn);
        }
        return S3AccessPointResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withAccessPointName(arn.getResource().getResource()).build();
    }

    private S3Resource parseS3ObjectLambdasAccessPointArn(Arn arn) {
        S3ObjectLambdasResource s3ObjectLambdasResource = S3ObjectLambdasResource.builder().withAccountId(arn.getAccountId()).withRegion(arn.getRegion()).withPartition(arn.getPartition()).withAccessPointName(arn.getResource().getResource()).build();
        return S3AccessPointResource.builder().withAccessPointName(s3ObjectLambdasResource.getAccessPointName()).withParentS3Resource(s3ObjectLambdasResource).build();
    }

    private static boolean isV1Arn(Arn arn) {
        return arn.getAccountId() == null && arn.getRegion() == null;
    }
}

